/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.contexto.ContextoCTFClient;
import com.csi.ctfclient.operacoes.model.ControladorInicioDia;
import com.csi.ctfclient.operacoes.model.DadosInicioDia;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.VerifyContentUtil;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MicSolicitacaoEcommerceAutenticado {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";

    public String execute(Process dados) throws Exception {
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        ContextoCTFClient contextoCTFClient = Contexto.getContexto();
        EntradaCTFClientCtrl entradaIntegracao = contextoCTFClient.getEntradaIntegracao();
        IdentApiTefC ident = new IdentApiTefC();
        EntradaApiTefC entrada = new EntradaApiTefC();
        IdentTerminal identTerminal = entradaIntegracao.getIdentTerminal();
        ident.setNumeroEstabelecimento(identTerminal.getEstabelecimento());
        ident.setNumeroLoja(identTerminal.getLoja());
        ident.setNumeroPdv(identTerminal.getTerminal());
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        if (entradaIntegracao.isMultiTerminal()) {
            DadosInicioDia dadosInicioDia = ControladorInicioDia.getInstance().getDadosInicioDia(identTerminal);
            entrada.setDataCliente(dadosInicioDia.getDataInicioDia());
        } else {
            entrada.setDataCliente(entradaIntegracao.getDataAbertura());
        }
        entrada.setTipoPin("**");
        entrada.setTimeoutCtf(30);
        entrada.setTimestamp(new Date());
        entrada.setIdentificacaoTransacao(2);
        entrada.setOperacao(this.getOperacaoCTF(entradaIntegracao.getOperacao()));
        entrada.setNumeroTransacao(entradaIntegracao.getNumeroTransacao());
        entrada.setValorTransacao(entradaIntegracao.getValorTransacao());
        entrada.setNumeroParcelas(1);
        entrada.setModoEntrada(1);
        entrada.setInfo(entradaIntegracao.getNumeroCartao());
        entrada.setPAN(entradaIntegracao.getNumeroCartao());
        String codSeguranca = entradaIntegracao.getCodigoSeguraca();
        if (codSeguranca == null || codSeguranca.trim().length() == 0) {
            entrada.setMotivoCVV2('9');
        } else {
            entrada.setCvv2(codSeguranca);
        }
        if (entradaIntegracao.isDataVencimentoCartaoCtrl()) {
            Date dataVencimento = this.getDataVencimento(entradaIntegracao.getDataVencimentoCartao());
            entrada.setDataVencimento(dataVencimento);
        }
        if (entradaIntegracao.isEcidCtrl()) {
            entrada.setEcid(entradaIntegracao.getEcid());
        }
        if (entradaIntegracao.isUcafCtrl()) {
            entrada.setUcaf(entradaIntegracao.getUcaf());
        }
        if (entradaIntegracao.isXidCtrl()) {
            entrada.setXid(entradaIntegracao.getXid());
        }
        if (entradaIntegracao.isSoftDescriptorCtrl()) {
            entrada.setSoftDescriptor(entradaIntegracao.getSoftDescriptor());
        }
        if (entradaIntegracao.isMccCtrl()) {
            entrada.setMcc(entradaIntegracao.getMcc());
        }
        SaidaApiTefC saida = dados.getApitef().solicitacao(ident, entrada);
        VerifyContentUtil.preencheDadosSaida(saida);
        Contexto.getContexto().atualizaEntradaApiTefC(entrada);
        Contexto.getContexto().setSaidaApiTefC(saida);
        if (saida.getRetorno() != 0) {
            return ERROR;
        }
        return SUCCESS;
    }

    protected String getOperacaoCTF(int codigoTransacao) {
        if (codigoTransacao == 101) {
            return "10";
        }
        if (codigoTransacao == 120) {
            return "24";
        }
        if (codigoTransacao == 122) {
            return "25";
        }
        if (codigoTransacao == 121) {
            return "1E";
        }
        return null;
    }

    public Date getDataVencimento(String vencimento) {
        try {
            int year = 2000 + Integer.parseInt(vencimento.substring(2));
            int month = Integer.parseInt(vencimento.substring(0, 2));
            int day = 1;
            String dataString = StringUtil.completaString("" + day, 2, '0', 3);
            dataString = dataString + StringUtil.completaString("" + month, 2, '0', 3);
            dataString = dataString + year;
            Date date = new SimpleDateFormat("ddMMyyyy").parse(dataString);
            return date;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Vencimento Invalido " + vencimento);
        }
    }
}

