/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Plano;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.microoperacoes.MicAbstractSolicitacaoCartaoTEF;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.operacoes.util.CriptografiaOperacoesUtil;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.PinEMV;

public class MicSolicitacaoSaqueTransferencia
extends MicAbstractSolicitacaoCartaoTEF {
    @Override
    protected String getCodigoTransacao(Process dados) throws IllegalStateException {
        ControladorPerifericos periferico = dados.getPerifericos();
        PinEMV pinEMV = null;
        try {
            pinEMV = periferico.getPin();
        }
        catch (ExcecaoPerifericos e) {
            e.printStackTrace();
        }
        String tipoOperacao = Contexto.getContexto().getTipoOperacao();
        CriptografiaOperacoesUtil.atualizaEntradaCriptografia(pinEMV, ControladorCriptografia.getTabelaCriptografia());
        if ("OPE_SAQUE_TRANSFERENCIA_CREDITO".equals(tipoOperacao)) {
            if (Contexto.getContexto().getPlano() == Plano.AVISTA) {
                return "3K";
            }
            if (Contexto.getContexto().getPlano() == Plano.ADMINISTRADORA) {
                return "3Q";
            }
            throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrado. Verificar o tipo de financiamento - saque transferencia de cr\u00e9dito");
        }
        if ("OPE_SIMULACAO_SAQUE_TRANSFERENCIA_CREDITO".equals(tipoOperacao)) {
            return "3M";
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }
}

