/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.contexto.ContextoCTFClient;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import java.math.BigDecimal;

public class MicSolicitacaoTransacoesSAA {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    private static BigDecimal valor1Centavo = new BigDecimal(1);
    private ILogger logger = CTFClientLogger.getCTFClient();

    public String execute(Process dados) throws ExcecaoApiAc {
        PinEMV pinEMV;
        boolean connectedPin;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        ContextoCTFClient contexto = Contexto.getContexto();
        EntradaApiTefC entrada = contexto.getEntradaApiTefC();
        SaidaApiTefC saida = contexto.getSaidaApiTefC();
        EntradaCTFClientCtrl entradaIntegracao = contexto.getEntradaIntegracao();
        String bit62 = null;
        if (entradaIntegracao != null) {
            if (entradaIntegracao.getInfoAdicionais() != null) {
                bit62 = entradaIntegracao.getInfoAdicionais();
                entrada.setAdicionais(bit62);
            }
            if (entradaIntegracao.isModoEntradaCartaoCtrl()) {
                entrada.setModoEntrada(entradaIntegracao.getModoEntradaCartao());
            }
        }
        entrada.setOperacao(MicSolicitacaoTransacoesSAA.getCodigoTransacao(dados));
        entrada.setCodigoProduto(0);
        this.preencheValorTransacao();
        entrada.setValorEntrada(new BigDecimal(0));
        String numeroCartaoFixo = MicSolicitacaoTransacoesSAA.formataNumeroCartao(bit62);
        if (numeroCartaoFixo != null && numeroCartaoFixo.length() > 0) {
            entrada.setInfo(numeroCartaoFixo);
        }
        if (entradaIntegracao != null) {
            entrada.setDataCliente(entradaIntegracao.getDataAbertura());
            if (entradaIntegracao.getTipoProduto() != null) {
                entrada.setTipoProduto(entradaIntegracao.getTipoProduto());
            }
        } else {
            entrada.setDataCliente(dados.getStartProcess());
        }
        boolean bl = connectedPin = (pinEMV = periferico.getPin()) != null;
        if (connectedPin) {
            if (pinEMV.isBibliotecaEMV()) {
                entrada.setTipoPin("16");
            } else {
                entrada.setTipoPin("14");
            }
        } else {
            entrada.setTipoPin("**");
        }
        int timeout = saida != null && saida.getTimeOutCTF() > 0 ? saida.getTimeOutCTF() : 30;
        entrada.setTimeoutCtf(timeout);
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        entrada.setAcSuportaPlataformaPromocional(conf.isAcSuportaPlataformaPromocional());
        entrada.setClientSuportaPlataformaPromocional(true);
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO1")));
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO2")));
        displayModel.addLinha(new Linha(inter.getMessage("ENVTRA_SOLICITACAO3")));
        periferico.imprimeDisplay(displayModel);
        IdentApiTefC ident = new IdentApiTefC();
        ident.setNumeroEstabelecimento(conf.getEstabelecimento());
        ident.setNumeroLoja(conf.getLoja());
        ident.setNumeroPdv(conf.getTerminal());
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        if (connectedPin) {
            pinEMV.setMsgDisplay(inter.getMessage("ENVIO_TITLE"));
        }
        saida = dados.getApitef().solicitacao(ident, entrada);
        Contexto.getContexto().setSaidaApiTefC(saida);
        if (saida.getRetorno() != 0) {
            this.logger.log("INFO", "Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora());
            return ERROR;
        }
        return SUCCESS;
    }

    protected static String getCodigoTransacao(Process dados) throws IllegalStateException {
        if ("OPE_EMISSAO_VALE_TROCA".equals(Contexto.getContexto().getTipoOperacao())) {
            return "Y1";
        }
        if ("OPE_RESGATE_VALE_TROCA".equals(Contexto.getContexto().getTipoOperacao())) {
            return "Y2";
        }
        if ("OPE_CONSULTA_REIMPRESSAO_VALE_TROCA".equals(Contexto.getContexto().getTipoOperacao())) {
            return "9B";
        }
        if ("OPE_REIMPRESSAO_VALE_TROCA".equals(Contexto.getContexto().getTipoOperacao())) {
            return "96";
        }
        if ("OPE_CONSULTA_GARANTIA_ESTENDIDA".equals(Contexto.getContexto().getTipoOperacao())) {
            return "7C";
        }
        if ("OPE_CONSULTA_GARANTIA_ROUBO_FURTO".equals(Contexto.getContexto().getTipoOperacao())) {
            return "7C";
        }
        if ("OPE_PAGAMENTO_GARANTIA_EXTENDIDA".equals(Contexto.getContexto().getTipoOperacao())) {
            return "9C";
        }
        if ("OPE_PAGAMENTO_GARANTIA_ROUBO_FURTO".equals(Contexto.getContexto().getTipoOperacao())) {
            return "9C";
        }
        if ("OPE_CONSULTA_RESGATE_GARANTIA_NAO_MAGNETICA".equals(Contexto.getContexto().getTipoOperacao())) {
            return "EE";
        }
        if ("OPE_COMPRA_RESGATE_GARANTIA_NAO_MAGNETICA".equals(Contexto.getContexto().getTipoOperacao())) {
            return "F1";
        }
        if ("OPE_CONSULTA_ASSOCIADO".equals(Contexto.getContexto().getTipoOperacao())) {
            return "6B";
        }
        if ("OPE_COMPRA_ASSOCIADO".equals(Contexto.getContexto().getTipoOperacao())) {
            return "B1";
        }
        if ("OPE_CARGA_HABILITACAO_CARTAO_PRESENTE".equals(Contexto.getContexto().getTipoOperacao())) {
            return "E8";
        }
        if ("OPE_RESGATE_CARTAO_PRESENTE_SAA".equals(Contexto.getContexto().getTipoOperacao())) {
            return "EA";
        }
        if ("OPE_CONSULTA_CARTAO_PRESENTE_SAA".equals(Contexto.getContexto().getTipoOperacao())) {
            return "EC";
        }
        if ("OPE_CARGA_HABILITACAO_CUPONAGEM".equals(Contexto.getContexto().getTipoOperacao())) {
            return "E8";
        }
        if ("OPE_CONSULTA_CUPONAGEM".equals(Contexto.getContexto().getTipoOperacao())) {
            return "EC";
        }
        if ("OPE_RESGATE_CUPONAGEM".equals(Contexto.getContexto().getTipoOperacao())) {
            return "EA";
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }

    protected static String formataNumeroCartao(String bit62) {
        String numeroCartao = null;
        ContextoCTFClient contexto = Contexto.getContexto();
        if ("OPE_EMISSAO_VALE_TROCA".equals(Contexto.getContexto().getTipoOperacao())) {
            numeroCartao = "7850000000000000000";
        } else if ("OPE_RESGATE_VALE_TROCA".equals(Contexto.getContexto().getTipoOperacao())) {
            numeroCartao = "7850000000000000000";
        } else if ("OPE_CONSULTA_REIMPRESSAO_VALE_TROCA".equals(Contexto.getContexto().getTipoOperacao())) {
            numeroCartao = "7850000000000000000";
        } else if ("OPE_REIMPRESSAO_VALE_TROCA".equals(Contexto.getContexto().getTipoOperacao())) {
            numeroCartao = "7850000000000000000";
        } else if ("OPE_CONSULTA_GARANTIA_ESTENDIDA".equals(Contexto.getContexto().getTipoOperacao())) {
            numeroCartao = "781";
        } else if ("OPE_CONSULTA_GARANTIA_ROUBO_FURTO".equals(Contexto.getContexto().getTipoOperacao())) {
            numeroCartao = "781";
        } else if ("OPE_PAGAMENTO_GARANTIA_EXTENDIDA".equals(Contexto.getContexto().getTipoOperacao())) {
            numeroCartao = "7810000000000000000";
        } else if ("OPE_PAGAMENTO_GARANTIA_ROUBO_FURTO".equals(Contexto.getContexto().getTipoOperacao())) {
            numeroCartao = "7820000000000000000";
        } else if ("OPE_CONSULTA_RESGATE_GARANTIA_NAO_MAGNETICA".equals(Contexto.getContexto().getTipoOperacao())) {
            numeroCartao = "7810000000000000000";
        } else if ("OPE_COMPRA_RESGATE_GARANTIA_NAO_MAGNETICA".equals(Contexto.getContexto().getTipoOperacao())) {
            if (contexto.getEntradaIntegracao() != null) {
                numeroCartao = contexto.getEntradaIntegracao().getNumeroCartao();
            }
        } else if ("OPE_CONSULTA_ASSOCIADO".equals(Contexto.getContexto().getTipoOperacao()) || "OPE_COMPRA_ASSOCIADO".equals(Contexto.getContexto().getTipoOperacao())) {
            int posicaoMatricula = 0;
            if ("OPE_CONSULTA_ASSOCIADO".equals(Contexto.getContexto().getTipoOperacao())) {
                posicaoMatricula = 37;
            } else if ("OPE_COMPRA_ASSOCIADO".equals(Contexto.getContexto().getTipoOperacao())) {
                posicaoMatricula = 82;
            }
            String matriculaAssociado = "";
            if (bit62 != null && bit62.length() >= posicaoMatricula + 10) {
                matriculaAssociado = bit62.substring(posicaoMatricula, posicaoMatricula + 10);
            }
            numeroCartao = "8888" + StringUtil.completaString(matriculaAssociado, 15, '0', 3);
        } else if ("OPE_CARGA_HABILITACAO_CARTAO_PRESENTE".equals(Contexto.getContexto().getTipoOperacao())) {
            numeroCartao = "7770000000000000000";
        } else if (!"OPE_RESGATE_CARTAO_PRESENTE_SAA".equals(Contexto.getContexto().getTipoOperacao()) && !"OPE_CONSULTA_CARTAO_PRESENTE_SAA".equals(Contexto.getContexto().getTipoOperacao()) && ("OPE_CARGA_HABILITACAO_CUPONAGEM".equals(Contexto.getContexto().getTipoOperacao()) || "OPE_CONSULTA_CUPONAGEM".equals(Contexto.getContexto().getTipoOperacao()) || "OPE_RESGATE_CUPONAGEM".equals(Contexto.getContexto().getTipoOperacao()))) {
            int posicaoCpf = 0;
            if ("OPE_CARGA_HABILITACAO_CUPONAGEM".equals(Contexto.getContexto().getTipoOperacao())) {
                posicaoCpf = 12;
            } else if ("OPE_CONSULTA_CUPONAGEM".equals(Contexto.getContexto().getTipoOperacao())) {
                posicaoCpf = 8;
            } else if ("OPE_RESGATE_CUPONAGEM".equals(Contexto.getContexto().getTipoOperacao())) {
                posicaoCpf = 12;
            }
            String cpf = "";
            if (bit62 != null && bit62.length() >= posicaoCpf + 11) {
                cpf = bit62.substring(posicaoCpf, posicaoCpf + 11);
            }
            numeroCartao = "774" + StringUtil.completaString(cpf, 14, '0', 3);
        }
        return numeroCartao;
    }

    protected void preencheValorTransacao() {
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        if ("OPE_CONSULTA_REIMPRESSAO_VALE_TROCA".equals(Contexto.getContexto().getTipoOperacao()) || "OPE_REIMPRESSAO_VALE_TROCA".equals(Contexto.getContexto().getTipoOperacao()) || "OPE_CONSULTA_CARTAO_PRESENTE_SAA".equals(Contexto.getContexto().getTipoOperacao()) || "OPE_CARGA_HABILITACAO_CUPONAGEM".equals(Contexto.getContexto().getTipoOperacao()) || "OPE_CONSULTA_CUPONAGEM".equals(Contexto.getContexto().getTipoOperacao()) || "OPE_RESGATE_CUPONAGEM".equals(Contexto.getContexto().getTipoOperacao())) {
            entrada.setValorTransacao(valor1Centavo);
        }
    }

    static {
        valor1Centavo.movePointLeft(2);
    }
}

