/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.constantes.Cartao;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.contexto.TrataLegadoUtil;
import com.csi.ctfclient.operacoes.model.CorrespondenteBancario;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.devices.emvfull.KeyFactory;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;

public class MicSolitacaoPagamentoFaturaCartao {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERRO_TRANS_JA_EFETUADA = "ERRO_TRANS_JA_EFETUADA";
    public static final String ERROR = "ERROR";
    private ILogger logger = CTFClientLogger.getCTFClient();

    public String execute(Process dados) throws ExcecaoApiAc {
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        String codigoTransacao = this.getCodigoTransacao(dados);
        ConfCTFClient confCTFClient = ControladorConfCTFClient.getInstance().getConfig();
        int modoEntrada = 0;
        int modoEntradaInfo = 0;
        boolean enviaCampoInfo = true;
        String informacaoPagamento = "";
        if (entradaApiTefC.getIdentificacaoPagamento() == 1) {
            if (Contexto.getContexto().getCartao() != null) {
                if (Contexto.getContexto().getCartao() == Cartao.DIGITADO) {
                    modoEntrada = 1;
                    modoEntradaInfo = 1;
                    informacaoPagamento = entradaApiTefC.getPAN();
                } else {
                    if (!KeyFactory.isChaveLocal()) {
                        enviaCampoInfo = false;
                    }
                    modoEntrada = Contexto.getContexto().getCartao() == Cartao.CHIP ? 5 : 2;
                    modoEntradaInfo = 3;
                    if (entradaApiTefC.getInfo() != null) {
                        informacaoPagamento = entradaApiTefC.getInfo();
                    }
                }
            }
        } else if (entradaApiTefC.getIdentificacaoPagamento() == 2) {
            informacaoPagamento = entradaApiTefC.getCodigoBarras();
            modoEntrada = 3;
            modoEntradaInfo = entradaApiTefC.getModoEntradaCodigoBarras();
        }
        entradaApiTefC.setModoEntrada(modoEntrada);
        if (enviaCampoInfo) {
            String entradaCorrespondenteBancario = CorrespondenteBancario.montaEntrada(modoEntradaInfo, informacaoPagamento, Contexto.getContexto().getTipoPagamento());
            entradaApiTefC.setInfo(entradaCorrespondenteBancario);
        }
        if (entradaApiTefC.getDataVencimentoCorBan() != null) {
            entradaApiTefC.setDataVencimento(entradaApiTefC.getDataVencimentoCorBan());
        }
        entradaApiTefC.setTimeoutCtf(confCTFClient.getTimeOutDefault());
        entradaApiTefC.setOperacao(codigoTransacao);
        entradaApiTefC.setValorTransacao(TrataLegadoUtil.calculaValorTransacao(dados));
        String msg1 = null;
        String msg2 = null;
        String msg3 = null;
        if ("OPERACAO CORRESPONDENTE BANCARIO CONSULTA CONVENIO".equals(Contexto.getContexto().getTipoOperacao()) || "OPERACAO CORRESPONDENTE BANCARIO CONSULTA TITULO".equals(Contexto.getContexto().getTipoOperacao())) {
            msg1 = inter.getMessage("SOLCORBAN_SOLICITACAO_CONSULTA1");
            msg2 = inter.getMessage("SOLCORBAN_SOLICITACAO_CONSULTA2");
            msg3 = inter.getMessage("SOLCORBAN_SOLICITACAO_CONSULTA3");
        } else {
            msg1 = inter.getMessage("ENVTRA_SOLICITACAO1");
            msg2 = inter.getMessage("ENVTRA_SOLICITACAO2");
            msg3 = inter.getMessage("ENVTRA_SOLICITACAO3");
        }
        LayoutDisplay displayModel = new LayoutDisplay();
        displayModel.addLinha(new Linha(msg1));
        displayModel.addLinha(new Linha(msg2));
        displayModel.addLinha(new Linha(msg3));
        periferico.imprimeDisplay(displayModel);
        IdentApiTefC ident = Contexto.getContexto().getIdentApiTefC();
        saida = dados.getApitef().solicitacao(ident, entradaApiTefC);
        Contexto.getContexto().setSaidaApiTefC(saida);
        if (saida.getRetorno() != 0) {
            this.logger.log("INFO", "Resposta autorizadora: " + saida.getCodigoRespostaAutorizadora());
            if (saida.getCodigoRespostaAutorizadora().equals("0ER")) {
                return ERRO_TRANS_JA_EFETUADA;
            }
            return ERROR;
        }
        CorrespondenteBancario correspondenteBancario = CorrespondenteBancario.createCorrespondenteBancario(saida.getAdicionais());
        if (correspondenteBancario != null) {
            Contexto.getContexto().setCorrespondenteBancario(correspondenteBancario);
        }
        return SUCCESS;
    }

    private String getCodigoTransacao(Process dados) {
        if (Contexto.getContexto().getTipoOperacao().equals("OPERACAO CONSULTA FATURA CARTAO")) {
            return "FA";
        }
        if (Contexto.getContexto().getTipoOperacao().equals("OPERACAO_CONSULTA_FATURA_CARTAO_DETALHADA")) {
            return "7J";
        }
        if (Contexto.getContexto().getTipoOperacao().equals("OPERACAO PAGAMENTO FATURA CARTAO")) {
            return "FB";
        }
        throw new IllegalStateException("Codigo da transa\u00e7\u00e3o n\u00e3o encotrada");
    }
}

