/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.processleituracartao.ProcessCargaTabela;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.controller.ControladorAIDsGetCard;
import com.csi.ctfclient.operacoes.model.controller.ControladorMultiEC;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;

public class MicSubProcessCargaTabela {
    private ILogger logger = CTFClientLogger.getCTFClient();
    public static final String SUCESS = "SUCESS";
    public static final String ERRO = "ERRO";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String REFAZ_LEITURA = "REFAZ_LEITURA";

    public String execute(Process dados) throws ExcecaoApiAc {
        ProcessManager processManager = ProcessManager.getInstance();
        ProcessCargaTabela process = new ProcessCargaTabela();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        ConfCTFClient config = ControladorConfCTFClient.getInstance().getConfig();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        boolean multiEC = config.isMultiEC();
        IdentTerminal identTerminal = null;
        identTerminal = multiEC ? ControladorMultiEC.criarTerminalComumMultiEC(config.getCodigoGrupoMultiEC()) : new IdentTerminal(config.getEstabelecimento(), config.getLoja(), config.getTerminal());
        ControladorAIDsGetCard controladorAIDsGetCard = ControladorAIDsGetCard.getInstance(identTerminal);
        boolean listarAids = controladorAIDsGetCard.getMapAid() != null;
        try {
            processManager.subProcess(dados.getIdProcess(), process);
            if (entradaIntegracao == null || entradaIntegracao.getOperacao() != 400) {
                Contexto.getContexto().setSaidaApiTefC(null);
            }
            if (saidaApiTefC != null) {
                Contexto.getContexto().setSaidaApiTefC(saidaApiTefC);
            }
            Contexto.getContexto().atualizaEntradaApiTefC(entradaApiTefC);
            if (process.getState() == 3) {
                return USERCANCEL;
            }
            if (process.getState() == 1) {
                Contexto.getContexto().resetCartao();
                return ERRO;
            }
            controladorAIDsGetCard = ControladorAIDsGetCard.getInstance(identTerminal);
            if (!listarAids && controladorAIDsGetCard.getMapAid() != null) {
                Contexto.getContexto().setNovaLeituraCartao(true);
                return REFAZ_LEITURA;
            }
            return SUCESS;
        }
        catch (Exception e) {
            this.logger.log("ERROR", e.getMessage(), e);
            if (Contexto.getContexto().getErroIntegracao() == null) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5331, "TENTE NOVAMENTE"));
            }
            return ERRO;
        }
    }
}

