/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.ProcessCorrespondenteBancario;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;

public class MicSubProcessConsultaCorrespondenteBancario {
    public static final String SUCESS = "SUCESS";
    public static final String FILLED = "FILLED";
    public static final String ERROR = "ERROR";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String USER_CANCEL_INTERNAL = "USER_CANCEL_INTERNAL";
    private ILogger logger = CTFClientLogger.getLogger("com.csi.ctfclient.operacoes.microoperacoes.MicSubProcessConsultaCreditoDigital");

    public String execute(Process dados) {
        String tipoOperacao;
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        if (Contexto.getContexto().getCorrespondenteBancario() != null) {
            return FILLED;
        }
        this.logger.log("INFO", "Executando o subprocesso para consulta Correspondente Banc\u00e1rio");
        ProcessManager processManager = ProcessManager.getInstance();
        ProcessCorrespondenteBancario processCorrespondenteBancario = null;
        String tipoOperacaoAnterior = Contexto.getContexto().getTipoOperacao();
        if (Contexto.getContexto().getTipoOperacao().equals("OPERACAO CORRESPONDENTE BANCARIO CONSULTA E PAGAMENTO CONVENIO") || Contexto.getContexto().getTipoOperacao().equals("OPERACAO CORRESPONDENTE BANCARIO PAGAMENTO CONVENIO")) {
            tipoOperacao = "OPERACAO CORRESPONDENTE BANCARIO CONSULTA CONVENIO";
        } else if (Contexto.getContexto().getTipoOperacao().equals("OPERACAO CORRESPONDENTE BANCARIO CONSULTA E PAGAMENTO TITULO") || Contexto.getContexto().getTipoOperacao().equals("OPERACAO CORRESPONDENTE BANCARIO PAGAMENTO TITULO")) {
            tipoOperacao = "OPERACAO CORRESPONDENTE BANCARIO CONSULTA TITULO";
        } else {
            this.logger.log(ERROR, "Opera\u00e7\u00e3o n\u00e3o suportada na execu\u00e7\u00e3o do subprocesso de consulta CORBAN");
            throw new IllegalArgumentException("Opera\u00e7\u00e3o n\u00e3o suportada");
        }
        processCorrespondenteBancario = new ProcessCorrespondenteBancario(Contexto.getContexto().getEntradaIntegracao(), tipoOperacao);
        processCorrespondenteBancario.setActiveDialogUserCancel(false);
        entradaApiTefC.setCodigoBarrasParcial("");
        if (Contexto.getContexto().getTipoConta() == 2) {
            Contexto.getContexto().setNumeroBloco(4);
        } else if (Contexto.getContexto().getTipoConta() == 1) {
            Contexto.getContexto().setNumeroBloco(5);
        }
        Contexto.getContexto().setConfirmaVencimentoCorBan(false);
        Contexto.getContexto().setConfirmaValorDocumento(false);
        Contexto.getContexto().setSubProcessConsulta(true);
        try {
            processManager.subProcess(dados.getIdProcess(), processCorrespondenteBancario);
            Contexto.getContexto().setSubProcessConsulta(false);
            Contexto.getContexto().setTipoOperacao(tipoOperacaoAnterior);
            if (processCorrespondenteBancario.getState() == 3) {
                return USER_CANCEL;
            }
            if (processCorrespondenteBancario.getState() == 1) {
                return ERROR;
            }
            if (processCorrespondenteBancario.getState() == 5) {
                return USER_CANCEL_INTERNAL;
            }
            return SUCESS;
        }
        catch (Exception e) {
            this.logger.log(ERROR, e.getMessage(), e);
            if (Contexto.getContexto().getErroIntegracao() == null) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5331, "TENTE NOVAMENTE"));
            }
            return ERROR;
        }
    }
}

