/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.ProcessConsultaEstabelecimentosMultiEC;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.contexto.ContextoCTFClient;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;

public class MicSubProcessConsultaEstabelecimentosMultiEC {
    public static final String SUCCESS = "SUCCESS";
    public static final String NOT_REQUIRED = "NOT_REQUIRED";
    public static final String ERROR = "ERROR";
    private ILogger logger = CTFClientLogger.getCTFClient();

    public String execute(Process dados) throws ExcecaoApiAc {
        ConfCTFClient config = ControladorConfCTFClient.getInstance().getConfig();
        if (!config.isMultiEC()) {
            return NOT_REQUIRED;
        }
        ContextoCTFClient contexto = Contexto.getContexto();
        ProcessConsultaEstabelecimentosMultiEC processConsultaEstabelecimentosMultiEC = new ProcessConsultaEstabelecimentosMultiEC(contexto.getEntradaIntegracao());
        try {
            ProcessManager processManager = ProcessManager.getInstance();
            processManager.subProcess(processConsultaEstabelecimentosMultiEC.getIdProcess(), processConsultaEstabelecimentosMultiEC);
            if (processConsultaEstabelecimentosMultiEC.getState() == 1) {
                return ERROR;
            }
            return SUCCESS;
        }
        catch (Exception e) {
            this.logger.log(ERROR, e.getMessage(), e);
            if (Contexto.getContexto().getErroIntegracao() == null) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5331, "TENTE NOVAMENTE"));
            }
            return ERROR;
        }
    }
}

