/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.processleituracartao.ProcessLeituraCartao;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;

public class MicSubProcessLeituraCartao {
    private ILogger logger = CTFClientLogger.getCTFClient();
    public static final String SUCESS = "SUCESS";
    public static final String SUBPROCESS_CREDITO_CELULAR = "SUBPROCESS_CREDITO_CELULAR";
    public static final String ERRO = "ERRO";
    public static final String USERCANCEL = "USERCANCEL";
    public static final String USERCANCEL_INTERNAL = "USERCANCEL_INTERNAL";
    public static final String FILLED = "FILLED";

    public String execute(Process dados) throws ExcecaoApiAc {
        String operacao;
        EntradaCTFClientCtrl entradaIntegracao;
        if (Contexto.getContexto().isNovaLeituraCartao()) {
            Contexto.getContexto().setNovaLeituraCartao(false);
            Contexto.getContexto().resetCartao();
        }
        if (Contexto.getContexto().isTransacaoGenerica() && Contexto.getContexto().getCartao() != null) {
            return FILLED;
        }
        if (Contexto.getContexto().getEntradaIntegracao() != null && !Contexto.getContexto().getEntradaIntegracao().isConsulta() && Contexto.getContexto().getCartao() != null) {
            return SUCESS;
        }
        if (Contexto.getContexto().getEntradaIntegracao() != null && !Contexto.getContexto().getEntradaIntegracao().isConsulta() && Contexto.getContexto().isTransacaoSemCartao() && ((entradaIntegracao = Contexto.getContexto().getEntradaIntegracao()).getOperacao() == 232 || entradaIntegracao.getOperacao() == 234 || entradaIntegracao.getOperacao() == 233)) {
            return SUBPROCESS_CREDITO_CELULAR;
        }
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        if (saidaApiTefC != null && !(operacao = saidaApiTefC.getCodigoRespostaAutorizadora()).equals("F3") && !operacao.equals("0F3")) {
            Contexto.getContexto().setSaidaApiTefC(null);
        }
        ProcessManager processManager = ProcessManager.getInstance();
        ProcessLeituraCartao processLeituraCartao = null;
        processLeituraCartao = new ProcessLeituraCartao();
        processLeituraCartao.setActiveDialogUserCancel(false);
        try {
            processManager.subProcess(dados.getIdProcess(), processLeituraCartao);
            if (Contexto.getContexto().isNovaLeituraCartao()) {
                return "RERUN";
            }
            if (processLeituraCartao.getState() == 3) {
                return USERCANCEL;
            }
            if (processLeituraCartao.getState() == 1) {
                return ERRO;
            }
            if (processLeituraCartao.getState() == 5) {
                return USERCANCEL_INTERNAL;
            }
            if (Contexto.getContexto().isSubfluxoCreditoCelular()) {
                Contexto.getContexto().setTransacaoSemCartao(true);
                return SUBPROCESS_CREDITO_CELULAR;
            }
            return SUCESS;
        }
        catch (Exception e) {
            this.logger.log("ERROR", e.getMessage(), e);
            if (Contexto.getContexto().getErroIntegracao() == null) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5331, "TENTE NOVAMENTE"));
            }
            return ERRO;
        }
    }
}

