/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.ProcessFidelidadeMilhas;
import com.csi.ctfclient.operacoes.action.ProcessPreAutorizacao;
import com.csi.ctfclient.operacoes.action.ProcessResgateFacil;
import com.csi.ctfclient.operacoes.action.ProcessTransacoesGenericas;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.ControladorInicioDia;
import com.csi.ctfclient.operacoes.model.DadosInicioDia;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;

public class MicTefIPOperacaoCartao {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String USER_CANCEL_INTERNAL = "USER_CANCEL_INTERNAL";
    public static final String ERROR_AC = "ERROR_AC";

    public String execute(Process dados) throws Exception {
        int opcao;
        ControladorPerifericos perifericos = dados.getPerifericos();
        String OP_MENU_CREDITO = "CREDITO";
        String OP_MENU_DEBITO = "DEBITO";
        String OP_MENU_PRE_AUTORIZACAO = "PRE-AUTORIZACAO";
        String OP_MENU_RESGATE_FACIL = "RESGATE FACIL";
        String OP_MENU_RESGATE_FIDELIDADE_MILHAS = "RESGATE FIDELIDADE MILHAS";
        ConfCTFClient confCTFClient = ControladorConfCTFClient.getInstance().getConfig();
        IdentTerminal identTerminal = new IdentTerminal(confCTFClient.getEstabelecimento(), confCTFClient.getLoja(), confCTFClient.getTerminal());
        DadosInicioDia dadosInicioDia = ControladorInicioDia.getInstance().getDadosInicioDia(identTerminal);
        boolean isResgateFacil = false;
        boolean isResgateFidelidadeMilhas = false;
        if (dadosInicioDia != null) {
            isResgateFacil = dadosInicioDia.isResgateFacil();
            isResgateFidelidadeMilhas = dadosInicioDia.isResgateFidelidadeMilhas();
        }
        LayoutMenu layoutMenu = new LayoutMenu("MEIO DE PAGAMENTO", true);
        layoutMenu.addItem(new ItemMenu(OP_MENU_CREDITO, "1"));
        layoutMenu.addItem(new ItemMenu(OP_MENU_DEBITO, "2"));
        layoutMenu.addItem(new ItemMenu(OP_MENU_PRE_AUTORIZACAO, "3"));
        String proximaTecla = "4";
        if (isResgateFacil) {
            layoutMenu.addItem(new ItemMenu(OP_MENU_RESGATE_FACIL, proximaTecla));
            proximaTecla = "5";
        }
        if (isResgateFidelidadeMilhas) {
            layoutMenu.addItem(new ItemMenu(OP_MENU_RESGATE_FIDELIDADE_MILHAS, proximaTecla));
            proximaTecla = "6";
        }
        if ((opcao = perifericos.imprimeMenu(layoutMenu)) == -1) {
            return USER_CANCEL;
        }
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        ProcessManager processManager = ProcessManager.getInstance();
        int state = -1;
        ItemMenu itemMenu = layoutMenu.getItens().get(opcao - 1);
        if (itemMenu.getTexto().equals(OP_MENU_CREDITO)) {
            int operacaoAtual = Contexto.getContexto().getEntradaIntegracao().getOperacao();
            Contexto.getContexto().getEntradaIntegracao().setOperacao(223);
            ProcessTransacoesGenericas processCredito = new ProcessTransacoesGenericas(entradaIntegracao.getNumeroTransacao(), entradaIntegracao.getValorTransacao(), entradaIntegracao.getNumeroCupom(), "CREDITO GENERICO", 0);
            processCredito.setParent(dados);
            processManager.subProcess(dados.getIdProcess(), processCredito);
            dados.setErro(processCredito.getErro());
            Contexto.getContexto().getEntradaIntegracao().setOperacao(operacaoAtual);
            state = processCredito.getState();
        } else if (itemMenu.getTexto().equals(OP_MENU_DEBITO)) {
            int operacaoAtual = Contexto.getContexto().getEntradaIntegracao().getOperacao();
            Contexto.getContexto().getEntradaIntegracao().setOperacao(224);
            ProcessTransacoesGenericas processDebito = new ProcessTransacoesGenericas(entradaIntegracao.getNumeroTransacao(), entradaIntegracao.getValorTransacao(), entradaIntegracao.getNumeroCupom(), "DEBITO GENERICO", 0);
            processDebito.setParent(dados);
            processManager.subProcess(dados.getIdProcess(), processDebito);
            dados.setErro(processDebito.getErro());
            Contexto.getContexto().getEntradaIntegracao().setOperacao(operacaoAtual);
            state = processDebito.getState();
        } else if (itemMenu.getTexto().equals(OP_MENU_PRE_AUTORIZACAO)) {
            int operacaoAtual = Contexto.getContexto().getEntradaIntegracao().getOperacao();
            Contexto.getContexto().getEntradaIntegracao().setOperacao(403);
            ProcessPreAutorizacao processPreAutorizacao = new ProcessPreAutorizacao(entradaIntegracao);
            processPreAutorizacao.setParent(dados);
            processManager.subProcess(dados.getIdProcess(), processPreAutorizacao);
            dados.setErro(processPreAutorizacao.getErro());
            Contexto.getContexto().getEntradaIntegracao().setOperacao(operacaoAtual);
            state = processPreAutorizacao.getState();
        } else if (itemMenu.getTexto().equals(OP_MENU_RESGATE_FACIL)) {
            Contexto.getContexto().setTipoOperacao("OPE_RESGATE_FACIL");
            int operacaoAtual = Contexto.getContexto().getEntradaIntegracao().getOperacao();
            Contexto.getContexto().getEntradaIntegracao().setOperacao(330);
            ProcessResgateFacil processResgateFacil = new ProcessResgateFacil(entradaIntegracao.getNumeroTransacao());
            processResgateFacil.setParent(dados);
            processManager.subProcess(dados.getIdProcess(), processResgateFacil);
            dados.setErro(processResgateFacil.getErro());
            Contexto.getContexto().getEntradaIntegracao().setOperacao(operacaoAtual);
            state = processResgateFacil.getState();
        } else if (itemMenu.getTexto().equals(OP_MENU_RESGATE_FIDELIDADE_MILHAS)) {
            int operacaoAtual = Contexto.getContexto().getEntradaIntegracao().getOperacao();
            Contexto.getContexto().getEntradaIntegracao().setOperacao(333);
            ProcessFidelidadeMilhas processFidelidadeMilhas = new ProcessFidelidadeMilhas(entradaIntegracao, "OPE_PRECIFICACAO_FIDELIDADE_EM_MILHAS");
            processFidelidadeMilhas.setParent(dados);
            processManager.subProcess(dados.getIdProcess(), processFidelidadeMilhas);
            dados.setErro(processFidelidadeMilhas.getErro());
            Contexto.getContexto().getEntradaIntegracao().setOperacao(operacaoAtual);
            state = processFidelidadeMilhas.getState();
        }
        if (state == 1) {
            return ERROR;
        }
        if (state == 0) {
            return SUCCESS;
        }
        if (state == 3) {
            return USER_CANCEL_INTERNAL;
        }
        if (state == 6) {
            return ERROR_AC;
        }
        return SUCCESS;
    }
}

