/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.ProcessManager;
import com.csi.ctfclient.operacoes.action.ProcessConsultaTransferenciaDomestica;
import com.csi.ctfclient.operacoes.action.ProcessDepositoConta;
import com.csi.ctfclient.operacoes.action.ProcessSaqueTransferenciaDomestica;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;

public class MicTefIpOperacaoEnvioFacil {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String USER_CANCEL_INTERNAL = "USER_CANCEL_INTERNAL";
    public static final String ERROR_AC = "ERROR_AC";

    public String execute(Process dados) throws Exception {
        ControladorPerifericos perifericos = dados.getPerifericos();
        ProcessManager processManager = ProcessManager.getInstance();
        EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
        LayoutMenu layoutMenuEnvioFacil = new LayoutMenu("ENVIO FACIL", true);
        layoutMenuEnvioFacil.addItem(new ItemMenu("CONSULTA", "1"));
        layoutMenuEnvioFacil.addItem(new ItemMenu("DEPOSITO", "2"));
        layoutMenuEnvioFacil.addItem(new ItemMenu("SAQUE", "3"));
        int opcaoEnvioFacil = perifericos.imprimeMenu(layoutMenuEnvioFacil);
        if (opcaoEnvioFacil == -1) {
            return USER_CANCEL;
        }
        int state = -1;
        if (opcaoEnvioFacil == 1) {
            ProcessConsultaTransferenciaDomestica processConsulta = new ProcessConsultaTransferenciaDomestica(entradaIntegracao);
            processConsulta.setParent(dados);
            processManager.subProcess(dados.getIdProcess(), processConsulta);
            dados.setErro(processConsulta.getErro());
            state = processConsulta.getState();
        } else if (opcaoEnvioFacil == 2) {
            ProcessDepositoConta processDeposito = new ProcessDepositoConta(entradaIntegracao);
            processDeposito.setParent(dados);
            processManager.subProcess(dados.getIdProcess(), processDeposito);
            dados.setErro(processDeposito.getErro());
            state = processDeposito.getState();
        } else if (opcaoEnvioFacil == 3) {
            ProcessSaqueTransferenciaDomestica processSaque = new ProcessSaqueTransferenciaDomestica(entradaIntegracao);
            processSaque.setParent(dados);
            processManager.subProcess(dados.getIdProcess(), processSaque);
            dados.setErro(processSaque.getErro());
            state = processSaque.getState();
        }
        if (state == 1) {
            return ERROR;
        }
        if (state == 0) {
            return SUCCESS;
        }
        if (state == 3) {
            return USER_CANCEL_INTERNAL;
        }
        if (state == 6) {
            return ERROR_AC;
        }
        return SUCCESS;
    }
}

