/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoCodigoInvalido;
import com.csi.ctfclient.excecoes.ExcecaoDigitoInvalido;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.tiposgerais.CodigoFebraban;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.AbstractCodigoPagamento;
import com.csi.ctfclient.operacoes.model.CodigoBarrasConvenio;
import com.csi.ctfclient.operacoes.model.CodigoBarrasTitulo;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.CodigoPagamentoTitulo;
import com.csi.ctfclient.operacoes.model.ControladorInicioDia;
import com.csi.ctfclient.operacoes.model.DadosInicioDia;
import com.csi.ctfclient.operacoes.model.LinhaDigitavelTitulo;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.codigobarras.CalculadorDigito;
import com.csi.ctfclient.tools.util.codigobarras.CodigoBarrasUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.math.BigDecimal;
import java.util.Date;

public class MicValidaCodigoBarras {
    public static final String SUCESS = "SUCESS";
    public static final String UNECESSARY = "UNECESSARY";
    public static final String INVALID_CODE = "INVALID_CODE";
    public static final String DOCUMENT_ALREADY_READ = "DOCUMENT_ALREADY_READ";
    public static final String CONTINUE_READING = "CONTINUE_READING";
    public static final String ERROR_AC = "ERROR_AC";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String execute(Process dados) throws ExcecaoApiAc {
        String novoCodigo;
        int tipoConta;
        String numeroDocumentoComDigitos;
        String numeroDocumento;
        ConfCTFClient confCTFClient;
        EntradaCTFClientCtrl entradaIntegracao;
        EntradaApiTefC entradaApiTefC;
        block61: {
            String numeroDocumentoUltimoDigitado;
            if (Contexto.getContexto().isSubProcessConsulta()) {
                return UNECESSARY;
            }
            InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
            ControladorPerifericos perifericos = dados.getPerifericos();
            entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
            entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
            confCTFClient = ControladorConfCTFClient.getInstance().getConfig();
            if (entradaApiTefC.getCodigoBarras() == null && entradaApiTefC.getLinhaDigitavel() == null) {
                throw new IllegalArgumentException("C\u00f3digo para pagamento n\u00e3o informado!");
            }
            numeroDocumento = numeroDocumentoUltimoDigitado = entradaApiTefC.getCodigoBarras() != null ? entradaApiTefC.getCodigoBarras() : entradaApiTefC.getLinhaDigitavel();
            numeroDocumentoComDigitos = null;
            int numeroBloco = Contexto.getContexto().getNumeroBloco();
            tipoConta = 0;
            if (numeroBloco > 1) {
                numeroDocumento = entradaApiTefC.getCodigoBarrasParcial() + numeroDocumentoUltimoDigitado;
            }
            if (numeroBloco == 1) {
                int primeirosDigitos;
                tipoConta = 2;
                if (numeroDocumento.length() < 3) {
                    this.exibeMensagemErro(perifericos, inter.getMessage("VALCODBAR_ERRO_COD_INVALIDO"));
                    entradaApiTefC.setCodigoBarras(null);
                    return INVALID_CODE;
                }
                try {
                    primeirosDigitos = Integer.parseInt(numeroDocumento.substring(0, 3));
                }
                catch (NumberFormatException e) {
                    this.exibeMensagemErro(perifericos, inter.getMessage("VALCODBAR_ERRO_COD_INVALIDO"));
                    entradaApiTefC.setCodigoBarras(null);
                    return INVALID_CODE;
                }
                if (primeirosDigitos < 810) {
                    if (entradaIntegracao != null && entradaIntegracao.getOperacao() != 230 && entradaIntegracao.getOperacao() != 180 && entradaIntegracao.getOperacao() != 153 && entradaIntegracao.getOperacao() != 152 && entradaIntegracao.getOperacao() != 182 && entradaIntegracao.getOperacao() != 183) {
                        Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5306, inter.getMessage("VALCODBAR_OPERACAO_NAO_PERMITIDA")));
                        return ERROR_AC;
                    }
                    tipoConta = 1;
                } else if (entradaIntegracao != null && entradaIntegracao.getOperacao() != 231 && entradaIntegracao.getOperacao() != 181 && entradaIntegracao.getOperacao() != 155 && entradaIntegracao.getOperacao() != 154) {
                    Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5306, inter.getMessage("VALCODBAR_OPERACAO_NAO_PERMITIDA")));
                    return ERROR_AC;
                }
                Contexto.getContexto().setTipoConta(tipoConta);
            }
            if ((tipoConta = Contexto.getContexto().getTipoConta()) == 1 && entradaApiTefC.getModoEntradaCodigoBarras() == 1 && numeroBloco == 5 && numeroDocumentoUltimoDigitado.length() >= 0 && numeroDocumentoUltimoDigitado.length() <= 10) {
                numeroDocumento = entradaApiTefC.getCodigoBarrasParcial() + StringUtil.completaString(numeroDocumentoUltimoDigitado, 14, '0', 3);
            }
            if (numeroDocumento.length() < 44) {
                if (tipoConta == 2 && numeroBloco == 4) {
                    if (numeroDocumento.length() != 12) {
                        this.exibeMensagemErro(perifericos, inter.getMessage("VALCODBAR_ERRO_COD_INVALIDO"));
                        entradaApiTefC.setCodigoBarras(null);
                        return INVALID_CODE;
                    }
                    try {
                        CodigoFebraban.validaDigitoGrupo(numeroDocumento);
                    }
                    catch (ExcecaoDigitoInvalido e) {
                        this.exibeMensagemErro(perifericos, inter.getMessage("VALCODBAR_ERRO_COD_INVALIDO"));
                        entradaApiTefC.setCodigoBarras(null);
                        return INVALID_CODE;
                    }
                }
                if (tipoConta == 1 && numeroBloco == 5) {
                    if (numeroDocumento.length() != 10) {
                        this.exibeMensagemErro(perifericos, inter.getMessage("VALCODBAR_ERRO_COD_INVALIDO"));
                        entradaApiTefC.setCodigoBarras(null);
                        return INVALID_CODE;
                    }
                    try {
                        CodigoFebraban.validaDigitoGrupo("00" + numeroDocumento);
                    }
                    catch (ExcecaoDigitoInvalido e) {
                        this.exibeMensagemErro(perifericos, inter.getMessage("VALCODBAR_ERRO_COD_INVALIDO"));
                        entradaApiTefC.setCodigoBarras(null);
                        return INVALID_CODE;
                    }
                }
            }
            boolean capturaCodigoCompleta = false;
            try {
                int i;
                if (entradaApiTefC.getModoEntradaCodigoBarras() == 1 && tipoConta == 2) {
                    if (confCTFClient.isCapturaApenasLinhaDigitavel() && numeroBloco == 1 && numeroDocumento.length() == 48) {
                        for (i = 1; i < 5; ++i) {
                            CodigoBarrasUtil.validaBlocoParcialConvenio(numeroDocumento, i);
                        }
                        numeroBloco = 4;
                    } else {
                        if (numeroBloco == 1 && numeroDocumento.length() != 12) {
                            this.exibeMensagemErro(perifericos, inter.getMessage("VALCODBAR_ERRO_COD_INVALIDO"));
                            entradaApiTefC.setCodigoBarras(null);
                            Contexto.getContexto().setTipoConta(0);
                            return INVALID_CODE;
                        }
                        CodigoBarrasUtil.validaBlocoParcialConvenio(numeroDocumento, numeroBloco);
                    }
                    if (entradaApiTefC.getCodigoBarrasParcial() == null) {
                        entradaApiTefC.setCodigoBarrasParcial("");
                    }
                    entradaApiTefC.setCodigoBarrasParcial(entradaApiTefC.getCodigoBarrasParcial() + numeroDocumentoUltimoDigitado);
                    Contexto.getContexto().setNumeroBloco(++numeroBloco);
                    if (Contexto.getContexto().getNumeroBloco() <= 4) {
                        return CONTINUE_READING;
                    }
                    capturaCodigoCompleta = true;
                    numeroDocumentoComDigitos = numeroDocumento;
                    numeroDocumento = AbstractCodigoPagamento.retiraDigitos(numeroDocumento);
                } else if (entradaApiTefC.getModoEntradaCodigoBarras() != 1 || tipoConta == 2) {
                    // empty if block
                }
                if (tipoConta == 2) {
                    CodigoFebraban.validaDigitoGeral(numeroDocumento);
                    break block61;
                }
                if (entradaApiTefC.getModoEntradaCodigoBarras() == 3 || entradaApiTefC.getModoEntradaCodigoBarras() == 3) {
                    CalculadorDigito.validaDigitoModulo11(numeroDocumento, 5, 1);
                    break block61;
                }
                if (entradaApiTefC.getModoEntradaCodigoBarras() == 1) {
                    if (confCTFClient.isCapturaApenasLinhaDigitavel() && numeroBloco == 1 && numeroDocumento.length() >= 33) {
                        numeroDocumento = CodigoBarrasUtil.formataLinhaDigitavelTitulo(numeroDocumento);
                        for (i = 1; i < 6; ++i) {
                            CodigoBarrasUtil.validaBlocoParcialTituloDigitavel(numeroDocumento, i);
                        }
                        numeroBloco = 5;
                    } else {
                        if (confCTFClient.isCapturaApenasLinhaDigitavel() && numeroBloco == 1 && numeroDocumento.length() != 10) {
                            this.exibeMensagemErro(perifericos, inter.getMessage("VALCODBAR_ERRO_COD_INVALIDO"));
                            entradaApiTefC.setCodigoBarras(null);
                            Contexto.getContexto().setTipoConta(0);
                            return INVALID_CODE;
                        }
                        CodigoBarrasUtil.validaBlocoParcialTituloDigitavel(numeroDocumento, numeroBloco);
                    }
                    if (entradaApiTefC.getCodigoBarrasParcial() == null) {
                        entradaApiTefC.setCodigoBarrasParcial("");
                    }
                    entradaApiTefC.setCodigoBarrasParcial(entradaApiTefC.getCodigoBarrasParcial() + numeroDocumentoUltimoDigitado);
                    Contexto.getContexto().setNumeroBloco(++numeroBloco);
                    if (Contexto.getContexto().getNumeroBloco() <= 5) {
                        return CONTINUE_READING;
                    }
                }
            }
            catch (ExcecaoDigitoInvalido e) {
                if (numeroBloco > 4 && capturaCodigoCompleta) {
                    Contexto.getContexto().setNumeroBloco(1);
                    entradaApiTefC.setCodigoBarrasParcial(null);
                }
                this.exibeMensagemErro(perifericos, inter.getMessage("VALCODBAR_ERRO_COD_INVALIDO"));
                entradaApiTefC.setCodigoBarras(null);
                return INVALID_CODE;
            }
            catch (ExcecaoCodigoInvalido e) {
                if (tipoConta == 1 && numeroBloco == 5) {
                    Contexto.getContexto().setNumeroBloco(1);
                    entradaApiTefC.setCodigoBarras(null);
                    entradaApiTefC.setCodigoBarrasParcial(null);
                    Contexto.getContexto().setTipoConta(0);
                } else if (confCTFClient.isCapturaApenasLinhaDigitavel() && numeroBloco == 1) {
                    Contexto.getContexto().setTipoConta(0);
                }
                this.exibeMensagemErro(perifericos, inter.getMessage("VALCODBAR_ERRO_COD_INVALIDO"));
                entradaApiTefC.setCodigoBarras(null);
                return INVALID_CODE;
            }
        }
        AbstractCodigoPagamento codigoPagamento = null;
        if (tipoConta == 1) {
            codigoPagamento = entradaApiTefC.getModoEntradaCodigoBarras() == 3 || entradaApiTefC.getModoEntradaCodigoBarras() == 3 ? new CodigoBarrasTitulo(numeroDocumento) : new LinhaDigitavelTitulo(numeroDocumento);
        } else if (tipoConta == 2) {
            codigoPagamento = new CodigoBarrasConvenio(numeroDocumento);
        }
        if (codigoPagamento.getValor() != null && !codigoPagamento.getValor().equals(new BigDecimal("0.00"))) {
            entradaApiTefC.setValorDocumento(codigoPagamento.getValor());
            Contexto.getContexto().setConfirmaValorDocumento(true);
            Contexto.getContexto().setValorDocumentoCapturado(true);
        } else {
            Contexto.getContexto().setValorDocumentoCapturado(false);
        }
        if (tipoConta == 1) {
            ConfCTFClient config = ControladorConfCTFClient.getInstance().getConfig();
            IdentTerminal identTerminal = null;
            boolean multiTerminal = entradaIntegracao != null && entradaIntegracao.isMultiTerminal();
            boolean multiEC = config.isMultiEC();
            identTerminal = entradaIntegracao != null && (multiTerminal || multiEC) ? Contexto.getContexto().getEntradaIntegracao().getIdentTerminal() : new IdentTerminal(config.getEstabelecimento(), config.getLoja(), config.getTerminal());
            ControladorInicioDia controladorInicioDia = ControladorInicioDia.getInstance();
            DadosInicioDia dadosInicioDia = controladorInicioDia.getDadosInicioDia(identTerminal);
            if (dadosInicioDia.isIgnorarAusenciaDadosCodigoBarras()) {
                if (entradaApiTefC.getDataVencimentoCorBan() == null && ((CodigoPagamentoTitulo)codigoPagamento).getDataVencimento() == null) {
                    entradaApiTefC.setDataVencimentoCorBan(new Date());
                    Contexto.getContexto().setVencimentoCorBanCapturado(true);
                    Contexto.getContexto().setConfirmaVencimentoCorBan(false);
                }
                if (!Contexto.getContexto().isValorDocumentoCapturado()) {
                    entradaApiTefC.setValorDocumento(new BigDecimal("0.00"));
                    Contexto.getContexto().setConfirmaValorDocumento(false);
                    Contexto.getContexto().setValorDocumentoCapturado(true);
                }
            }
            if (entradaApiTefC.getDataVencimentoCorBan() == null) {
                entradaApiTefC.setDataVencimentoCorBan(((CodigoPagamentoTitulo)codigoPagamento).getDataVencimento());
                Contexto.getContexto().setVencimentoCorBanCapturado(entradaApiTefC.getDataVencimentoCorBan() != null);
                Contexto.getContexto().setConfirmaVencimentoCorBan(true);
            }
        } else if (tipoConta == 2) {
            entradaApiTefC.setDataVencimentoCorBan(new Date());
            Contexto.getContexto().setVencimentoCorBanCapturado(true);
            Contexto.getContexto().setConfirmaVencimentoCorBan(false);
        }
        if (entradaApiTefC.getModoEntradaCodigoBarras() == 1 && tipoConta == 2) {
            numeroDocumento = numeroDocumentoComDigitos;
        }
        if (!confCTFClient.isCapturaApenasLinhaDigitavel()) {
            entradaApiTefC.setCodigoBarras(numeroDocumento);
            return SUCESS;
        }
        if (entradaApiTefC.getModoEntradaCodigoBarras() != 1) return SUCESS;
        if (tipoConta == 1) {
            novoCodigo = CodigoBarrasUtil.converteLinhaDigitavelTitulo(numeroDocumento);
            entradaApiTefC.setCodigoBarras(novoCodigo);
            entradaApiTefC.setModoEntradaCodigoBarras(3);
            return SUCESS;
        }
        novoCodigo = CodigoBarrasUtil.converteLinhaDigitavelConvenio(numeroDocumento);
        entradaApiTefC.setCodigoBarras(novoCodigo);
        entradaApiTefC.setModoEntradaCodigoBarras(3);
        return SUCESS;
    }

    private void exibeMensagemErro(ControladorPerifericos perifericos, String mensagem) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(mensagem);
        perifericos.confirmaDado(displayModel);
    }
}

