/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import java.math.BigDecimal;

public class MicValidaValorCancelamento {
    public static final String UNECESSARY = "UNECESSARY";
    public static final String SUCESS = "SUCESS";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final String CANCELAMENTO_PARCIAL = "CANCELAMENTO_PARCIAL";
    public static final String VERIFICAR_FINANCIAMENTO = "VERIFICAR_FINANCIAMENTO";
    public static final String EXIBIR_DADOS_CANCELAMENTO = "EXIBIR_DADOS_CANCELAMENTO";
    public static final String ERROR = "ERROR";
    public static final String ERROR_AC = "ERROR_AC";

    public String execute(Process dados) throws ExcecaoApiAc {
        BigDecimal valorJaCancelado;
        BigDecimal valorTotalCancelamento;
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        boolean multiTerminal = Contexto.getContexto().getEntradaIntegracao() != null && Contexto.getContexto().getEntradaIntegracao().isMultiTerminal();
        ControladorPerifericos perifericos = dados.getPerifericos();
        boolean parcialHabilitado = Contexto.getContexto().getSaidaApiTefC().isCancelamentoParcial();
        EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saidaApiTefC = Contexto.getContexto().getSaidaApiTefC();
        BigDecimal valorTransacao = entradaApiTefC.getValorTransacao();
        BigDecimal valorCancelamento = entradaApiTefC.getValorCancelamento();
        BigDecimal valorMaxCancelamento = valorTransacao;
        BigDecimal percentualCancelamento = new BigDecimal(0);
        if (saidaApiTefC.getValorMaxCancelamento() != null) {
            valorMaxCancelamento = saidaApiTefC.getValorMaxCancelamento();
        }
        if (saidaApiTefC.getPercentualMaxCancelamento() != null) {
            percentualCancelamento = saidaApiTefC.getPercentualMaxCancelamento();
        }
        BigDecimal indice = percentualCancelamento.divide(new BigDecimal(100), 0);
        BigDecimal valorPercentual = valorTransacao.add(valorTransacao.multiply(indice));
        if (valorCancelamento.compareTo(valorMaxCancelamento) == 1) {
            if (multiTerminal) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5373, "O VALOR E MAIOR QUE O VALOR PERMITIDO PARA CANCELAMENTO"));
            }
            if (this.exibeMensagem(inter.getMessage("VALVALCAN_INVALID_VALUE"), perifericos).equals("ENTRA")) {
                if (parcialHabilitado) {
                    return CANCELAMENTO_PARCIAL;
                }
                entradaApiTefC.setDataTransacao(null);
                entradaApiTefC.setNsuCtf(-1);
                entradaApiTefC.setValorTransacao(null);
                entradaApiTefC.setValorCancelamento(null);
                Contexto.getContexto().resetCartao();
                return ERROR;
            }
            return USER_CANCEL;
        }
        if (valorCancelamento.compareTo(valorTransacao) == 1) {
            if (!parcialHabilitado) {
                if (multiTerminal) {
                    Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5374, "O VALOR DO CANCELAMENTO E MAIOR QUE O VALOR DA TRANSACAO ORIGINAL"));
                    return ERROR_AC;
                }
                if (this.exibeMensagem(inter.getMessage("VALVALCAN_INVALID_VALUE"), perifericos).equals("ENTRA")) {
                    return CANCELAMENTO_PARCIAL;
                }
                return USER_CANCEL;
            }
            if (valorCancelamento.compareTo(valorPercentual) == 1) {
                if (multiTerminal) {
                    Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5375, "O VALOR E MAIOR QUE O PERCENTUAL PARA CANCELAMENTO"));
                    return ERROR_AC;
                }
                if (this.exibeMensagem(inter.getMessage("VALVALCAN_INVALID_VALUE"), perifericos).equals("ENTRA")) {
                    if (parcialHabilitado) {
                        return CANCELAMENTO_PARCIAL;
                    }
                    return ERROR;
                }
                return USER_CANCEL;
            }
            if (Contexto.getContexto().isTransacaoSemLog()) {
                return VERIFICAR_FINANCIAMENTO;
            }
            return EXIBIR_DADOS_CANCELAMENTO;
        }
        if (Contexto.getContexto().isTransacaoSemLog()) {
            return VERIFICAR_FINANCIAMENTO;
        }
        if (parcialHabilitado && ((valorTotalCancelamento = valorCancelamento.add(valorJaCancelado = saidaApiTefC.getValorJaCancelado() != null ? saidaApiTefC.getValorJaCancelado() : new BigDecimal(0))).compareTo(valorPercentual) == 1 || valorTotalCancelamento.compareTo(valorMaxCancelamento) == 1)) {
            if (multiTerminal) {
                Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5376, "O VALOR DO CANCELAMENTO SOMADO AO VALOR JA CANCELADO E MAIOR QUE O PERCENTUAL PARA CANCELAMENTO"));
                return ERROR_AC;
            }
            if (this.exibeMensagem(inter.getMessage("VALVALCAN_INVALID_VALUE"), perifericos).equals("ENTRA")) {
                return CANCELAMENTO_PARCIAL;
            }
            return USER_CANCEL;
        }
        return EXIBIR_DADOS_CANCELAMENTO;
    }

    private String exibeMensagem(String msg, ControladorPerifericos perifericos) throws ExcecaoNaoLocal {
        LayoutDisplay displayModel = new LayoutDisplay(msg);
        EventoTeclado eventoTeclado = (EventoTeclado)perifericos.confirmaDado(displayModel);
        return eventoTeclado.getTeclaFinalizadora();
    }
}

