/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.Aid;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.controller.ControladorAIDsGetCard;
import com.csi.ctfclient.operacoes.model.controller.ControladorMultiEC;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.IdentTerminal;
import java.util.List;

public class MicVerificaLeituraCartaoCancelamento {
    public static final String CARD = "CARD";
    public static final String TELEPHONE = "TELEPHONE";
    public static final String CPF = "CPF";
    public static final String NOT_REQUIRED = "NOT_REQUIRED";
    public static final String OPERATION_NOT_ALLOWED = "OPERATION_NOT_ALLOWED";

    public String execute(Process dados) throws ExcecaoApiAc {
        SaidaApiTefC saida1G = Contexto.getContexto().getSaidaConsulta();
        if (saida1G.isCancelamentoLeituraCartao()) {
            String codigoTransacaoCancelamento;
            if (saida1G != null && saida1G.getCodigoTransacao() != null && (codigoTransacaoCancelamento = saida1G.getCodigoTransacao()) != null && (codigoTransacaoCancelamento.equals("12") || codigoTransacaoCancelamento.equals("10"))) {
                boolean multiTerminal = false;
                boolean delivery = false;
                EntradaApiTefC entradaApiTefC = Contexto.getContexto().getEntradaApiTefC();
                EntradaCTFClientCtrl entradaIntegracao = Contexto.getContexto().getEntradaIntegracao();
                if (entradaIntegracao != null) {
                    multiTerminal = entradaIntegracao.isMultiTerminal();
                    delivery = entradaIntegracao.getCodigoOrigemTransacao() == 1;
                } else {
                    delivery = entradaApiTefC.getIdentificacaoTransacao() == 1;
                }
                ConfCTFClient config = ControladorConfCTFClient.getInstance().getConfig();
                boolean multiEC = config.isMultiEC();
                IdentTerminal identTerminal = null;
                identTerminal = multiEC ? ControladorMultiEC.criarTerminalComumMultiEC(config.getCodigoGrupoMultiEC()) : (entradaIntegracao != null && (multiTerminal || delivery) ? entradaIntegracao.getIdentTerminal() : new IdentTerminal(config.getEstabelecimento(), config.getLoja(), config.getTerminal()));
                String tipoAplicacao = null;
                if (codigoTransacaoCancelamento.equals("12")) {
                    tipoAplicacao = "01";
                } else if (codigoTransacaoCancelamento.equals("10")) {
                    tipoAplicacao = "02";
                }
                ControladorAIDsGetCard controladorAIDsGetCard = ControladorAIDsGetCard.getInstance(identTerminal);
                if (controladorAIDsGetCard.getMapAid() != null) {
                    List<Aid> listAIDs = controladorAIDsGetCard.getMapAid().get(tipoAplicacao);
                    Contexto.getContexto().setListAID(listAIDs);
                }
            }
            return CARD;
        }
        if (saida1G.isCancelamentoSemCartao()) {
            Contexto.getContexto().setErrorCode(-1);
            return NOT_REQUIRED;
        }
        if (saida1G.isCancelamentoLeituraTelefone()) {
            return TELEPHONE;
        }
        if (saida1G.isCancelamentoLeituraCpf()) {
            return CPF;
        }
        throw new IllegalArgumentException("Flag de tipo de leitura de dado no cancelamento inv\u00e1lido");
    }
}

