/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.Process;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;
import java.text.DecimalFormat;

public class MicVerificaRespostaCompraSaque {
    public static final String SUCCESS = "SUCCESS";
    public static final String COMPRA_SEM_SAQUE = "COMPRA_SEM_SAQUE";
    public static final String DENIED = "DENIED";
    public static final String USER_CANCEL = "USER_CANCEL";
    private static final String RESP_CTF_COMPRA_SAQUE = "02";
    private ILogger logger = CTFClientLogger.getCTFClient();

    public String execute(Process dados) throws ExcecaoNaoLocal {
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        ControladorPerifericos periferico = dados.getPerifericos();
        EntradaApiTefC entrada = Contexto.getContexto().getEntradaApiTefC();
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        int codigoRetorno = saida.getRetorno();
        String codigoRespostaCTF = saida.getCodigoRespostaCTF();
        this.logger.log("DEBUG", "C\u00f3digo de retorno: " + codigoRetorno);
        this.logger.log("DEBUG", "C\u00f3digo de resposta do CTF: " + codigoRespostaCTF);
        if (codigoRetorno == 0 && codigoRespostaCTF != null && codigoRespostaCTF.equals(RESP_CTF_COMPRA_SAQUE)) {
            DecimalFormat format = new DecimalFormat("#,##0.00");
            String valorTransacaoFormatado = format.format(saida.getValorTransacao());
            LayoutDisplay displayModel = new LayoutDisplay();
            displayModel.addLinha(new Linha("COMPRA APROVADA SEM SAQUE"));
            displayModel.addLinha(new Linha("VALOR COMPRA:  " + valorTransacaoFormatado, 0, 1));
            displayModel.addLinha(new Linha(inter.getMessage("COMPRASAQUE_TITLE"), 0, 2));
            displayModel.addLinha(new Linha(inter.getMessage("COMPRASAQUE_PERMITE")));
            displayModel.addLinha(new Linha(inter.getMessage("COMPRASAQUE_NEGA")));
            int valor = 0;
            do {
                EventoTeclado eventoTeclado;
                if ((eventoTeclado = (EventoTeclado)periferico.capturaDado(displayModel, true, ConstantesApiAc.CAP_DECISAO_COMPRA_SAQUE)).getTeclaFinalizadora().equals("VOLTA")) {
                    return USER_CANCEL;
                }
                int num = eventoTeclado.getStringLida().length() - eventoTeclado.getNumCaracteresDigitados();
                String stringLida = eventoTeclado.getStringLida().substring(num);
                if (stringLida.length() <= 0) continue;
                valor = Integer.parseInt(stringLida.substring(num));
            } while (valor != 1 && valor != 2);
            switch (valor) {
                case 1: {
                    return COMPRA_SEM_SAQUE;
                }
                case 2: {
                    Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5378, "COMPRA SEM SAQUE NAO AUTORIZADA"));
                    entrada.setMotivoDesfazimento(4);
                    return DENIED;
                }
            }
            return DENIED;
        }
        return SUCCESS;
    }
}

