/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.apitef.model.TabelaCriptografia;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorBaixaTecnica;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.contexto.Contexto;
import com.csi.ctfclient.operacoes.entrada.ICriptografiaDUKPT;
import com.csi.ctfclient.operacoes.model.CodigoErroIntegracao;
import com.csi.ctfclient.operacoes.model.GetInfo;
import com.csi.ctfclient.operacoes.model.controller.ControladorCriptografia;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoRedecardEMV;
import com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad;
import com.csi.ctfclient.tools.util.CriptografiaUtil;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import com.csi.ctfclient.tools.util.logger.ILogger;

public class MicVerificacaoCriptografiaDUKPT {
    public static final String SUCCESS = "SUCCESS";
    public static final String SUCCESS_DUKPT = "SUCCESS_DUKPT";
    public static final String SUCCESS_INJETAR_CHAVE_DUKPT = "SUCCESS_INJETAR_CHAVE_DUKPT";
    public static final String SUCCESS_CRIPTOGRAFIA_CONTINGENCIA = "SUCCESS_CRIPTOGRAFIA_CONTINGENCIA";
    public static final String NOT_REQUIRED = "NOT_REQUIRED";
    public static final String NO_PINPAD = "NO_PINPAD";
    public static final String ERROR = "ERROR";
    private static final String MSG_OPERATION_NOT_ALLOWED = "OPERACAO NAO PERMITIDA";
    private ILogger logger = CTFClientLogger.getPeriferico();

    public String execute(ICriptografiaDUKPT dados) throws ExcecaoPerifericos {
        ControladorPerifericos periferico = dados.getPerifericos();
        boolean multiTerminal = false;
        boolean delivery = false;
        if (Contexto.getContexto().getEntradaIntegracao() != null) {
            multiTerminal = Contexto.getContexto().getEntradaIntegracao().isMultiTerminal();
            delivery = Contexto.getContexto().getEntradaIntegracao().getCodigoOrigemTransacao() == 1;
        } else {
            boolean bl = delivery = Contexto.getContexto().getEntradaApiTefC().getIdentificacaoTransacao() == 1;
        }
        if (multiTerminal || delivery) {
            return NOT_REQUIRED;
        }
        SaidaApiTefC saida = Contexto.getContexto().getSaidaApiTefC();
        TabelaCriptografia tabelaCriptografia = null;
        if (saida != null) {
            tabelaCriptografia = ControladorCriptografia.getTabelaCriptografia();
        }
        PinEMV pinpad = null;
        try {
            pinpad = periferico.getPin();
        }
        catch (ExcecaoPerifericos e1) {
            e1.printStackTrace();
        }
        if (pinpad == null) {
            return NO_PINPAD;
        }
        if (tabelaCriptografia != null) {
            if (tabelaCriptografia.getCriptografiaSenhaPrincipal() != null && tabelaCriptografia.getCriptografiaSenhaPrincipal().getAlgoritmo() == 3 || tabelaCriptografia.getCriptografiaDadosPrincipal() != null && tabelaCriptografia.getCriptografiaDadosPrincipal().getAlgoritmo() == 3) {
                if (!(pinpad instanceof BibliotecaPinpad)) {
                    this.logger.log("INFO", "Biblioteca compartilhada n\u00e3o utilizada, ignorando utiliza\u00e7\u00e3o da criptografia DUKPT");
                    return NO_PINPAD;
                }
                int indiceMasterKey = tabelaCriptografia.getCriptografiaSenhaPrincipal().getIndiceMasterKey();
                boolean dukptOk = false;
                try {
                    pinpad.getDUKPT(3, indiceMasterKey);
                    dukptOk = true;
                }
                catch (ExcecaoPerifericos e) {
                    this.logger.log("WARN", "Erro ao tentar utilizar DUKPT 3DES, \u00edndice: " + indiceMasterKey + ". Desc: " + e.getMessage());
                }
                if (dukptOk) {
                    this.logger.log("INFO", "Criptografia DUKPT suportada pelo Pinpad");
                    if (Contexto.getContexto().getTipoOperacao() != null && Contexto.getContexto().getTipoOperacao().equals("OPE_INJECAO_MANUAL_CHAVE_DUKPT")) {
                        String msg = "INJECAO CHAVES#CHAVE DUKPT JA EXISTENTE";
                        saida.setDisplayCTF(StringUtil.completaString(String.valueOf(msg.length()), 4, '0', 3) + msg);
                    }
                    return SUCCESS_DUKPT;
                }
                if (Contexto.getContexto().getDadosGetInfo() == null) {
                    SaidaGetInfoEMV getInfoEMV = periferico.getPin().getInfo();
                    GetInfo dadosGetInfo = new GetInfo();
                    dadosGetInfo.setCodigoRetorno(getInfoEMV.getRetorno());
                    dadosGetInfo.setFabricante(getInfoEMV.getFabricante());
                    dadosGetInfo.setModeloHardware(getInfoEMV.getModeloHardware());
                    dadosGetInfo.setNumeroSerie(getInfoEMV.getNumSeriePinpad());
                    dadosGetInfo.setVersaoEspecificao(getInfoEMV.getVersaoEspecificacao());
                    dadosGetInfo.setVersaoAplicacao(getInfoEMV.getVersaoAplBasica());
                    dadosGetInfo.setVersaoFirmware(getInfoEMV.getVersaoFirmware());
                    if (saida.getCodigoVan() == 0 || saida.getCodigoVan() == 68 || saida.getCodigoVan() == 90 || saida.getCodigoVan() == 37 || saida.getCodigoVanAlfa() != null && saida.getCodigoVanAlfa().equals("AA")) {
                        SaidaGetInfoRedecardEMV infoRedecardEMV = periferico.getPin().getInfoRedecard();
                        dadosGetInfo.setVersaoRedeAdquirente(infoRedecardEMV.getInformacaoProprietaria());
                    }
                    Contexto.getContexto().setDadosGetInfo(dadosGetInfo);
                } else if (Contexto.getContexto().getDadosGetInfo().getVersaoRedeAdquirente() == null && (saida.getCodigoVan() == 0 || saida.getCodigoVan() == 68 || saida.getCodigoVan() == 90 || saida.getCodigoVan() == 37)) {
                    SaidaGetInfoRedecardEMV infoRedecardEMV = periferico.getPin().getInfoRedecard();
                    Contexto.getContexto().getDadosGetInfo().setVersaoRedeAdquirente(infoRedecardEMV.getInformacaoProprietaria());
                }
                boolean baixaTecnicaSolicitada = false;
                try {
                    ControladorBaixaTecnica conBaixaTecnica = ControladorBaixaTecnica.getInstance();
                    baixaTecnicaSolicitada = conBaixaTecnica.isBaixaTecnicaSolicitada();
                }
                catch (ExcecaoApiAc e) {
                    baixaTecnicaSolicitada = false;
                    this.logger.log("WARN", "Erro ao recuperar os dados da baixa t\u00e9cnica, a tentativa de uso de chave DUKPT n\u00e3o ser\u00e1 realizada");
                    e.printStackTrace();
                }
                if (Contexto.getContexto().getTipoOperacao() != null && Contexto.getContexto().getTipoOperacao().equals("OPE_INJECAO_MANUAL_CHAVE_DUKPT")) {
                    if (CriptografiaUtil.verificaVersaoInjecaoChaves(Contexto.getContexto().getDadosGetInfo().getVersaoRedeAdquirente())) {
                        this.logger.log("INFO", "Opera\u00e7\u00e3o de inje\u00e7\u00e3o manual da chaves, a chave ser\u00e1 injetada");
                        return SUCCESS_INJETAR_CHAVE_DUKPT;
                    }
                    this.logger.log(ERROR, "A opera\u00e7\u00e3o de inje\u00e7\u00e3o manual da chaves n\u00e3o \u00e9 suportada pela vers\u00e3o do Pinpad. Vers\u00e3o da Rede adquirente: " + Contexto.getContexto().getDadosGetInfo().getVersaoRedeAdquirente());
                    Contexto.getContexto().setErroIntegracao(new CodigoErroIntegracao(5306, MSG_OPERATION_NOT_ALLOWED));
                    return ERROR;
                }
                if (baixaTecnicaSolicitada || dados.getTentativaInjecao() > 1) {
                    if (Contexto.getContexto().getDadosGetInfo().getVersaoRedeAdquirente() != null && CriptografiaUtil.verificaVersaoInjecaoChaves(Contexto.getContexto().getDadosGetInfo().getVersaoRedeAdquirente())) {
                        this.logger.log("INFO", "Chave DUKPT ausente, a chave ser\u00e1 injetada");
                        return SUCCESS_INJETAR_CHAVE_DUKPT;
                    }
                    this.logger.log("INFO", "Chave DUKPT ausente. A vers\u00e3o do Pinpad n\u00e3o suporta a inje\u00e7\u00e3o de chaves. Vers\u00e3o da Rede Adquirente: " + Contexto.getContexto().getDadosGetInfo().getVersaoRedeAdquirente());
                } else {
                    this.logger.log("INFO", "Chave DUKPT ausente.");
                }
                CriptografiaUtil.utilizaCriptografiaContingenciaDUKPT(tabelaCriptografia, this.logger);
                return SUCCESS_CRIPTOGRAFIA_CONTINGENCIA;
            }
            this.logger.log("DEBUG", "DUKPT n\u00e3o utilizado para criptografia de senha ou dados");
            return SUCCESS;
        }
        this.logger.log(ERROR, "Tabela de criptografia n\u00e3o carregada para tentativa de inje\u00e7\u00e3o de chaves");
        return ERROR;
    }

    public static void main(String[] args) {
        System.out.println(CriptografiaUtil.verificaVersaoInjecaoChaves("1.06a03"));
        System.out.println(CriptografiaUtil.verificaVersaoInjecaoChaves("1.06a04"));
        System.out.println(CriptografiaUtil.verificaVersaoInjecaoChaves("1.06a05"));
        System.out.println(CriptografiaUtil.verificaVersaoInjecaoChaves("1.06b00"));
        System.out.println(CriptografiaUtil.verificaVersaoInjecaoChaves("1.05a05"));
        System.out.println(CriptografiaUtil.verificaVersaoInjecaoChaves("1.07a"));
        System.out.println(CriptografiaUtil.verificaVersaoInjecaoChaves("1.07"));
        System.out.println(CriptografiaUtil.verificaVersaoInjecaoChaves("1.07a00"));
        System.out.println(CriptografiaUtil.verificaVersaoInjecaoChaves("2.00a00"));
        System.out.println(CriptografiaUtil.verificaVersaoInjecaoChaves("2"));
    }
}

