/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.model;

public class RegistroCriptografia {
    public static final int ALGORITMO_DES = 0;
    public static final int ALGORITMO_3DES = 1;
    public static final int ALGORITMO_DUKPT_DES = 2;
    public static final int ALGORITMO_DUKPT_3DES = 3;
    public static final int CHAVE_PRINCIPAL = 0;
    public static final int CHAVE_CONTINGENCIA = 1;
    public static final int TIPO_CHAVE_SENHA = 1;
    public static final int TIPO_CHAVE_DADOS = 2;
    private int indiceMasterKey;
    private int tipoChave;
    private int algoritmo;
    private int tamanhoChave;
    private String workingKey;
    private String checkValue;
    private int usoChave;
    private int slotDUKPT;
    private int codigoRede;
    private boolean indiceAuttar;
    private int indiceWorkingKey;

    public static RegistroCriptografia parse(String buffer) {
        if (buffer == null || buffer.length() < 51) {
            throw new IllegalArgumentException("Buffer do registro de criptografia nulo ou menos que 51 bytes");
        }
        RegistroCriptografia registro = new RegistroCriptografia();
        try {
            registro.setIndiceMasterKey(Integer.parseInt(buffer.substring(0, 2)));
            registro.setTipoChave(Integer.parseInt(buffer.substring(2, 3)));
            registro.setAlgoritmo(Integer.parseInt(buffer.substring(3, 4)));
            registro.setTamanhoChave(Integer.parseInt(buffer.substring(4, 6)));
            registro.setWorkingKey(buffer.substring(6, 6 + registro.getTamanhoChave()));
            registro.setCheckValue(buffer.substring(38, 46));
            registro.setUsoChave(Integer.parseInt(buffer.substring(46, 47)));
            registro.setslotDUKPT(Integer.parseInt(buffer.substring(47, 49)));
            registro.setCodigoRede(Integer.parseInt(buffer.substring(49, 51)));
            try {
                registro.setIndiceWorkingKey(Integer.parseInt(buffer.substring(51, 53)));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Buffer do registro de criptografia inv\u00e1lido: '" + buffer + "'");
        }
        return registro;
    }

    public int getIndiceMasterKey() {
        return this.indiceMasterKey;
    }

    public void setIndiceMasterKey(int indiceMasterKey) {
        this.indiceMasterKey = indiceMasterKey;
    }

    public int getTamanhoChave() {
        return this.tamanhoChave;
    }

    public void setTamanhoChave(int tamanhoChave) {
        this.tamanhoChave = tamanhoChave;
    }

    public String getWorkingKey() {
        return this.workingKey;
    }

    public void setWorkingKey(String workingKey) {
        this.workingKey = workingKey;
    }

    public String getCheckValue() {
        return this.checkValue;
    }

    public void setCheckValue(String checkValue) {
        this.checkValue = checkValue;
    }

    public int getUsoChave() {
        return this.usoChave;
    }

    public void setUsoChave(int usoChave) {
        this.usoChave = usoChave;
    }

    public int getSlotDUKPT() {
        return this.slotDUKPT;
    }

    public void setslotDUKPT(int slotDUKPT) {
        this.slotDUKPT = slotDUKPT;
    }

    public int getCodigoRede() {
        return this.codigoRede;
    }

    public void setCodigoRede(int codigoRede) {
        this.codigoRede = codigoRede;
    }

    public int getTipoChave() {
        return this.tipoChave;
    }

    public void setTipoChave(int tipoChave) {
        this.tipoChave = tipoChave;
    }

    public int getAlgoritmo() {
        return this.algoritmo;
    }

    public void setAlgoritmo(int algoritmo) {
        this.algoritmo = algoritmo;
    }

    public boolean isIndiceAuttar() {
        return this.indiceAuttar;
    }

    public void setIndiceAuttar(boolean indiceAuttar) {
        this.indiceAuttar = indiceAuttar;
    }

    public int getIndiceWorkingKey() {
        return this.indiceWorkingKey;
    }

    public void setIndiceWorkingKey(int indiceWorkingKey) {
        this.indiceWorkingKey = indiceWorkingKey;
    }

    public Object clone() {
        RegistroCriptografia registroClonado = new RegistroCriptografia();
        registroClonado.setIndiceMasterKey(this.getIndiceMasterKey());
        registroClonado.setTipoChave(this.getTipoChave());
        registroClonado.setAlgoritmo(this.getAlgoritmo());
        registroClonado.setTamanhoChave(this.getTamanhoChave());
        registroClonado.setWorkingKey(this.getWorkingKey());
        registroClonado.setCheckValue(this.getCheckValue());
        registroClonado.setUsoChave(this.getUsoChave());
        registroClonado.setslotDUKPT(this.getSlotDUKPT());
        registroClonado.setCodigoRede(this.getCodigoRede());
        registroClonado.setIndiceWorkingKey(this.getIndiceWorkingKey());
        return registroClonado;
    }
}

