/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.communication.access;

import com.csi.ctfclient.excecoes.ExcecaoParametroInvalido;
import com.csi.ctfclient.integracao.SocketGetData;
import com.csi.ctfclient.tools.communication.Host;
import com.csi.ctfclient.tools.communication.Servico;
import com.csi.ctfclient.tools.communication.access.ConectorTCPIP;
import com.csi.ctfclient.tools.communication.access.ExcecaoErroInstanciacaoServidor;
import com.csi.ctfclient.tools.communication.access.Servidor;
import com.csi.ctfclient.tools.communication.access.TratadorDeConexoesDeEntrada;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;

public class ServidorTCPIP
extends Servidor {
    private ServerSocket socketServidor;
    private Vector threadsControle;

    @Override
    public void finalizarServidor() {
        super.finalizarServidor();
        try {
            this.socketServidor.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ServidorTCPIP(Servico local, TratadorDeConexoesDeEntrada tratador, int maxConexoes) throws ExcecaoParametroInvalido, ExcecaoErroInstanciacaoServidor {
        super(local, tratador, maxConexoes);
        int numPorta;
        if (local == null) {
            throw new ExcecaoParametroInvalido("COM009");
        }
        if (maxConexoes < 1 || maxConexoes > 65535) {
            throw new ExcecaoParametroInvalido("COM037");
        }
        try {
            numPorta = Integer.parseInt(this.servicoLocal.getIdentificadorServico());
        }
        catch (Throwable e) {
            throw new ExcecaoParametroInvalido("COM038");
        }
        if (numPorta < 0 || numPorta > 65535) {
            throw new ExcecaoParametroInvalido("COM038");
        }
        try {
            this.socketServidor = new ServerSocket(numPorta, maxConexoes);
            this.socketServidor.setSoTimeout(0);
        }
        catch (IOException e) {
            throw new ExcecaoErroInstanciacaoServidor(e);
        }
        this.threadsControle = new Vector();
        for (int i = 0; i < 10; ++i) {
            ThreadControleServico t = new ThreadControleServico(i);
            t.start();
            this.threadsControle.add(t);
        }
    }

    public Host normalizaHost(Host host) {
        return null;
    }

    private class ThreadControleServico
    extends Thread {
        int numThread;

        public ThreadControleServico(int numThread) {
            this.numThread = numThread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!ServidorTCPIP.this.servidorFinalizado) {
                try {
                    ServerSocket serverSocket = ServidorTCPIP.this.socketServidor;
                    synchronized (serverSocket) {
                        Socket cliente = ServidorTCPIP.this.socketServidor.accept();
                        try {
                            ConectorTCPIP conexao = new ConectorTCPIP(cliente);
                            SocketGetData thread = ServidorTCPIP.this.tratadorConexoes.getThreadConexaoEntrada(conexao);
                            thread.start();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (IOException e) {
                }
            }
        }
    }
}

