/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices;

import com.csi.ctfclient.tools.devices.EventoPin;
import com.csi.ctfclient.tools.devices.PerifericoEntradaDados;
import com.csi.ctfclient.tools.devices.constants.TiposCriptografiaPin;
import com.csi.ctfclient.tools.devices.emv.ConstantesEMV;

public abstract class Pin
extends PerifericoEntradaDados
implements TiposCriptografiaPin,
ConstantesEMV {
    private int tamanho;
    private boolean autoskip;
    String valor = "";
    int tamSenha = 0;
    protected final char OK = (char)35;
    protected final char CANCEL = (char)42;
    private int tipoCriptografia;
    public static final String masterKeyPIN = "3132333435363738";
    public static final String workingKeyPIN = "96D0028878D58C89";
    private String msgAguardo;
    private String msgPrompt;
    private String msgSenha;
    public static final String PAN = "0000000000000";
    public static final int INDICE_MASTERKEY_CSI = 999999;
    private int indiceMasterKey;
    private int indiceMasterKeySolicSenha;
    private String numeroCartao;
    private String numeroCartaoCripto;
    private boolean comunicacaoSegura;
    private String workingKey;
    private String workingKeySolicSenha;

    public synchronized void caractereLido(char carac) {
        boolean cripto;
        if (!this.getHabilitado()) {
            return;
        }
        boolean bl = cripto = this.getTipoCriptografia() != 0;
        if (carac == '#' || carac == '*') {
            if (carac == '*') {
                this.tamSenha = 0;
            } else if (!cripto) {
                this.tamSenha = this.valor.length();
            } else {
                try {
                    this.tamSenha = Integer.parseInt(this.valor.substring(0, 2));
                }
                catch (Exception e) {
                    this.tamSenha = 0;
                }
                this.valor = this.valor.substring(2);
            }
            EventoPin evt = new EventoPin(this, this.valor, this.tamSenha, carac == '*', false, carac == '*' ? 13 : 0, this.getTipoCriptografia());
            this.eventoOcorrido(evt);
            this.valor = "";
        } else {
            this.valor = this.valor + carac;
            if (this.autoskip && this.valor.length() >= this.tamanho) {
                EventoPin evt = new EventoPin(this, this.valor, this.tamSenha, false, false, carac == '*' ? 13 : 0, this.getTipoCriptografia());
                this.eventoOcorrido(evt);
                this.valor = "";
            }
        }
    }

    public synchronized void erroOcorrido(int erro) {
        if (!this.getHabilitado()) {
            return;
        }
        EventoPin evt = new EventoPin(this, this.valor, 0, true, true, erro, this.getTipoCriptografia());
        this.eventoOcorrido(evt);
    }

    public abstract String getKey();

    public int getTipoCriptografia() {
        return this.tipoCriptografia;
    }

    @Override
    public long getTipoPeriferico() {
        return 4L;
    }

    public String getMsgAguardo() {
        return this.msgAguardo;
    }

    public String getMsgPrompt() {
        return this.msgPrompt;
    }

    public String getMsgSenha() {
        return this.msgSenha;
    }

    public void setMsgAguardo(String newMsgAguardo) {
        this.msgAguardo = newMsgAguardo;
    }

    public void setMsgPrompt(String newMsgPrompt) {
        this.msgPrompt = newMsgPrompt;
    }

    public void setMsgSenha(String newMsgSenha) {
        this.msgSenha = newMsgSenha;
    }

    public int getIndiceMasterKey() {
        return this.indiceMasterKey;
    }

    public int getIndiceMasterKeySolicSenha() {
        return this.indiceMasterKeySolicSenha;
    }

    public String getNumeroCartao() {
        return this.numeroCartao;
    }

    public String getNumeroCartaoCripto() {
        return this.numeroCartaoCripto;
    }

    public boolean isComunicacaoSegura() {
        return this.comunicacaoSegura;
    }

    public String getWorkingKey() {
        return this.workingKey;
    }

    public String getWorkingKeySolicSenha() {
        return this.workingKeySolicSenha;
    }

    public synchronized void setIndiceMasterKey(int newIndiceMasterKey) {
        this.indiceMasterKey = newIndiceMasterKey;
    }

    public synchronized void setIndiceMasterKeySolicSenha(int newIndiceMasterKeySolicSenha) {
        this.indiceMasterKeySolicSenha = newIndiceMasterKeySolicSenha;
    }

    public synchronized void setNumeroCartao(String newNumeroCartao) {
        this.numeroCartao = newNumeroCartao;
    }

    public synchronized void setNumeroCartaoCripto(String newNumeroCartaoCripto) {
        this.numeroCartaoCripto = newNumeroCartaoCripto;
    }

    public synchronized void setComunicacaoSegura(boolean comunicacaoSegura) {
        this.comunicacaoSegura = comunicacaoSegura;
    }

    public synchronized void setWorkingKey(String newWorkingKey) {
        this.workingKey = newWorkingKey;
    }

    public void setTipoCriptografia(int tipoCriptografia) {
        this.tipoCriptografia = tipoCriptografia;
    }

    public synchronized void setWorkingKeySolicSenha(String newWorkingKeySolicSenha) {
        this.workingKeySolicSenha = newWorkingKeySolicSenha;
    }
}

