/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.chronos;

import com.csi.ctfclient.tools.devices.EventoLeitorDocumento;
import com.csi.ctfclient.tools.devices.ExcecaoErroInicializacaoPeriferico;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.LeitorDocumento;
import com.csi.ctfclient.tools.devices.Periferico;
import com.csi.ctfclient.tools.devices.PerifericoEntradaDados;
import com.csi.ctfclient.tools.devices.chronos.ProtocoloChronos;
import com.csi.ctfclient.tools.devices.generic.ExcecaoPortaSerial;
import com.csi.ctfclient.tools.services.exceptions.ExcecaoLocal;
import java.io.IOException;
import javax.swing.JFrame;

public class LeitorDocumentoChronos
extends LeitorDocumento
implements Runnable {
    private boolean comunicacaoAberta = false;
    private String databits;
    private String parity;
    private String porta;
    private String speed;
    private String stopbits;
    private boolean leitorFinalizado = false;
    Thread leitorThread;
    private ProtocoloChronos protocolo;
    private boolean threadPronta = false;

    @Override
    public void liberaRecursos() throws ExcecaoPerifericos {
        this.desabilita();
        this.leitorFinalizado = true;
        this.leitorThread = null;
        super.liberaRecursos();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean achouErro = false;
        byte[] CMC7 = new byte[40];
        while (!this.leitorFinalizado) {
            if (this.leitorFinalizado) {
                return;
            }
            while (!this.getHabilitado()) {
                this.threadPronta = true;
                LeitorDocumentoChronos leitorDocumentoChronos = this;
                synchronized (leitorDocumentoChronos) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (!this.leitorFinalizado) continue;
                return;
            }
            try {
                this.protocolo.cmdCheque((byte)89);
                this.protocolo.cmdCheque((byte)90);
            }
            catch (IOException e) {
                this.erroOcorrido("PER83", 0);
            }
            CMC7 = this.protocolo.recebeCMC7(40000);
            try {
                if (CMC7 != null) {
                    String str = new String(CMC7);
                    this.codigoLido(str, 0);
                } else {
                    EventoLeitorDocumento evt = new EventoLeitorDocumento(this, "", 0, true, true, "PER83");
                    this.eventoOcorrido(evt);
                }
                this.protocolo.cmdCheque((byte)83);
                this.protocolo.cmdCheque((byte)87);
            }
            catch (IOException e) {
                this.erroOcorrido("PER83", 0);
            }
            this.setHabilitado(false);
        }
    }

    @Override
    public synchronized void desabilita() throws ExcecaoPerifericos {
        if (this.protocolo.getUsandoProtocolo() == 1) {
            this.protocolo.setCancelaEnvioComando(true);
            this.protocolo.setUsandoProtocolo(0);
        }
        if (this.getHabilitado()) {
            try {
                this.protocolo.cmdCheque((byte)83);
                this.protocolo.cmdCheque((byte)87);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.protocolo.fecharComunicacao();
            this.protocolo.setUsandoProtocolo(0);
            this.setHabilitado(false);
            this.notifyAll();
        }
    }

    @Override
    public synchronized void habilita() throws ExcecaoPerifericos {
        System.out.println("HABILITA!!!!");
        try {
            this.protocolo.abrirComunicacao();
            this.setHabilitado(true);
            this.protocolo.setCancelaEnvioComando(false);
            this.protocolo.setUsandoProtocolo(1);
            if ((this.protocolo.statusImpressora() & 4) == 0) {
                this.erroOcorrido("PER83", 0);
            }
            this.notifyAll();
        }
        catch (ExcecaoPortaSerial e) {
            throw new ExcecaoPerifericos((Periferico)this, e.getCodigo(), e);
        }
    }

    public static void main(String[] args) {
        try {
            JFrame frame = new JFrame("Um frame...");
            frame.setSize(800, 300);
            frame.setLocation(10, 10);
            frame.show();
            System.out.println("LeitorDocumento Tecpoint:: Vai instanciar");
            LeitorDocumentoChronos leitor = new LeitorDocumentoChronos("COM1", "9600", "8", "N", "1");
            System.out.println("LeitorDocumento Chronos:: Vai habilitar");
            ((Periferico)leitor).habilita();
            System.out.println("Passe um documento...");
            EventoLeitorDocumento evt = (EventoLeitorDocumento)leitor.leValor();
            System.out.println("Evento leitor      : " + evt.getCodigo() + "\nErro               : " + evt.getErro() + "\nErro C\u00f3digo        : " + evt.getErroCodigo() + "\nTimeout            : " + evt.getTimeout() + "\nTipoCodigo         : " + evt.getTipoCodigo());
            ((PerifericoEntradaDados)leitor).desabilita();
            System.out.println("desabilitou...");
        }
        catch (ExcecaoPerifericos e) {
            System.out.println("Erro: " + e);
            e.printStackTrace();
            System.out.println("Erro original: " + e.getExcecaoOriginal());
            e.getExcecaoOriginal().printStackTrace();
        }
        catch (Exception e) {
            System.out.println("Erro desconhecido: " + e);
            e.printStackTrace();
        }
    }

    public LeitorDocumentoChronos(String porta, String speed, String databits, String parity, String stopbits) throws ExcecaoPerifericos {
        this.porta = porta;
        this.speed = speed;
        this.databits = databits;
        this.parity = parity;
        this.stopbits = stopbits;
        try {
            this.protocolo = ProtocoloChronos.getInstanciaProtocolo(porta, speed, databits, parity, stopbits);
        }
        catch (ExcecaoLocal e) {
            throw new ExcecaoErroInicializacaoPeriferico((Periferico)this, e.getCodigo(), e);
        }
        if (this.protocolo.statusImpressora() == -1) {
            throw new ExcecaoErroInicializacaoPeriferico(this, "PER83");
        }
        this.leitorThread = new Thread(this);
        this.leitorThread.start();
        while (!this.threadPronta) {
        }
    }
}

