/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.chronos;

import com.csi.ctfclient.tools.devices.generic.ExcecaoPortaSerial;
import com.csi.ctfclient.tools.devices.generic.PortaSerial;
import com.csi.ctfclient.tools.services.exceptions.ExcecaoLocal;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;

final class ProtocoloChronos
implements SerialPortEventListener {
    public static PortaSerial porta = new PortaSerial();
    private static ProtocoloChronos instancia = null;
    private static boolean comunicacaoAberta = false;
    private ByteArrayOutputStream bufResp = new ByteArrayOutputStream();
    private static Integer qtdAberturas = new Integer(0);
    private String baudRatio;
    private String dataBits;
    private String parity;
    private String serial;
    private String stopBits;
    private int BIT0 = 1;
    private int BIT1 = 2;
    private int BIT2 = 4;
    private int BIT3 = 8;
    private int BIT4 = 16;
    private int BIT5 = 32;
    private int BIT6 = 64;
    private int BIT7 = 128;
    private boolean cancelaEnvioComando;
    public static final int LEITOR_EM_USO = 1;
    public static final int LEITOR_LIVRE = 0;
    private int usandoProtocolo = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void fecharComunicacao() {
        int qtd = 0;
        Integer n = qtdAberturas;
        synchronized (n) {
            qtd = qtdAberturas;
            if (qtd == 0) {
                return;
            }
            qtdAberturas = new Integer(--qtd);
            if (qtd == 0) {
                porta.fecharPortaSerial();
                comunicacaoAberta = false;
            }
        }
    }

    public void serialEvent(SerialPortEvent event) {
    }

    private ProtocoloChronos(String serial, String baudRatio, String dataBits, String parity, String stopBits) throws ExcecaoLocal {
        this.serial = serial;
        this.baudRatio = baudRatio;
        this.dataBits = dataBits;
        this.parity = parity;
        this.stopBits = stopBits;
        this.abrirComunicacao();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void abrirComunicacao() throws ExcecaoPortaSerial {
        Integer n = qtdAberturas;
        synchronized (n) {
            qtdAberturas = new Integer(qtdAberturas + 1);
            if (comunicacaoAberta) {
                return;
            }
            porta.abrirPortaSerial(this, this.serial, this.baudRatio, this.dataBits, this.parity, this.stopBits);
            ProtocoloChronos.porta.port.setRTS(true);
            ProtocoloChronos.porta.port.setDTR(true);
            ProtocoloChronos.porta.port.setInputBufferSize(2048);
            ProtocoloChronos.porta.port.setOutputBufferSize(2048);
            comunicacaoAberta = true;
            try {
                this.limpaSerial();
            }
            catch (IOException e) {
                throw new ExcecaoPortaSerial("PER83", e);
            }
        }
    }

    public int aguardaImpressao(int timeout) {
        int st;
        long marcador = System.currentTimeMillis();
        while (((st = this.statusImpressora()) == -1 || (st & this.BIT3) > 0) && System.currentTimeMillis() - marcador < (long)timeout) {
        }
        return st;
    }

    public void cmdCheque(byte cmd) throws IOException {
        this.limpaSerial();
        ProtocoloChronos.porta.out.write(27);
        ProtocoloChronos.porta.out.write(cmd);
    }

    public void cmdCheque(byte cmd, String parametro) throws IOException {
        this.limpaSerial();
        ProtocoloChronos.porta.out.write(27);
        ProtocoloChronos.porta.out.write(cmd);
        byte[] param = parametro.getBytes();
        for (int i = 0; i < param.length; ++i) {
            ProtocoloChronos.porta.out.write(param[i]);
        }
        ProtocoloChronos.porta.out.write(13);
    }

    public void enviaLinha(String linha) throws IOException {
        byte[] b = linha.getBytes();
        for (int i = 0; i < b.length; ++i) {
            ProtocoloChronos.porta.out.write(b[i]);
        }
        ProtocoloChronos.porta.out.write(10);
    }

    public int esperaDocumento(int timeout) {
        int aux = 0;
        try {
            while (ProtocoloChronos.porta.in.available() > 0) {
                ProtocoloChronos.porta.in.read();
            }
            long marcador = System.currentTimeMillis();
            do {
                ProtocoloChronos.porta.out.write(0);
                ProtocoloChronos.porta.out.flush();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (((aux = porta.receberByteTimeout(200)) & this.BIT2) != 0 && System.currentTimeMillis() - marcador < (long)timeout);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return (aux & this.BIT2) == 0 ? 1 : -1;
    }

    protected boolean getCancelaEnvioComando() {
        return this.cancelaEnvioComando;
    }

    public static synchronized ProtocoloChronos getInstanciaProtocolo(String serial, String baudRatio, String dataBits, String parity, String stopBits) throws ExcecaoLocal {
        if (instancia == null) {
            instancia = new ProtocoloChronos(serial, baudRatio, dataBits, parity, stopBits);
        }
        return instancia;
    }

    public int getUsandoProtocolo() {
        return this.usandoProtocolo;
    }

    public void limpaSerial() throws IOException {
        while (ProtocoloChronos.porta.in.available() > 0) {
            ProtocoloChronos.porta.in.read();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized byte[] recebeCMC7(int timeout) {
        int aux = -1;
        long tempoDecorrido = 0L;
        System.out.println("em recebe CMC7");
        int numBytesLidos = 0;
        byte[] bufferLeitura = new byte[50];
        long marcador = System.currentTimeMillis();
        try {
            while ((long)timeout > tempoDecorrido && ProtocoloChronos.porta.in.available() == 0 && !this.getCancelaEnvioComando()) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                tempoDecorrido = System.currentTimeMillis() - marcador;
            }
            if (this.getCancelaEnvioComando()) {
                System.out.println("%%%%%%%%%% caindo fora por cancelamento");
                return null;
            }
            if (ProtocoloChronos.porta.in.available() > 0) {
                aux = (byte)porta.receberByteTimeout(100);
            }
            if (aux == -1) {
                System.out.println("%%%%%%%%%% caindo fora por TIMEOUT");
                return null;
            }
            if (aux > 0) {
                bufferLeitura[0] = aux;
                numBytesLidos = 1;
            }
            while (true) {
                byte by = (byte)porta.receberByteTimeout(800);
                aux = by;
                if (by < 0) return null;
                System.out.println("aux = " + aux);
                if (aux != 0 && aux != 10 && aux != 13) {
                    bufferLeitura[numBytesLidos] = aux;
                    ++numBytesLidos;
                    continue;
                }
                if (aux == 13) break;
            }
            System.out.println("%%%%%%%%%% trilha lida de fato.");
            return bufferLeitura;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    protected void setCancelaEnvioComando(boolean cancela) {
        this.cancelaEnvioComando = cancela;
    }

    public void setUsandoProtocolo(int uso) {
        this.usandoProtocolo = uso;
    }

    public int statusImpressora() {
        try {
            ProtocoloChronos.porta.out.write(0);
            ProtocoloChronos.porta.out.flush();
        }
        catch (IOException e) {
            return -1;
        }
        return porta.receberByteTimeout(1000);
    }
}

