/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.config;

import com.csi.ctfclient.excecoes.ExcecaoConjuntoInvalido;
import com.csi.ctfclient.excecoes.ExcecaoObjetoInexistente;
import com.csi.ctfclient.excecoes.ExcecaoObjetoJaExistente;
import com.csi.ctfclient.info.tiposgerais.ChaveInteira;
import com.csi.ctfclient.info.tiposgerais.Colecao;
import com.csi.ctfclient.info.tiposgerais.Conjunto;
import com.csi.ctfclient.tools.devices.config.Tecla;
import java.io.Serializable;
import java.util.Enumeration;

public class ConjuntoTecla
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Conjunto elementos;

    public ConjuntoTecla() {
        this.elementos = new Colecao();
    }

    public ConjuntoTecla(ConjuntoTecla c) {
        this.elementos = new Colecao();
        if (c.elementos() != null) {
            Enumeration enumeration = c.elementos();
            while (enumeration.hasMoreElements()) {
                Object objeto = enumeration.nextElement();
                if (objeto == null) continue;
                this.inclui((Tecla)objeto);
            }
        }
    }

    public ConjuntoTecla(Conjunto conjunto) throws ExcecaoConjuntoInvalido {
        if (conjunto == null) {
            throw new ExcecaoConjuntoInvalido();
        }
        this.elementos = conjunto;
    }

    public Tecla busca(int codigo) throws ExcecaoObjetoInexistente {
        return this.busca(new ChaveInteira(codigo));
    }

    public Tecla busca(ChaveInteira codigo) throws ExcecaoObjetoInexistente {
        Object result = this.elementos.busca(codigo);
        if (result == null) {
            throw new ExcecaoObjetoInexistente();
        }
        return (Tecla)result;
    }

    public boolean consulta(int codigo) {
        return this.consulta(new ChaveInteira(codigo));
    }

    public boolean consulta(Tecla elemento) {
        return this.elementos.consulta(elemento.getChave());
    }

    public boolean consulta(ChaveInteira codigo) {
        return this.elementos.consulta(codigo);
    }

    public void deleta(int codigo) throws ExcecaoObjetoInexistente {
        this.deleta(new ChaveInteira(codigo));
    }

    public void deleta(Tecla elemento) throws ExcecaoObjetoInexistente {
        this.deleta((ChaveInteira)elemento.getChave());
    }

    public void deleta(ChaveInteira codigo) throws ExcecaoObjetoInexistente {
        this.elementos.deleta(codigo);
    }

    public Enumeration elementos() {
        return this.elementos.elementos();
    }

    public void inclui(Tecla elemento) {
        try {
            this.elementos.inclui(elemento);
        }
        catch (ExcecaoObjetoJaExistente excecaoObjetoJaExistente) {
            // empty catch block
        }
    }

    public void limpa() {
        this.elementos.limpa();
    }

    public int tamanho() {
        return this.elementos.tamanho();
    }
}

