/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.generic;

import com.csi.ctfclient.tools.devices.DisplayFisico;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.Periferico;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.StringTokenizer;
import javax.swing.JFrame;

public class DisplayFisicoCSI
extends DisplayFisico {
    private String nomeDev;
    private RandomAccessFile display;
    private byte[] buffer = new byte[100];
    private boolean acessoDriver = false;
    private static boolean libCarregada = false;

    @Override
    public void desabilita() throws ExcecaoPerifericos {
        this.setHabilitado(false);
    }

    private boolean getNumLinhasColunas() {
        try {
            if (!this.acessoDriver) {
                this.display.read(this.buffer, 0, 100);
            } else {
                this.read(this.buffer, (byte)10);
            }
        }
        catch (IOException e) {
            return false;
        }
        String str = new String(this.buffer);
        StringTokenizer tk = new StringTokenizer(str, " ");
        while (tk.hasMoreTokens()) {
            str = tk.nextToken();
            if (!str.equals("SIZE")) continue;
            str = tk.nextToken();
            this.numColunas = Integer.parseInt(str);
            str = tk.nextToken();
            this.numLinhas = Integer.parseInt(str);
            return true;
        }
        return false;
    }

    @Override
    public void habilita() throws ExcecaoPerifericos {
        this.setHabilitado(true);
    }

    @Override
    public void imprime(String texto) throws ExcecaoPerifericos {
        if (this.getHabilitado()) {
            int tamMax = (this.numLinhas - this.linhaAtual - 1) * this.numColunas + (this.numColunas - this.colunaAtual);
            if (texto.length() > tamMax) {
                texto = texto.substring(0, tamMax);
            }
            if (!texto.equals("")) {
                byte[] aux = ("MSG " + texto).getBytes();
                int sz = aux.length;
                for (int cont = 0; cont < sz; ++cont) {
                    this.buffer[cont] = aux[cont];
                }
                this.buffer[cont] = 0;
                try {
                    if (!this.acessoDriver) {
                        this.display.write(this.buffer, 0, sz);
                    } else {
                        this.write(this.buffer, (byte)sz);
                    }
                }
                catch (IOException e) {
                    throw new ExcecaoPerifericos((Periferico)this, "PER24", e);
                }
                this.reposiciona(texto);
            }
        }
    }

    @Override
    public void imprimeEm(int linha, int coluna, String texto) throws ExcecaoPerifericos {
        if (this.getHabilitado()) {
            int tamMax = (this.numLinhas - linha - 1) * this.numColunas + (this.numColunas - coluna);
            if (texto.length() > tamMax) {
                texto = texto.substring(0, tamMax);
            }
            this.linhaAtual = linha;
            this.colunaAtual = coluna;
            this.posicionaCursor(linha, coluna);
            if (!texto.equals("")) {
                byte[] aux = ("MSG " + texto).getBytes();
                int sz = aux.length;
                for (int cont = 0; cont < sz; ++cont) {
                    this.buffer[cont] = aux[cont];
                }
                this.buffer[cont] = 0;
                try {
                    if (!this.acessoDriver) {
                        this.display.write(this.buffer, 0, sz);
                    } else {
                        this.write(this.buffer, (byte)sz);
                    }
                }
                catch (IOException e) {
                    throw new ExcecaoPerifericos((Periferico)this, "PER24", e);
                }
                this.reposiciona(texto);
            }
        }
    }

    @Override
    public void liberaRecursos() throws ExcecaoPerifericos {
        this.desabilita();
        try {
            if (!this.acessoDriver) {
                this.display.close();
            } else {
                this.shutdown();
            }
        }
        catch (IOException e) {
            throw new ExcecaoPerifericos((Periferico)this, "PER03", e);
        }
    }

    @Override
    public void limpa() throws ExcecaoPerifericos {
        if (this.getHabilitado()) {
            this.posicionaCursor(0, 0);
            this.limpaTexto();
            byte[] aux = "CLS".getBytes();
            int sz = aux.length;
            for (int cont = 0; cont < sz; ++cont) {
                this.buffer[cont] = aux[cont];
            }
            this.buffer[cont] = 0;
            try {
                if (!this.acessoDriver) {
                    this.display.write(this.buffer, 0, sz);
                } else {
                    this.write(this.buffer, (byte)sz);
                }
            }
            catch (IOException e) {
                throw new ExcecaoPerifericos((Periferico)this, "PER22", e);
            }
        }
    }

    public static void main(String[] args) {
        block40: {
            Object f = null;
            try {
                DisplayFisicoCSI d = new DisplayFisicoCSI("LIBRARY:DisplayCSIWindows", "1", "231", "232");
                ((Periferico)d).habilita();
                System.out.println("Limpando display...");
                d.limpa();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.out.println("Escrevendo em 1,1...");
                d.imprimeEm(1, 1, "Mensagem...");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                String ddd = "MSG Testando o display ate quarenta cara";
                for (int i = 15; i <= 40; ++i) {
                    d.write(ddd.getBytes(), (byte)i);
                    Thread.sleep(500L);
                }
                String s = "MSG Teste";
                d.write(s.getBytes(), (byte)9);
                String s3 = "MSG Tes";
                d.write(s3.getBytes(), (byte)7);
                String s2 = "MSG Test";
                d.write(s2.getBytes(), (byte)8);
                String ss = "POS 9 1";
                d.write(ss.getBytes(), (byte)7);
                String sss = "MSG posic";
                d.write(sss.getBytes(), (byte)9);
                String ssss = "POS 10 1 ";
                d.write(ssss.getBytes(), (byte)9);
                System.out.println("Escrevendo na posicao atual...");
                d.imprime("continuada");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.out.println("Posicao setada para 0,0...");
                d.posicionaCursor(0, 0);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.out.println("Escrevendo na posicao atual...");
                d.imprime("Outra Mensagem...");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.out.println("Limpando display...");
                d.limpa();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.out.println("Wrapping da primeira para a segunda linha");
                d.imprime("1234567890123456789012345");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.out.println("Escrevendo outra coisa...");
                d.imprime("outra coisa");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.out.println("Limpando display...");
                d.limpa();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.out.println("Wrapping no final");
                d.imprimeEm(0, 9, "123456789012345");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.out.println("Escrevendo outra coisa...");
                d.imprimeEm(0, 0, "outra coisa");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.out.println("Limpando display...");
                d.limpa();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.out.println("Wrapping na linha e no final");
                d.imprimeEm(0, 0, "1234567890123456789012345678901234567890pulou");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.out.println("Escrevendo outra coisa...");
                d.imprimeEm(0, 0, "outra coisa");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.out.println("Limpando display...");
                d.limpa();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.out.println("Mais um teste");
                d.posicionaCursor(0, 18);
                d.imprime("1234567890123456789012345");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.out.println("Escrevendo outra coisa...");
                d.imprime("outra coisa");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.out.println("Limpando display...");
                d.limpa();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ((Periferico)d).liberaRecursos();
                System.exit(0);
            }
            catch (ExcecaoPerifericos e) {
                System.out.println("Erro: " + e);
                e.printStackTrace();
            }
            catch (Throwable t) {
                System.out.println("Erro grande: " + t);
                t.printStackTrace();
                if (!(t instanceof ExceptionInInitializerError)) break block40;
                ExceptionInInitializerError e2 = (ExceptionInInitializerError)t;
                System.out.println("Excecao original: " + e2.getException());
            }
        }
    }

    @Override
    public void posicionaCursor(int linha, int coluna) throws ExcecaoPerifericos {
        if (this.getHabilitado()) {
            this.linhaAtual = linha;
            this.colunaAtual = coluna;
            byte[] aux = ("POS " + (coluna + 1) + " " + (linha + 1)).getBytes();
            int sz = aux.length;
            for (int cont = 0; cont < sz; ++cont) {
                this.buffer[cont] = aux[cont];
            }
            this.buffer[cont] = 0;
            try {
                if (!this.acessoDriver) {
                    this.display.write(this.buffer, 0, sz);
                } else {
                    this.write(this.buffer, (byte)sz);
                }
            }
            catch (IOException e) {
                throw new ExcecaoPerifericos((Periferico)this, "PER23", e);
            }
        }
    }

    private void setStringInicioFim(String inicio, String fim) throws ExcecaoPerifericos {
        byte[] aux = ("HAB " + inicio + " " + fim).getBytes();
        int sz = aux.length;
        for (int cont = 0; cont < sz; ++cont) {
            this.buffer[cont] = aux[cont];
        }
        this.buffer[cont] = 0;
        try {
            if (!this.acessoDriver) {
                this.display.write(this.buffer, 0, sz);
            } else {
                this.write(this.buffer, (byte)sz);
            }
        }
        catch (IOException e) {
            throw new ExcecaoPerifericos((Periferico)this, "PER23", e);
        }
    }

    private void setTipoDisplay(String tipo) throws ExcecaoPerifericos {
        byte[] aux = ("ID: " + tipo).getBytes();
        int sz = aux.length;
        for (int cont = 0; cont < sz; ++cont) {
            this.buffer[cont] = aux[cont];
        }
        this.buffer[cont] = 0;
        try {
            if (!this.acessoDriver) {
                this.display.write(this.buffer, 0, sz);
            } else {
                this.write(this.buffer, (byte)sz);
            }
        }
        catch (IOException e) {
            throw new ExcecaoPerifericos((Periferico)this, "PER23", e);
        }
    }

    protected native void read(byte[] var1, byte var2) throws IOException;

    protected native void shutdown() throws IOException;

    protected native void start() throws IOException;

    protected native void write(byte[] var1, byte var2) throws IOException;

    public DisplayFisicoCSI(JFrame f, String nomeDevice, String tipoDevice, String charInicio, String charFim) throws ExcecaoPerifericos {
        this.nomeDev = nomeDevice;
        this.linhaAtual = 0;
        this.colunaAtual = 0;
        int indice = this.nomeDev.indexOf("LIBRARY:");
        this.acessoDriver = indice != -1;
        try {
            if (!this.acessoDriver) {
                this.display = new RandomAccessFile(this.nomeDev, "rw");
            } else {
                if (!libCarregada) {
                    libCarregada = true;
                    System.loadLibrary(this.nomeDev.substring(8));
                }
                this.start();
            }
        }
        catch (IOException e) {
            throw new ExcecaoPerifericos((Periferico)this, "PER21", e);
        }
        catch (SecurityException e) {
            throw new ExcecaoPerifericos((Periferico)this, "PER21", e);
        }
        this.setTipoDisplay(tipoDevice);
        this.setStringInicioFim(charInicio, charFim);
        if (!this.getNumLinhasColunas()) {
            throw new ExcecaoPerifericos((Periferico)this, "PER21", null);
        }
        this.limpa();
    }

    public DisplayFisicoCSI(String nomeDevice, String tipoDevice, String charInicio, String charFim) throws ExcecaoPerifericos {
        this.nomeDev = nomeDevice;
        this.linhaAtual = 0;
        this.colunaAtual = 0;
        int indice = this.nomeDev.indexOf("LIBRARY:");
        this.acessoDriver = indice != -1;
        try {
            if (!this.acessoDriver) {
                this.display = new RandomAccessFile(this.nomeDev, "rw");
            } else {
                if (!libCarregada) {
                    libCarregada = true;
                    System.loadLibrary(this.nomeDev.substring(8));
                }
                this.start();
            }
        }
        catch (IOException e) {
            throw new ExcecaoPerifericos((Periferico)this, "PER21", e);
        }
        catch (SecurityException e) {
            throw new ExcecaoPerifericos((Periferico)this, "PER21", e);
        }
        this.setTipoDisplay(tipoDevice);
        this.setStringInicioFim(charInicio, charFim);
        if (!this.getNumLinhasColunas()) {
            throw new ExcecaoPerifericos((Periferico)this, "PER21", null);
        }
        this.limpa();
    }
}

