/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.javapos;

import com.csi.ctfclient.tools.devices.DisplayFisico;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.Periferico;
import javax.swing.JFrame;
import jpos.JposException;
import jpos.LineDisplay;

public class DisplayFisicoJavaPOS
extends DisplayFisico {
    private LineDisplay display;
    private boolean displayLimpo = false;

    @Override
    public void desabilita() throws ExcecaoPerifericos {
        try {
            this.display.setDeviceEnabled(false);
            this.setHabilitado(false);
        }
        catch (JposException e) {
            throw new ExcecaoPerifericos((Periferico)this, "PER02", (Exception)((Object)e));
        }
    }

    @Override
    public void habilita() throws ExcecaoPerifericos {
        try {
            this.display.setDeviceEnabled(true);
            this.setHabilitado(true);
            this.displayLimpo = false;
        }
        catch (JposException e) {
            throw new ExcecaoPerifericos((Periferico)this, "PER01", (Exception)((Object)e));
        }
    }

    @Override
    public void imprime(String texto) throws ExcecaoPerifericos {
        this.imprimeEm(this.linhaAtual, this.colunaAtual, texto);
    }

    @Override
    public void imprimeEm(int linha, int coluna, String texto) throws ExcecaoPerifericos {
        int tamTexto = texto.length();
        if (tamTexto > 0) {
            int tamMax = (this.numLinhas - linha - 1) * this.numColunas + (this.numColunas - coluna);
            if (tamTexto > tamMax) {
                texto = texto.substring(0, tamMax);
            }
            try {
                boolean branco = texto.trim().equals("");
                if (!this.displayLimpo || !branco) {
                    this.display.displayTextAt(linha, coluna, texto, 0);
                }
                this.linhaAtual = linha;
                this.colunaAtual = coluna;
                this.reposiciona(texto);
                if (!branco) {
                    this.displayLimpo = false;
                }
            }
            catch (JposException e) {
                throw new ExcecaoPerifericos((Periferico)this, "PER24", (Exception)((Object)e));
            }
        }
    }

    @Override
    public void liberaRecursos() throws ExcecaoPerifericos {
        try {
            this.display.setDeviceEnabled(false);
            this.display.release();
            this.display.close();
        }
        catch (JposException e) {
            throw new ExcecaoPerifericos((Periferico)this, "PER03", (Exception)((Object)e));
        }
    }

    @Override
    public void limpa() throws ExcecaoPerifericos {
        if (!this.displayLimpo) {
            try {
                this.display.clearText();
                this.colunaAtual = 0;
                this.linhaAtual = 0;
                this.limpaTexto();
                this.displayLimpo = true;
            }
            catch (JposException e) {
                throw new ExcecaoPerifericos((Periferico)this, "PER22", (Exception)((Object)e));
            }
        }
    }

    @Override
    public void posicionaCursor(int linha, int coluna) throws ExcecaoPerifericos {
        if (linha != this.linhaAtual || coluna != this.colunaAtual) {
            try {
                this.display.setCursorRow(linha);
                this.display.setCursorColumn(coluna);
                this.linhaAtual = linha;
                this.colunaAtual = coluna;
            }
            catch (JposException e) {
                throw new ExcecaoPerifericos((Periferico)this, "PER23", (Exception)((Object)e));
            }
        }
    }

    public DisplayFisicoJavaPOS(JFrame f) throws ExcecaoPerifericos {
        this(f, "defaultDisplay");
    }

    public DisplayFisicoJavaPOS(JFrame f, String nomeLogico) throws ExcecaoPerifericos {
        if (f != null) {
            f.dispose();
        }
        try {
            this.display = new LineDisplay();
            this.display.open(nomeLogico);
            this.display.claim(100);
            try {
                this.display.setMarqueeType(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.display.setCursorUpdate(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.display.setInterCharacterWait(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.display.setFreezeEvents(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.display.setDeviceEnabled(true);
            this.linhaAtual = 0;
            this.colunaAtual = 0;
            this.numLinhas = 2;
            this.numColunas = this.display.getColumns();
            this.limpa();
        }
        catch (JposException e) {
            e.printStackTrace();
            throw new ExcecaoPerifericos((Periferico)this, "PER21", (Exception)((Object)e));
        }
    }
}

