/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.javapos;

import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.Periferico;
import com.csi.ctfclient.tools.devices.Teclado;
import com.csi.ctfclient.tools.devices.config.ConfiguracaoTeclado;
import java.awt.Frame;
import jpos.JposException;
import jpos.POSKeyboard;
import jpos.events.DataEvent;
import jpos.events.DataListener;

public class TecladoJavaPOS
extends Teclado
implements DataListener {
    private POSKeyboard teclado;
    private long ultimoEvento = -1L;
    private int ultimoCodigo = -1;

    public TecladoJavaPOS() throws ExcecaoPerifericos {
        this("defaultKeyboard");
    }

    public TecladoJavaPOS(ConfiguracaoTeclado config, Frame frame, String nomeLogico) throws ExcecaoPerifericos {
        super(config, frame);
        try {
            this.teclado = new POSKeyboard();
            this.teclado.addDataListener((DataListener)this);
            this.teclado.open(nomeLogico);
        }
        catch (JposException e) {
            throw new ExcecaoPerifericos((Periferico)this, "PER31", (Exception)((Object)e));
        }
    }

    public TecladoJavaPOS(String nomeLogico) throws ExcecaoPerifericos {
        try {
            this.teclado = new POSKeyboard();
            this.teclado.addDataListener((DataListener)this);
            this.teclado.open(nomeLogico);
        }
        catch (JposException e) {
            throw new ExcecaoPerifericos((Periferico)this, "PER31", (Exception)((Object)e));
        }
    }

    public void dataOccurred(DataEvent evt) {
        try {
            long instanteAtual = System.currentTimeMillis();
            int codTecla = this.teclado.getPOSKeyData();
            if (instanteAtual - this.ultimoEvento <= 60L && this.ultimoCodigo == codTecla) {
                this.teclado.setDataEventEnabled(true);
                return;
            }
            this.ultimoEvento = instanteAtual;
            this.ultimoCodigo = codTecla;
            super.teclaRecebida(codTecla);
            this.teclado.setDataEventEnabled(true);
        }
        catch (JposException jposException) {
            // empty catch block
        }
    }

    @Override
    public void desabilita() throws ExcecaoPerifericos {
        if (!this.getHabilitado()) {
            return;
        }
        try {
            this.teclado.setDeviceEnabled(false);
            this.teclado.release();
            this.setHabilitado(false);
            super.desabilita();
        }
        catch (JposException e) {
            throw new ExcecaoPerifericos((Periferico)this, "PER02", (Exception)((Object)e));
        }
    }

    @Override
    public void habilita() throws ExcecaoPerifericos {
        if (this.getHabilitado()) {
            return;
        }
        try {
            this.teclado.claim(100);
            this.teclado.setDeviceEnabled(true);
            this.teclado.setDataEventEnabled(true);
            this.setHabilitado(true);
        }
        catch (JposException e) {
            throw new ExcecaoPerifericos((Periferico)this, "PER01", (Exception)((Object)e));
        }
    }

    @Override
    public void liberaRecursos() throws ExcecaoPerifericos {
        if (this.getHabilitado()) {
            this.desabilita();
        }
        try {
            this.teclado.close();
            this.teclado.removeDataListener((DataListener)this);
            super.liberaRecursos();
        }
        catch (JposException e) {
            throw new ExcecaoPerifericos((Periferico)this, "PER03", (Exception)((Object)e));
        }
    }
}

