/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.postef.servico;

import br.com.auttar.clientservices.AuttarServicesClient;
import br.com.auttar.clientservices.model.Checkout;
import br.com.auttar.clientservices.model.PaymentResult;
import br.com.auttar.clientservices.services.Configuration;
import br.com.auttar.clientservices.services.PaymentRequestListener;
import br.com.auttar.clientservices.services.PaymentResultListener;
import br.com.auttar.clientservices.services.SessionMessage;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ConfClienteServico;
import com.csi.ctfclient.config.ConfPOSTef;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.postef.POSTef;
import com.csi.ctfclient.tools.devices.postef.model.TipoMensagem;
import com.csi.ctfclient.tools.devices.postef.servico.ConfiguracaoServico;
import com.csi.ctfclient.tools.devices.postef.servico.ConsultaPagamentoPOSTefServico;
import com.csi.ctfclient.tools.devices.postef.servico.ProvedorMensagemServico;
import com.csi.ctfclient.tools.devices.postef.servico.RespostaPagamentoPOSTefServico;

public class POSTefServico
extends POSTef<ProvedorMensagemServico<?>> {
    private AuttarServicesClient auttarServicesClient;
    private PaymentRequestListener paymentRequestListener = new PaymentRequestListener(){

        public void onGetPayment(SessionMessage sessionMessage, Checkout checkout) {
            ProvedorMensagemServico<Checkout> gerenciadorMensagemServico = new ProvedorMensagemServico<Checkout>(TipoMensagem.pagamento_postef, sessionMessage, checkout);
            POSTefServico.this.handler(gerenciadorMensagemServico);
        }
    };
    private PaymentResultListener paymentResultListener = new PaymentResultListener(){

        public void onPaymentResult(SessionMessage sessionMessage, PaymentResult paymentResult) {
            ProvedorMensagemServico<PaymentResult> gerenciadorMensagemServico = new ProvedorMensagemServico<PaymentResult>(TipoMensagem.resposta_pagamento_postef, sessionMessage, paymentResult);
            POSTefServico.this.handler(gerenciadorMensagemServico);
        }
    };

    @Override
    public void conecta() {
        if (!this.isInicializado()) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        POSTefServico.this.log.info("Inicializando AuttarServicesClient...");
                        ConfCTFClient confCTFClient = ControladorConfCTFClient.getInstance().getConfig();
                        ConfClienteServico configClienteServico = confCTFClient.getConfClienteServico();
                        ConfPOSTef confPOSTef = confCTFClient.getConfPOSTef();
                        if (configClienteServico != null && configClienteServico.isHabilitado()) {
                            ConfiguracaoServico configuracaoServico = new ConfiguracaoServico();
                            configuracaoServico.setCompanyCode(confCTFClient.getEstabelecimento());
                            configuracaoServico.setStoreCode(confCTFClient.getLoja());
                            configuracaoServico.setMessageBrokerUrl(configClienteServico.getHost());
                            if (confPOSTef != null && confPOSTef.isHabilitado()) {
                                configuracaoServico.setMobilePosCode(confPOSTef.getTerminalPosMovel());
                            }
                            configuracaoServico.setExternalCode(configClienteServico.getCodigoPdv());
                            configuracaoServico.setMessageBrokerUser("guest");
                            configuracaoServico.setMessageBrokerPassword("guest");
                            POSTefServico.this.auttarServicesClient = new AuttarServicesClient((Configuration)configuracaoServico);
                            if (POSTefServico.this.auttarServicesClient.connect()) {
                                POSTefServico.this.log.info("AuttarServicesClient inicializado.");
                                if (confPOSTef != null && confPOSTef.isHabilitado()) {
                                    if (confPOSTef.getTerminalPosMovel() != null) {
                                        POSTefServico.this.auttarServicesClient.addPaymentRequestListener(POSTefServico.this.paymentRequestListener);
                                        POSTefServico.this.auttarServicesClient.addPaymentResultListener(POSTefServico.this.paymentResultListener);
                                        POSTefServico.this.log.info("listeners posmovel configurado para POS '" + confPOSTef.getTerminalPosMovel() + "'");
                                    } else {
                                        POSTefServico.this.log.warn("configuaracao posmovel invalida. necessario informar o codigo do POS associado.");
                                    }
                                }
                                POSTefServico.this.setInicializado(true);
                                while (POSTefServico.this.isInicializado()) {
                                    Thread.sleep(500L);
                                }
                            } else {
                                POSTefServico.this.log.error("AuttarServicesClient nao inicializado.");
                            }
                        }
                    }
                    catch (Exception e) {
                        POSTefServico.this.log.error("nao foi possivel inicializar AuttarServicesClient -> " + e.getMessage(), e);
                    }
                }
            };
            t.start();
        }
    }

    @Override
    public void desconecta() throws ExcecaoPerifericos {
        super.desconecta();
        this.log.info("finalizando AuttarServicesClient...");
        if (this.auttarServicesClient != null) {
            if (this.auttarServicesClient.disconnect()) {
                this.log.info("AuttarServicesClient finalizado.");
            } else {
                this.log.error("AuttarServicesClient nao finalizado.");
            }
        } else {
            this.log.info("solicitacao invalida. AuttarServicesClient nao inicializado.");
        }
    }

    @Override
    protected synchronized void handlerPagamentoPOSTef(ProvedorMensagemServico<?> messageManager) {
        super.handlerPagamentoPOSTef(messageManager);
        ConsultaPagamentoPOSTefServico pagamentoPOSTefServico = new ConsultaPagamentoPOSTefServico(messageManager, this.getPagamentoPendente(), this.getTimestampPagamento());
        this.execute(pagamentoPOSTefServico);
    }

    @Override
    protected synchronized void handlerResultadoPagamento(ProvedorMensagemServico<?> messageManager) {
        super.handlerResultadoPagamento(messageManager);
        RespostaPagamentoPOSTefServico respostaPagamentoPOSTefServico = new RespostaPagamentoPOSTefServico(messageManager, this, this.getPosTefListener());
        this.execute(respostaPagamentoPOSTefServico);
    }
}

