/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.util;

import com.csi.ctfclient.tools.util.StringUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    private static final long MSEC_PER_HOUR = 3600000L;
    private static final long MSEC_PER_DAY = 86400000L;

    public static boolean equalsData(Date dt1, Date dt2) {
        if (dt1 == null || dt2 == null) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dt1);
        int day1 = calendar.get(5);
        int month1 = calendar.get(2);
        int year1 = calendar.get(1);
        calendar.setTime(dt2);
        int day2 = calendar.get(5);
        int month2 = calendar.get(2);
        int year2 = calendar.get(1);
        return day1 == day2 && month1 == month2 && year1 == year2;
    }

    public static int diferencaDias(Date dataMaior, Date dataMenor) {
        Date dt1 = DateUtil.removerHora(dataMaior);
        Date dt2 = DateUtil.removerHora(dataMenor);
        return (int)((dt1.getTime() - dt2.getTime()) / 86400000L);
    }

    public static Date removerHora(Date data) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(data);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static String parse(Date date, String format) {
        if (date == null) {
            return null;
        }
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            return dateFormat.format(date);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String parseToString(String date, String format) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        String data = dateFormat.format(date);
        return data;
    }

    public static Date parse(String data, String format) {
        Date date = null;
        if (StringUtil.isEmpty(data)) {
            return null;
        }
        try {
            date = new SimpleDateFormat(format).parse(data);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }
}

