/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.util;

import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.excecoes.ExcecaoArquivoCorrompido;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.util.HashMap;

public class PersistenciaObjetos {
    public static final String CAMINHO_PADRAO_PERSISTENCIA = "arquivo.txt";
    private HashMap hash;
    private String path;

    public PersistenciaObjetos(String path) throws ExcecaoApiAc {
        if (path != null) {
            File arquivo;
            this.path = path;
            if (path.lastIndexOf("/") != -1 && !(arquivo = new File(path.substring(0, path.lastIndexOf("/")))).exists()) {
                arquivo.mkdirs();
            }
        } else {
            this.path = CAMINHO_PADRAO_PERSISTENCIA;
        }
        if (new File(path).exists()) {
            try {
                this.load();
            }
            catch (ExcecaoArquivoCorrompido e) {
                this.hash = new HashMap();
            }
        } else {
            this.hash = new HashMap();
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void save(String key, Object obj) {
        this.hash.put(key, obj);
    }

    public Object get(String key) {
        if (this.hash == null) {
            return null;
        }
        Object obj = this.hash.get(key);
        return obj;
    }

    public void persist(boolean overwrite) throws ExcecaoApiAc {
        File file;
        if (!overwrite && (file = new File(this.path)).exists()) {
            throw new ExcecaoApiAc("O arquivo a ser persistido j\u00e1 existe e n\u00e3o poder\u00e1 ser substituido.");
        }
        try {
            ObjectOutputStream output = new ObjectOutputStream(new FileOutputStream(this.path));
            output.writeObject(this.hash);
            output.close();
        }
        catch (Exception e) {
            throw new ExcecaoApiAc("CMOS01", "ERRO READ", "", e);
        }
    }

    public void load() throws ExcecaoApiAc, ExcecaoArquivoCorrompido {
        try {
            ObjectInputStream input = null;
            FileInputStream fileInput = null;
            try {
                fileInput = new FileInputStream(this.path);
                input = new ObjectInputStream(fileInput);
            }
            catch (StreamCorruptedException e1) {
                System.out.println("O arquivo " + this.path + " est\u00e1 corrompido e ser\u00e1 deletado");
                fileInput.close();
                File file = new File(this.path);
                if (file.exists()) {
                    System.out.println(this.path + " deletado " + file.delete());
                }
                throw new ExcecaoArquivoCorrompido();
            }
            try {
                Object obj = input.readObject();
                if (!(obj instanceof HashMap)) {
                    this.hash = null;
                    throw new ExcecaoApiAc("O objeto lido a partir do arquivo persistido n\u00e3o \u00e9 um HashMap");
                }
                this.hash = (HashMap)obj;
            }
            catch (ClassNotFoundException e) {
                throw new ExcecaoApiAc("CMOS00", "LOAD", "CLASSNOTFOUND", e);
            }
        }
        catch (IOException e) {
            throw new ExcecaoApiAc("CMOS00", "ERRO", "ERRO_FILE", e);
        }
    }
}

