/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services;

import com.ibm.jpos.services.DeviceService;
import com.ibm.jpos.services.ServiceInfo;
import com.ibm.jpos.services.ServiceKey;
import java.util.Enumeration;
import java.util.Hashtable;

public final class ServiceRegistry {
    private Hashtable hashTable = new Hashtable();
    private static ServiceRegistry instance = null;

    private ServiceRegistry() {
    }

    public static synchronized ServiceRegistry getInstance() {
        if (instance == null) {
            instance = new ServiceRegistry();
        }
        return instance;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("=======================================\n");
        stringBuffer.append("Service Registry Contents\n");
        stringBuffer.append("Number of (ServiceKey, ServiceInfo) pairs = " + this.hashTable.size() + "\n");
        Enumeration enumeration = this.hashTable.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            stringBuffer.append("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
            stringBuffer.append("<ServiceKey, ServiceInfo> pair #" + n++ + "\n");
            stringBuffer.append("ServiceKey = " + string + "\n");
            stringBuffer.append(this.hashTable.get(string.toString()).toString() + "\n");
            stringBuffer.append("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
        }
        stringBuffer.append("=======================================\n");
        return stringBuffer.toString();
    }

    public synchronized int getServiceInfoCount() {
        return this.hashTable.size();
    }

    public synchronized void setServiceInfo(ServiceKey serviceKey, ServiceInfo serviceInfo) {
        if (!this.hashTable.containsKey(serviceKey.toString())) {
            this.hashTable.put(serviceKey.toString(), serviceInfo);
        }
    }

    public ServiceInfo getServiceInfo(ServiceKey serviceKey) {
        return (ServiceInfo)this.hashTable.get(serviceKey.toString());
    }

    public synchronized void addDeviceService(ServiceKey serviceKey, DeviceService deviceService) {
        ServiceInfo serviceInfo = null;
        if (this.hashTable.containsKey(serviceKey.toString())) {
            serviceInfo = (ServiceInfo)this.hashTable.get(serviceKey.toString());
        } else {
            serviceInfo = new ServiceInfo(serviceKey);
            this.hashTable.put(serviceKey.toString(), serviceInfo);
        }
        serviceInfo.addDeviceService(deviceService);
    }

    public synchronized void removeDeviceService(ServiceKey serviceKey, DeviceService deviceService) {
        if (!this.hashTable.containsKey(serviceKey.toString())) {
            return;
        }
        ((ServiceInfo)this.hashTable.get(serviceKey.toString())).removeDeviceService(deviceService);
    }

    public synchronized boolean containsDeviceService(ServiceKey serviceKey, DeviceService deviceService) {
        if (!this.hashTable.containsKey(serviceKey.toString())) {
            return false;
        }
        return ((ServiceInfo)this.hashTable.get(serviceKey.toString())).containsDeviceService(deviceService);
    }

    public synchronized DeviceService getClaimedService(ServiceKey serviceKey) {
        if (!this.hashTable.containsKey(serviceKey.toString())) {
            return null;
        }
        return ((ServiceInfo)this.hashTable.get(serviceKey.toString())).getClaimedService();
    }

    public synchronized void setClaimedService(ServiceKey serviceKey, DeviceService deviceService) {
        if (!this.hashTable.containsKey(serviceKey.toString())) {
            return;
        }
        ServiceInfo serviceInfo = (ServiceInfo)this.hashTable.get(serviceKey.toString());
        serviceInfo.setClaimedService(deviceService);
    }
}

