/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.ibmprinter;

import com.ibm.jpos.services.DeviceServiceAbstraction;
import com.ibm.jpos.services.EventQueueManager;
import com.ibm.jpos.services.POSPrinterServiceState;
import com.ibm.jpos.services.ibmprinter.ClearedOutputId;
import com.ibm.jpos.services.ibmprinter.MicrPrinterState;
import com.ibm.jpos.services.ibmprinter.PrintData;
import com.ibm.jpos.services.ibmprinter.PrinterOutput;
import com.ibm.jpos.services.ibmprinter.RotateSidewaysModeEndFlag;
import com.ibm.jpos.services.ibmprinter.RotateSidewaysModeStartFlag;
import com.ibm.jpos.services.ibmprinter.TransactionModeEndFlag;
import com.ibm.jpos.services.ibmprinter.TransactionModeStartFlag;
import com.ibm.jpos.util.Semaphore;
import com.ibm.jpos.util.Tracer;
import com.ibm.poss.PosDef;
import com.ibm.poss.Printer;
import java.util.StringTokenizer;
import java.util.Vector;
import jpos.JposConst;
import jpos.JposException;
import jpos.POSPrinterConst;
import jpos.events.JposEvent;
import jpos.events.OutputCompleteEvent;

public class PrintDataVector
extends Vector
implements Runnable,
PosDef,
Printer,
POSPrinterConst,
JposConst {
    static ClearedOutputId clearedOutputId = new ClearedOutputId(-1);
    DeviceServiceAbstraction serviceAbstraction = null;
    EventQueueManager serviceEventQueueManager = null;
    MicrPrinterState serviceState = null;
    Thread vectorWatcher = null;
    int vectorStation = -1;
    boolean inTransactionMode = false;
    boolean inRotateSidewaysMode = false;
    PrinterOutput outputter = null;
    int sidewaysLineCount = 0;
    Semaphore rotateSidewaysComplete = new Semaphore(true);
    Semaphore transactionComplete = new Semaphore(true);
    private String className = "PrintDataVector";

    public PrintDataVector(int n, DeviceServiceAbstraction deviceServiceAbstraction, PrinterOutput printerOutput) throws JposException {
        Tracer.trace((int)4, (String)this.className, (String)("Constructor(" + n + ")"), (String)"Entry");
        this.vectorStation = n;
        this.serviceAbstraction = deviceServiceAbstraction;
        this.serviceState = (MicrPrinterState)((Object)deviceServiceAbstraction.getDeviceServiceState());
        this.serviceEventQueueManager = deviceServiceAbstraction.getEventQueueManager();
        PrintDataVector.clearedOutputId.id = -1;
        this.outputter = printerOutput;
        Tracer.trace((int)4, (String)this.className, (String)"Constructor()", (String)"Exit");
    }

    public synchronized void setTransactionMode(boolean bl) {
        Tracer.trace((int)4, (String)this.className, (String)("setTransactionMode(" + bl + ")"), (String)"Entry");
        this.inTransactionMode = bl;
        if (this.inTransactionMode) {
            super.addElement(new TransactionModeStartFlag());
            this.transactionComplete.reset();
        } else {
            super.addElement(new TransactionModeEndFlag());
            this.notify();
        }
        Tracer.trace((int)4, (String)this.className, (String)"setTransactionMode()", (String)"Exit");
    }

    public boolean getTransactionMode() {
        return this.inTransactionMode;
    }

    public synchronized void setRotateSidewaysMode(boolean bl) {
        Tracer.trace((int)4, (String)this.className, (String)("setRotateSidewaysMode(" + bl + ")"), (String)"Entry");
        this.inRotateSidewaysMode = bl;
        if (this.inRotateSidewaysMode) {
            super.addElement(new RotateSidewaysModeStartFlag());
            this.sidewaysLineCount = 0;
            this.rotateSidewaysComplete.reset();
        } else if (this.elementCount > 0 && !this.getTransactionMode()) {
            super.addElement(new RotateSidewaysModeEndFlag());
            this.notify();
        }
        Tracer.trace((int)4, (String)this.className, (String)"setRotateSidewaysMode()", (String)"Exit");
    }

    public boolean getRotateSidewaysMode() {
        return this.inRotateSidewaysMode;
    }

    private int sidewaysModeLocation() {
        int n = 0;
        while (n < this.elementCount) {
            if (this.elementAt(n) instanceof RotateSidewaysModeStartFlag) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    synchronized void add(PrintData printData) throws JposException {
        Object object;
        Tracer.trace((int)4, (String)this.className, (String)"add()", (String)"Entry");
        if (this.inRotateSidewaysMode) {
            object = (POSPrinterServiceState)this.serviceAbstraction.getDeviceServiceState();
            switch (this.vectorStation) {
                case 2: {
                    if (this.sidewaysLineCount < ((POSPrinterServiceState)object).getRecSidewaysMaxLines()) break;
                    throw new JposException(111);
                }
                case 4: {
                    if (this.sidewaysLineCount < ((POSPrinterServiceState)object).getSlpSidewaysMaxLines()) break;
                    throw new JposException(111);
                }
            }
            ++this.sidewaysLineCount;
        }
        if (this.inTransactionMode && printData.printMode == 16) {
            super.insertElementAt(printData, 0);
        } else if (this.vectorStation == 4 && this.inRotateSidewaysMode) {
            object = new StringTokenizer(printData.data1, "\n", true);
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string = ((StringTokenizer)object).nextToken();
                if (!string.equals("\n") && ((StringTokenizer)object).hasMoreTokens()) {
                    string = string + ((StringTokenizer)object).nextToken();
                }
                PrintData printData2 = new PrintData(printData);
                printData2.data1 = string;
                super.insertElementAt(printData2, this.sidewaysModeLocation() + 1);
            }
        } else {
            super.addElement(printData);
        }
        if (!this.inTransactionMode && !this.inRotateSidewaysMode || printData.printMode == 16) {
            this.notify();
        }
        Tracer.trace((int)4, (String)this.className, (String)"add()", (String)"Exit");
    }

    synchronized Object remove() {
        Tracer.trace((int)4, (String)this.className, (String)"remove()", (String)"Entry");
        while (this.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Object e = this.firstElement();
        this.removeElementAt(0);
        Tracer.trace((int)4, (String)this.className, (String)"remove()", (String)"Exit");
        return e;
    }

    public void start() {
        Tracer.trace((int)4, (String)this.className, (String)"start()", (String)"Entry");
        if (this.vectorWatcher == null) {
            this.vectorWatcher = new Thread(this);
            this.vectorWatcher.start();
            switch (this.vectorStation) {
                case 2: {
                    this.vectorWatcher.setName("RECEIPT    ");
                    break;
                }
                case 1: {
                    this.vectorWatcher.setName("JOURNAL    ");
                    break;
                }
                case 4: {
                    this.vectorWatcher.setName("SLIP       ");
                    break;
                }
                default: {
                    this.vectorWatcher.setName("DISTRIBUTOR");
                }
            }
        }
        Tracer.trace((int)4, (String)this.className, (String)"start()", (String)"Exit");
    }

    public void run() {
        PrintData printData = null;
        Tracer.trace((int)4, (String)this.className, (String)"run()", (String)"Entry");
        PrintData printData2 = null;
        Object object = null;
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n3 = 0;
        while (true) {
            ClearedOutputId clearedOutputId;
            if ((object = this.remove()) instanceof PrintData) {
                n2 = 0;
                printData2 = (PrintData)object;
                if (this.serviceState.getAsyncMode()) {
                    clearedOutputId = PrintDataVector.clearedOutputId;
                    synchronized (clearedOutputId) {
                        if (printData2.outputID == PrintDataVector.clearedOutputId.id) {
                            n2 = 12;
                        } else {
                            while ((n2 = this.outputter.asyncModeErrorCheck(this.vectorStation)) == 11) {
                            }
                        }
                        if (n2 == 12) {
                            PrintDataVector.clearedOutputId.id = printData2.outputID;
                            n3 = 0;
                            this.sidewaysLineCount = 0;
                            bl = false;
                            bl2 = false;
                            printData = null;
                        }
                    }
                }
                if (n2 != 12) {
                    try {
                        if (printData2.printMode == 16) {
                            this.outputter.printLine(this.vectorStation, printData2);
                        } else if (bl) {
                            if (printData == null) {
                                printData = printData2;
                            } else if (printData.data1.length() + printData2.data1.length() > 3000) {
                                this.outputter.printLine(this.vectorStation, printData);
                                printData.data1 = printData2.data1;
                            } else {
                                printData.data1 = printData.data1 + printData2.data1;
                            }
                        } else {
                            this.outputter.printLine(this.vectorStation, printData2);
                        }
                        n = printData2.outputID;
                    }
                    catch (JposException jposException) {
                        printData = null;
                        Tracer.trace((int)4, (String)this.className, (String)"run()", (String)(this.vectorWatcher.getName() + ": .printLine() call exception = " + jposException.getErrorCode() + ", " + jposException.getErrorCodeExtended()));
                    }
                    if (bl) {
                        ++n3;
                    }
                    if (this.serviceState.getAsyncMode() && !printData2.specialMode && !bl && printData2.rotate != 258) {
                        try {
                            clearedOutputId = new OutputCompleteEvent(this.serviceAbstraction.getEventSource(), printData2.outputID);
                            this.serviceEventQueueManager.postEvent((JposEvent)clearedOutputId);
                        }
                        catch (JposException jposException) {}
                    }
                }
            } else if (object instanceof TransactionModeEndFlag) {
                if (printData != null) {
                    try {
                        this.outputter.printLine(this.vectorStation, printData);
                    }
                    catch (JposException jposException) {
                        Tracer.trace((int)4, (String)this.className, (String)"run()", (String)(this.vectorWatcher.getName() + ": .printLine() call exception = " + jposException.getErrorCode() + ", " + jposException.getErrorCodeExtended()));
                    }
                    printData = null;
                }
                if (this.serviceState.getAsyncMode() && n3 > 0) {
                    try {
                        clearedOutputId = new OutputCompleteEvent(this.serviceAbstraction.getEventSource(), n);
                        this.serviceEventQueueManager.postEvent((JposEvent)clearedOutputId);
                    }
                    catch (JposException jposException) {
                        // empty catch block
                    }
                }
                this.transactionComplete.set();
                bl = false;
                printData = null;
            } else if (object instanceof TransactionModeStartFlag) {
                bl = true;
                n3 = 0;
            } else if (object instanceof RotateSidewaysModeEndFlag) {
                if (this.serviceState.getAsyncMode() && this.sidewaysLineCount > 0 && !this.getTransactionMode()) {
                    try {
                        clearedOutputId = new OutputCompleteEvent(this.serviceAbstraction.getEventSource(), n);
                        this.serviceEventQueueManager.postEvent((JposEvent)clearedOutputId);
                    }
                    catch (JposException jposException) {
                        // empty catch block
                    }
                }
                if (!this.getTransactionMode()) {
                    bl = false;
                    printData = null;
                }
                this.rotateSidewaysComplete.set();
                bl2 = false;
            } else if (object instanceof RotateSidewaysModeStartFlag) {
                bl2 = true;
            }
            if (!this.isEmpty()) continue;
            try {
                this.outputter.setIdle();
                continue;
            }
            catch (JposException jposException) {
                Tracer.trace((int)4, (String)this.className, (String)"run()", (String)(this.vectorWatcher.getName() + ": Error setting idle."));
                continue;
            }
            break;
        }
    }

    public void stop() {
        if (this.vectorWatcher != null) {
            this.vectorWatcher.stop();
            this.vectorWatcher = null;
        }
    }
}

