/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.ibmprinter;

import com.ibm.jpos.services.ibmprinter.TextAttributes;
import com.ibm.jpos.util.ByteBuffer;
import java.util.Stack;

class TextSegment {
    static final int ALIGN_LEFT = -1;
    static final int ALIGN_CENTER = -2;
    static final int ALIGN_RIGHT = -3;
    private static Stack stack = new Stack();
    private boolean flag = true;
    private int beginIndex = 0;
    private int cellsBuffered = 0;
    private int station = 2;
    private int alignment = -1;
    private int cellCount = 0;
    private TextAttributes beginAttributes = new TextAttributes();
    private TextAttributes endAttributes = new TextAttributes();
    private ByteBuffer byteBuffer = new ByteBuffer();
    private int beginAttributesLength = 0;

    private TextSegment() {
    }

    static TextSegment alloc(int n, int n2) {
        TextSegment textSegment = TextSegment.alloc();
        textSegment.setAlignment(n);
        textSegment.setStation(n2);
        return textSegment;
    }

    static TextSegment alloc(int n) {
        return TextSegment.alloc(n, 2);
    }

    static TextSegment alloc() {
        TextSegment textSegment = null;
        Stack stack = TextSegment.stack;
        synchronized (stack) {
            if (!TextSegment.stack.empty()) {
                textSegment = (TextSegment)TextSegment.stack.pop();
                textSegment.reinit();
            } else {
                textSegment = new TextSegment();
            }
        }
        return textSegment;
    }

    void free() {
        if (!stack.contains(this)) {
            stack.push(this);
        }
    }

    void reinit() {
        this.flag = true;
        this.beginIndex = 0;
        this.cellsBuffered = 0;
        this.station = 2;
        this.alignment = -1;
        this.cellCount = 0;
        this.beginAttributes.reinit();
        this.endAttributes.reinit();
        this.byteBuffer.setByteCount(0);
        this.beginAttributesLength = 0;
    }

    void reinit(int n) {
        this.reinit();
        this.setAlignment(n);
    }

    TextAttributes getBeginAttributes() {
        return this.beginAttributes;
    }

    int getBeginAttributesLength() {
        return this.beginAttributesLength;
    }

    void setBeginAttributesLength(int n) {
        this.beginAttributesLength = n;
    }

    TextAttributes getEndAttributes() {
        return this.endAttributes;
    }

    int getByteCount() {
        return this.byteBuffer.getByteCount();
    }

    int getCellCount() {
        return this.cellCount;
    }

    boolean getFlag() {
        return this.flag;
    }

    int getBeginIndex() {
        return this.beginIndex;
    }

    int getCellsBuffered() {
        return this.cellsBuffered;
    }

    int getStation() {
        return this.station;
    }

    int getAlignment() {
        return this.alignment;
    }

    void setFlag(boolean bl) {
        this.flag = bl;
    }

    void setBeginIndex(int n) {
        this.beginIndex = n;
    }

    void setCellsBuffered(int n) {
        this.cellsBuffered = n;
    }

    void setStation(int n) {
        this.station = n;
    }

    void setAlignment(int n) {
        this.alignment = n;
    }

    byte[] getBytes() {
        return this.byteBuffer.getBytes();
    }

    TextSegment append(byte by) {
        this.byteBuffer.append(by);
        return this;
    }

    TextSegment append(byte by, int n) {
        this.byteBuffer.append(by);
        this.cellCount += n;
        return this;
    }

    TextSegment append(byte[] byArray) {
        this.byteBuffer.append(byArray);
        return this;
    }

    TextSegment append(byte[] byArray, int n, int n2, int n3) {
        this.byteBuffer.append(byArray, n, n2);
        this.cellCount += n3;
        return this;
    }

    TextSegment append(TextSegment textSegment) {
        int n = 0;
        if (textSegment.getByteCount() > 0) {
            if (this.getByteCount() == 0) {
                this.getBeginAttributes().reinit(textSegment.getBeginAttributes());
                this.setBeginAttributesLength(textSegment.getBeginAttributesLength());
            } else if (textSegment.getBeginAttributes().attributesEqual(this.getEndAttributes())) {
                n = textSegment.getBeginAttributesLength();
            } else if (this.getBeginAttributesLength() == this.byteBuffer.getByteCount()) {
                this.setBeginAttributesLength(this.getBeginAttributesLength() + textSegment.getBeginAttributesLength());
            }
            this.append(textSegment.getBytes(), n, textSegment.getByteCount() - n, textSegment.getCellCount());
            this.getEndAttributes().reinit(textSegment.getEndAttributes());
        }
        return this;
    }

    void setNormal(byte[] byArray) {
        if (this.byteBuffer.getByteCount() == 0) {
            this.beginAttributes.setNormal();
            this.beginAttributesLength = byArray.length;
        } else if (this.beginAttributesLength == this.byteBuffer.getByteCount()) {
            this.beginAttributesLength += byArray.length;
            this.beginAttributes.setNormal();
        }
        this.byteBuffer.append(byArray);
        this.endAttributes.setNormal();
    }

    int getFontTypefaceSelection() {
        return this.endAttributes.getFontTypefaceSelection();
    }

    void setFontTypefaceSelection(int n, byte[] byArray) {
        if (this.beginAttributesLength == this.byteBuffer.getByteCount()) {
            this.beginAttributesLength += byArray.length;
            this.beginAttributes.setFontTypefaceSelection(n);
        }
        this.byteBuffer.append(byArray);
        this.endAttributes.setFontTypefaceSelection(n);
    }

    void setBold(byte[] byArray) {
        if (this.beginAttributesLength == this.byteBuffer.getByteCount()) {
            this.beginAttributesLength += byArray.length;
            this.beginAttributes.setBold();
        }
        this.byteBuffer.append(byArray);
        this.endAttributes.setBold();
    }

    void setUnderline(byte[] byArray) {
        if (this.beginAttributesLength == this.byteBuffer.getByteCount()) {
            this.beginAttributesLength += byArray.length;
            this.beginAttributes.setUnderline();
        }
        this.byteBuffer.append(byArray);
        this.endAttributes.setUnderline();
    }

    void setUnderline(int n, byte[] byArray) {
        if (this.beginAttributesLength == this.byteBuffer.getByteCount()) {
            this.beginAttributesLength += byArray.length;
            this.beginAttributes.setUnderline(n);
        }
        this.byteBuffer.append(byArray);
        this.endAttributes.setUnderline(n);
    }

    void setItalic(byte[] byArray) {
        if (this.beginAttributesLength == this.byteBuffer.getByteCount()) {
            this.beginAttributesLength += byArray.length;
            this.beginAttributes.setItalic();
        }
        this.byteBuffer.append(byArray);
        this.endAttributes.setItalic();
    }

    void setAlternateColor(byte[] byArray) {
        if (this.beginAttributesLength == this.byteBuffer.getByteCount()) {
            this.beginAttributesLength += byArray.length;
            this.beginAttributes.setAlternateColor();
        }
        this.byteBuffer.append(byArray);
        this.endAttributes.setAlternateColor();
    }

    void setReverseVideo(byte[] byArray) {
        if (this.beginAttributesLength == this.byteBuffer.getByteCount()) {
            this.beginAttributesLength += byArray.length;
            this.beginAttributes.setReverseVideo();
        }
        this.byteBuffer.append(byArray);
        this.endAttributes.setReverseVideo();
    }

    void setShading(byte[] byArray) {
        if (this.beginAttributesLength == this.byteBuffer.getByteCount()) {
            this.beginAttributesLength += byArray.length;
            this.beginAttributes.setShading();
        }
        this.byteBuffer.append(byArray);
        this.endAttributes.setShading();
    }

    void setShading(int n, byte[] byArray) {
        if (this.beginAttributesLength == this.byteBuffer.getByteCount()) {
            this.beginAttributesLength += byArray.length;
            this.beginAttributes.setShading(n);
        }
        this.byteBuffer.append(byArray);
        this.endAttributes.setShading(n);
    }

    void setSingleWideSingleHigh(byte[] byArray) {
        if (this.beginAttributesLength == this.byteBuffer.getByteCount()) {
            this.beginAttributesLength += byArray.length;
            this.beginAttributes.setSingleWideSingleHigh();
        }
        this.byteBuffer.append(byArray);
        this.endAttributes.setSingleWideSingleHigh();
    }

    boolean isDoubleWide() {
        return this.endAttributes.isDoubleWide();
    }

    void setDoubleWide(byte[] byArray) {
        if (this.beginAttributesLength == this.byteBuffer.getByteCount()) {
            this.beginAttributesLength += byArray.length;
            this.beginAttributes.setDoubleWide();
        }
        this.byteBuffer.append(byArray);
        this.endAttributes.setDoubleWide();
    }

    void setDoubleHigh(byte[] byArray) {
        if (this.beginAttributesLength == this.byteBuffer.getByteCount()) {
            this.beginAttributesLength += byArray.length;
            this.beginAttributes.setDoubleHigh();
        }
        this.byteBuffer.append(byArray);
        this.endAttributes.setDoubleHigh();
    }

    boolean isDoubleWideDoubleHigh() {
        return this.endAttributes.isDoubleWideDoubleHigh();
    }

    void setDoubleWideDoubleHigh(byte[] byArray) {
        if (this.beginAttributesLength == this.byteBuffer.getByteCount()) {
            this.beginAttributesLength += byArray.length;
            this.beginAttributes.setDoubleWideDoubleHigh();
        }
        this.byteBuffer.append(byArray);
        this.endAttributes.setDoubleWideDoubleHigh();
    }

    void setHorizontalScale(int n, byte[] byArray) {
        if (this.beginAttributesLength == this.byteBuffer.getByteCount()) {
            this.beginAttributesLength += byArray.length;
            this.beginAttributes.setHorizontalScale(n);
        }
        this.byteBuffer.append(byArray);
        this.endAttributes.setHorizontalScale(n);
    }

    int getHorizontalScale() {
        return this.endAttributes.getHorizontalScale();
    }

    void setVerticalScale(int n, byte[] byArray) {
        if (this.beginAttributesLength == this.byteBuffer.getByteCount()) {
            this.beginAttributesLength += byArray.length;
            this.beginAttributes.setVerticalScale(n);
        }
        this.byteBuffer.append(byArray);
        this.endAttributes.setVerticalScale(n);
    }

    int getVerticalScale() {
        return this.endAttributes.getVerticalScale();
    }

    protected void finalize() {
        this.free();
    }
}

