/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.poss;

import com.ibm.jpos.services.DeviceServiceAbstraction;
import com.ibm.jpos.services.KeylockServiceImp;
import com.ibm.jpos.services.KeylockServiceState;
import com.ibm.jpos.services.ServiceInstanceImp;
import com.ibm.jpos.services.poss.POSSDeviceServiceImp;
import com.ibm.jpos.services.poss.POSSImpFactory;
import com.ibm.jpos.util.JposEntryInfo;
import com.ibm.jpos.util.Timer;
import com.ibm.jpos.util.Timerable;
import com.ibm.poss.PosArg;
import com.ibm.poss.PosException;
import com.ibm.poss.PosmKbdStatusChangeListener;
import java.util.Hashtable;
import jpos.JposException;
import jpos.events.JposEvent;
import jpos.events.StatusUpdateEvent;
import jpos.services.EventCallbacks;

public abstract class POSSKeylockServiceImp
extends POSSDeviceServiceImp
implements KeylockServiceImp {
    private Object posmKbdStatusChangeLock = new Object();
    private boolean timerExpired = false;
    private Timer timer = null;
    private Hashtable keylockMapping = new Hashtable();
    public static final int POSSKEYLOCK_CLAIM_TIMEOUT = 250;
    public static final int DEFAULT_WAITFORKEYLOCKCHANGE_POLLING_WAIT = 200;
    public static final String LOCK_KP_LOCK_PROP_NAME = "jpos.KeylockConst.LOCK_KP_LOCK";
    public static final String LOCK_KP_NORM_PROP_NAME = "jpos.KeylockConst.LOCK_KP_NORM";
    public static final String LOCK_KP_SUPR_PROP_NAME = "jpos.KeylockConst.LOCK_KP_SUPR";

    protected POSSKeylockServiceImp(DeviceServiceAbstraction deviceServiceAbstraction) throws JposException {
        super(deviceServiceAbstraction);
        this.getPosDevice().setPosmKbdStatusChangeListener(new PosDeviceListener());
    }

    protected final String getPOSSDeviceClass() {
        return "PosKeyboard";
    }

    protected final boolean isCompositeDevice() {
        return true;
    }

    protected final boolean isShareableDevice() {
        return true;
    }

    public synchronized void deleteImp() throws JposException {
        super.deleteImp();
        this.getPosDevice().setPosmKbdStatusChangeListener(null);
    }

    public static ServiceInstanceImp createImp(DeviceServiceAbstraction deviceServiceAbstraction) throws JposException {
        return POSSImpFactory.createImp(deviceServiceAbstraction);
    }

    public void open(String string, EventCallbacks eventCallbacks) throws JposException {
        super.open(string, eventCallbacks);
        try {
            this.initKeylockMapping();
        }
        catch (JposException jposException) {
            this.initDefaultKeylockMapping();
        }
    }

    public void setDeviceEnabled(boolean bl) throws JposException {
        super.setDeviceEnabled(bl);
        if (bl) {
            this.initStatus();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void waitForKeylockChange(int n, int n2) throws JposException {
        KeylockServiceState keylockServiceState = (KeylockServiceState)this.getDeviceServiceState();
        int n3 = keylockServiceState.getKeyPosition();
        if (n2 == 0) {
            if (n != 0 && n != n3) throw new JposException(112);
            return;
        }
        if (n == n3) {
            return;
        }
        if (n2 == -1) {
            while (true) {
                Object object = this.posmKbdStatusChangeLock;
                synchronized (object) {
                    try {
                        this.posmKbdStatusChangeLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                try {
                    this.checkCurrentStatus();
                    if (!(n == 0 ? keylockServiceState.getKeyPosition() != n3 : keylockServiceState.getKeyPosition() == n)) continue;
                    return;
                }
                catch (JposException jposException) {
                    if (jposException.getErrorCode() == 108) throw jposException;
                    continue;
                }
                break;
            }
        }
        this.timerExpired = false;
        this.getTimer().setTime(n2);
        this.getTimer().start();
        while (!this.timerExpired) {
            block20: {
                try {
                    this.checkCurrentStatus();
                    if (n == 0) {
                        if (keylockServiceState.getKeyPosition() != n3) {
                            this.getTimer().reset();
                            return;
                        }
                    } else if (keylockServiceState.getKeyPosition() == n) {
                        this.getTimer().reset();
                        return;
                    }
                }
                catch (JposException jposException) {
                    if (jposException.getErrorCode() != 108) break block20;
                    throw jposException;
                }
            }
            try {
                Thread.currentThread();
                Thread.sleep(this.getDefaultWaitForKeylockChangePollingWait());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        throw new JposException(112);
    }

    void posmKbdStatusChange(short s, int n) {
        int n2 = this.convertToKeylockConst(n);
        KeylockServiceState keylockServiceState = (KeylockServiceState)this.getDeviceServiceState();
        if (keylockServiceState.getDeviceEnabled()) {
            try {
                keylockServiceState.setKeyPosition(n2);
            }
            catch (JposException jposException) {
                // empty catch block
            }
            this.fireStatusUpdateEvent(n2);
        }
        Object object = this.posmKbdStatusChangeLock;
        synchronized (object) {
            this.posmKbdStatusChangeLock.notify();
        }
    }

    private void fireStatusUpdateEvent(int n) {
        try {
            StatusUpdateEvent statusUpdateEvent = new StatusUpdateEvent(this.getDeviceServiceAbstraction().getEventSource(), n);
            this.getDeviceServiceAbstraction().getEventQueueManager().postEvent((JposEvent)statusUpdateEvent);
        }
        catch (JposException jposException) {
            // empty catch block
        }
    }

    protected Timer getTimer() {
        if (this.timer == null) {
            this.timer = new Timer(new Timerable(){

                public void timerExpired() {
                    POSSKeylockServiceImp.this.timerExpired = true;
                }
            });
        }
        return this.timer;
    }

    protected void initStatus() throws JposException {
        this.checkCurrentStatus();
    }

    protected void checkCurrentStatus() throws JposException {
        int n = 302;
        PosArg[] posArgArray = new PosArg[]{new PosArg("keyLock", -1)};
        try {
            this.getPosDevice().ioctl(n, posArgArray, posArgArray.length);
        }
        catch (PosException posException) {
            if (posException.getErrorCode() == 317) {
                throw new JposException(108, posException.getMessage(), (Exception)posException);
            }
            throw new JposException(111, posException.getMessage(), (Exception)posException);
        }
        int n2 = (Integer)posArgArray[0].getValue();
        KeylockServiceState keylockServiceState = (KeylockServiceState)this.getDeviceServiceState();
        keylockServiceState.setKeyPosition(this.convertToKeylockConst(n2));
    }

    protected int convertToKeylockConst(int n) {
        int n2 = 2;
        n2 = this.keylockMapping.containsKey(new Integer(n)) ? this.convertKeylockMappNameToKeyPos((String)this.keylockMapping.get(new Integer(n))) : (n == 3 || n == 4 ? n : 2);
        return n2;
    }

    protected int getDefaultWaitForKeylockChangePollingWait() {
        return 200;
    }

    protected void initDefaultKeylockMapping() {
        this.keylockMapping.clear();
        this.keylockMapping.put(new Integer(1), LOCK_KP_SUPR_PROP_NAME);
        this.keylockMapping.put(new Integer(2), LOCK_KP_NORM_PROP_NAME);
    }

    protected final int convertKeylockMappNameToKeyPos(String string) {
        int n = 2;
        if (string.equals(LOCK_KP_LOCK_PROP_NAME)) {
            n = 1;
        } else if (string.equals(LOCK_KP_NORM_PROP_NAME)) {
            n = 2;
        } else if (string.equals(LOCK_KP_SUPR_PROP_NAME)) {
            n = 3;
        }
        return n;
    }

    protected final void initKeylockMapping() throws JposException {
        this.keylockMapping.clear();
        this.lookForMappingFor(LOCK_KP_LOCK_PROP_NAME);
        this.lookForMappingFor(LOCK_KP_NORM_PROP_NAME);
        this.lookForMappingFor(LOCK_KP_SUPR_PROP_NAME);
        if (this.keylockMapping.size() == 0) {
            throw new JposException(106, "No Keylock mapping specified in the JposEntry");
        }
    }

    protected final void lookForMappingFor(String string) throws JposException {
        String string2;
        Object object;
        JposEntryInfo jposEntryInfo = this.getDeviceServiceAbstraction().getDeviceServiceState().getJposEntryInfo();
        if (jposEntryInfo.hasPropertyWithName(string) && (object = jposEntryInfo.getPropertyValue(string)) != null && (string2 = (String)object) != null) {
            Integer n = Integer.decode(string2);
            this.keylockMapping.put(n, string);
        }
    }

    protected final Hashtable getKeylockMapping() {
        return this.keylockMapping;
    }

    private class PosDeviceListener
    implements PosmKbdStatusChangeListener {
        private PosDeviceListener() {
        }

        public void posmKbdStatusChange(short s, int n) {
            POSSKeylockServiceImp.this.posmKbdStatusChange(s, n);
        }
    }
}

