/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.poss;

import com.ibm.jpos.services.DeviceServiceAbstraction;
import com.ibm.jpos.services.MSRParsedData;
import com.ibm.jpos.services.MSRServiceImp;
import com.ibm.jpos.services.MSRServiceState;
import com.ibm.jpos.services.poss.POSSDeviceServiceImp;
import com.ibm.jpos.services.poss.POSSMSRDataParser;
import com.ibm.jpos.util.JposEventContainer;
import com.ibm.jpos.util.Tracer;
import com.ibm.poss.Errno;
import com.ibm.poss.Msr;
import com.ibm.poss.PosDef;
import com.ibm.poss.PosDevice;
import com.ibm.poss.PosException;
import com.ibm.poss.PosMsrDataHdr;
import com.ibm.poss.PosmMsrDataAvailListener;
import java.io.ByteArrayInputStream;
import jpos.JposException;
import jpos.MSRConst;
import jpos.events.DataEvent;
import jpos.events.ErrorEvent;
import jpos.events.JposEvent;
import jpos.services.EventCallbacks;

public class POSSMSRServiceImp
extends POSSDeviceServiceImp
implements MSRServiceImp,
Errno,
PosDef,
Msr {
    private MSRServiceState serviceState = null;
    private Object eventSource = null;
    private PosDevice posDevice = null;
    private static final char TRACKTYPE_A = 'A';
    private static final char TRACKTYPE_B = 'B';
    private static final char TRACKTYPE_C = 'C';
    private static final int TRACKENCODING_4BIT = 4;
    private static final int TRACKENCODING_6BIT = 6;
    private static final int TRACKENCODING_7BIT = 7;
    private static final String className = "POSSMSRServiceImp";

    protected POSSMSRServiceImp(DeviceServiceAbstraction deviceServiceAbstraction) throws JposException {
        super(deviceServiceAbstraction);
        Tracer.trace((int)4, (String)className, (String)"POSSMSRServiceImp()", (String)"Entry");
        this.posDevice = this.getPosDevice();
        this.posDevice.setPosmMsrDataAvailListener(new PosDeviceListener());
        Tracer.trace((int)4, (String)className, (String)className, (String)"Exit");
    }

    public void setAutoDisable(boolean bl) throws JposException {
    }

    public void setDataEventEnabled(boolean bl) throws JposException {
    }

    public void setDecodeData(boolean bl) throws JposException {
    }

    public void setErrorReportingType(int n) throws JposException {
    }

    public void setParseDecodeData(boolean bl) throws JposException {
    }

    public void setTracksToRead(int n) throws JposException {
    }

    public void setTransmitSentinels(boolean bl) throws JposException {
        Tracer.trace((int)4, (String)className, (String)"setTransmitSentinels() : ", (String)"Entry");
        if (!bl) {
            this.serviceState.setTransmitSentinels(bl);
        } else if (this.serviceState.getCapTransmitSentinels()) {
            this.serviceState.setTransmitSentinels(bl);
        } else {
            Tracer.trace((int)4, (String)className, (String)"setTransmitSentinels() : ", (String)"setTransmitSentinels Error");
            throw new JposException(106);
        }
        Tracer.trace((int)4, (String)className, (String)"setTransmitSentinels() : ", (String)"Exit");
    }

    public void open(String string, EventCallbacks eventCallbacks) throws JposException {
        super.open(string, eventCallbacks);
        Tracer.trace((int)4, (String)className, (String)"open()", (String)"Entry");
        this.serviceState = (MSRServiceState)this.getDeviceServiceState();
        this.eventSource = eventCallbacks.getEventSource();
        Tracer.trace((int)4, (String)className, (String)"open()", (String)"Exit");
    }

    public synchronized void close() throws JposException {
        super.close();
        Tracer.trace((int)4, (String)className, (String)"close()", (String)"Entry");
        this.serviceState = null;
        this.eventSource = null;
        Tracer.trace((int)4, (String)className, (String)"close()", (String)"Exit");
    }

    public void clearInput() throws JposException {
    }

    public synchronized void deleteImp() throws JposException {
        super.deleteImp();
        this.posDevice.setPosmMsrDataAvailListener(null);
    }

    protected String getPOSSDeviceClass() {
        return "PosMsr";
    }

    protected final boolean isLockableDevice() {
        return true;
    }

    private class POSSMSREventContainer
    implements JposEventContainer,
    MSRConst,
    MSRParsedData {
        private char track1Type;
        private int track1Encoding;
        private int track2Encoding;
        private int track3Encoding;
        private POSSMSRDataParser msrDataParser;
        private JposEvent jposEvent;
        private int errorReportingType;
        private String accountNumber;
        private String expirationDate;
        private String firstName;
        private String middleInitial;
        private String serviceCode;
        private String suffix;
        private String surname;
        private String title;
        private byte[] track1Data;
        private byte[] track1DiscretionaryData;
        private byte[] track2Data;
        private byte[] track2DiscretionaryData;
        private byte[] track3Data;
        private byte[] trackJData;

        public void prepareToFire() {
            Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"prepareToFire()", (String)"Entry");
            if (!(this.jposEvent instanceof ErrorEvent) || this.errorReportingType != 0) {
                try {
                    POSSMSRServiceImp.this.serviceState.setAccountNumber(this.accountNumber);
                    POSSMSRServiceImp.this.serviceState.setExpirationDate(this.expirationDate);
                    POSSMSRServiceImp.this.serviceState.setFirstName(this.firstName);
                    POSSMSRServiceImp.this.serviceState.setMiddleInitial(this.middleInitial);
                    POSSMSRServiceImp.this.serviceState.setServiceCode(this.serviceCode);
                    POSSMSRServiceImp.this.serviceState.setSuffix(this.suffix);
                    POSSMSRServiceImp.this.serviceState.setSurname(this.surname);
                    POSSMSRServiceImp.this.serviceState.setTitle(this.title);
                    POSSMSRServiceImp.this.serviceState.setTrack1Data(this.track1Data);
                    POSSMSRServiceImp.this.serviceState.setTrack1DiscretionaryData(this.track1DiscretionaryData);
                    POSSMSRServiceImp.this.serviceState.setTrack2Data(this.track2Data);
                    POSSMSRServiceImp.this.serviceState.setTrack2DiscretionaryData(this.track2DiscretionaryData);
                    POSSMSRServiceImp.this.serviceState.setTrack3Data(this.track3Data);
                    POSSMSRServiceImp.this.serviceState.setTrack4Data(this.trackJData);
                }
                catch (Exception exception) {
                    Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"prepareToFire()", (String)"Caught Exception setting tracks");
                }
            }
            Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"prepareToFire()", (String)"Exit");
        }

        public void doneFiring() {
            Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"doneFiring()", (String)"Entry");
            if (this.jposEvent instanceof ErrorEvent) {
                Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"doneFiring()", (String)"ErrorEvent");
                switch (((ErrorEvent)this.jposEvent).getErrorResponse()) {
                    case 11: {
                        Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"doneFiring()", (String)"errorResponse = JPOS_ER_RETRY");
                        break;
                    }
                    case 13: {
                        Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"doneFiring()", (String)"errorResponse = JPOS_ER_CONTINUEINPUT");
                        if (((ErrorEvent)this.jposEvent).getErrorLocus() != 2) break;
                        try {
                            POSSMSRServiceImp.this.clearInput();
                            POSSMSRServiceImp.this.serviceState.setState(2);
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    case 12: {
                        Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"doneFiring()", (String)"errorResponse = JPOS_ER_CLEAR");
                        try {
                            POSSMSRServiceImp.this.serviceState.setState(2);
                            POSSMSRServiceImp.this.clearInput();
                            break;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"doneFiring()", (String)"Exit");
        }

        public JposEvent getJposEvent() {
            return this.jposEvent;
        }

        /*
         * Loose catch block
         */
        public POSSMSREventContainer(short n) {
            block114: {
                this.track1Type = (char)67;
                this.track1Encoding = 6;
                this.track2Encoding = 4;
                this.track3Encoding = 4;
                this.msrDataParser = null;
                this.jposEvent = null;
                this.errorReportingType = 0;
                this.accountNumber = "";
                this.expirationDate = "";
                this.firstName = "";
                this.middleInitial = "";
                this.serviceCode = "";
                this.suffix = "";
                this.surname = "";
                this.title = "";
                this.track1Data = new byte[0];
                this.track1DiscretionaryData = new byte[0];
                this.track2Data = new byte[0];
                this.track2DiscretionaryData = new byte[0];
                this.track3Data = new byte[0];
                this.trackJData = new byte[0];
                int n2 = 2;
                int n3 = 12;
                int n4 = 0;
                short s = 0;
                short s2 = 0;
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                try {
                    block110: {
                        int n8;
                        int n9;
                        Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"Entry");
                        this.errorReportingType = POSSMSRServiceImp.this.serviceState.getErrorReportingType();
                        if (this.errorReportingType == 1) {
                            Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"errorReportingType = MSR_ERT_TRACK");
                        } else {
                            Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"errorReportingType = MSR_ERT_CARD");
                        }
                        switch (POSSMSRServiceImp.this.serviceState.getTracksToRead()) {
                            case 1: {
                                n5 = 1;
                                break;
                            }
                            case 2: {
                                n5 = 2;
                                break;
                            }
                            case 4: {
                                n5 = 4;
                                break;
                            }
                            case 3: {
                                n5 = 3;
                                break;
                            }
                            case 5: {
                                n5 = 5;
                                break;
                            }
                            case 6: {
                                n5 = 6;
                                break;
                            }
                            case 7: {
                                n5 = 7;
                                break;
                            }
                            case 8: {
                                n5 = 8;
                                break;
                            }
                            case 9: {
                                n5 = 9;
                                break;
                            }
                            case 10: {
                                n5 = 10;
                                break;
                            }
                            case 12: {
                                n5 = 12;
                                break;
                            }
                            case 11: {
                                n5 = 11;
                                break;
                            }
                            case 13: {
                                n5 = 13;
                                break;
                            }
                            case 14: {
                                n5 = 14;
                                break;
                            }
                            case 15: {
                                n5 = 15;
                            }
                        }
                        byte[] byArray = new byte[n];
                        try {
                            POSSMSRServiceImp.this.posDevice.read(byArray);
                        }
                        catch (PosException posException) {
                            Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"PosException when reading Buffer");
                        }
                        PosMsrDataHdr posMsrDataHdr = null;
                        Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)("countAvail = " + n));
                        int n10 = 0;
                        while (n10 < n) {
                            posMsrDataHdr = new PosMsrDataHdr(byArray, n10);
                            n4 = posMsrDataHdr.getTrack();
                            s = posMsrDataHdr.getLength();
                            s2 = posMsrDataHdr.getFlags();
                            n6 |= n4;
                            Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)("The track is " + n4));
                            Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)("TrackLength is : " + s));
                            Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)("Track flags are : " + Integer.toHexString(s2)));
                            Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)("tracksRequested is : " + n5));
                            switch (n4) {
                                case 1: {
                                    Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"Track PosTRACK_1 found");
                                    break;
                                }
                                case 2: {
                                    Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"Track PosTRACK_2 found");
                                    break;
                                }
                                case 4: {
                                    Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"Track PosTRACK_3 found");
                                    break;
                                }
                                case 8: {
                                    Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"Track PosTRACK_J found");
                                }
                            }
                            if ((n4 & n5) != 0) {
                                Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"Tracks are equals");
                                if ((s2 & 1) == 0) {
                                    Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"No error on track");
                                    if (s > 0) {
                                        Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"trackLength is bigger than 0");
                                        switch (n4) {
                                            case 1: {
                                                this.track1Data = new byte[s];
                                                System.arraycopy(byArray, n10 + 8, this.track1Data, 0, s);
                                                Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"Track1 copied");
                                                break;
                                            }
                                            case 2: {
                                                this.track2Data = new byte[s];
                                                System.arraycopy(byArray, n10 + 8, this.track2Data, 0, s);
                                                Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"Track2 copied");
                                                break;
                                            }
                                            case 4: {
                                                this.track3Data = new byte[s];
                                                System.arraycopy(byArray, n10 + 8, this.track3Data, 0, s);
                                                Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"Track3 copied");
                                                break;
                                            }
                                            case 8: {
                                                this.trackJData = new byte[s];
                                                System.arraycopy(byArray, n10 + 8, this.trackJData, 0, s);
                                                Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"Track4 copied");
                                            }
                                        }
                                    } else {
                                        Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"trackLength was smaller than 0");
                                    }
                                } else {
                                    Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"Error on requested track");
                                    switch (n4) {
                                        case 1: {
                                            n7 |= 0x6F;
                                            break;
                                        }
                                        case 2: {
                                            n7 |= 0x6F00;
                                            break;
                                        }
                                        case 4: {
                                            n7 |= 0x6F0000;
                                            break;
                                        }
                                        case 8: {
                                            n7 |= 0x6F000000;
                                        }
                                    }
                                }
                                Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"Track processed");
                            } else {
                                Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"Found tracks and tracksRequested were not equals");
                            }
                            n10 += 8 + s;
                        }
                        if (n7 != 0) {
                            if (this.errorReportingType == 0) {
                                this.jposEvent = new ErrorEvent(POSSMSRServiceImp.this.eventSource, 111, 0, 2, 12);
                                Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)("Error Event created for errors on track - Card level, id = " + this.jposEvent.getSequenceNumber()));
                                if (this.track1Data.length != 0) {
                                    this.track1Data = new byte[0];
                                }
                                if (this.track2Data.length != 0) {
                                    this.track2Data = new byte[0];
                                }
                                if (this.track3Data.length != 0) {
                                    this.track3Data = new byte[0];
                                }
                                if (this.trackJData.length != 0) {
                                    this.trackJData = new byte[0];
                                }
                            } else {
                                this.jposEvent = new ErrorEvent(POSSMSRServiceImp.this.eventSource, 114, n7, 2, 12);
                                Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)("Error Event created for errors on track - Track level, id = " + this.jposEvent.getSequenceNumber()));
                            }
                        }
                        Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)("jposEvent = " + this.jposEvent));
                        Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)("Track 1 length = " + this.track1Data.length));
                        Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)("Track 2 length = " + this.track2Data.length));
                        Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)("Track 3 length = " + this.track3Data.length));
                        Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)("Track J length = " + this.trackJData.length));
                        if (this.jposEvent == null && this.track1Data.length == 0 && this.track2Data.length == 0 && this.track3Data.length == 0 && this.trackJData.length == 0) {
                            Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"FAILURE, something was 0 or null");
                            if (this.errorReportingType != 0 && this.errorReportingType != 1) {
                                Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"Error with tracks and no data exists");
                                this.jposEvent = new ErrorEvent(POSSMSRServiceImp.this.eventSource, 111, 0, 2, 12);
                            }
                        }
                        if (this.track1Data.length > 0) {
                            Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"Identify format for track1");
                            block44 : switch (this.track1Data[0]) {
                                case 33: {
                                    Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"track1 is Type A");
                                    this.track1Type = (char)65;
                                    n9 = this.track1Data.length - 1;
                                    while (n9 >= 0) {
                                        if ((this.track1Data[n9] & 0xC0) != 0) {
                                            this.track1Type = (char)67;
                                            break block44;
                                        }
                                        --n9;
                                    }
                                    break;
                                }
                                case 34: {
                                    Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"Track1 is Type B");
                                    this.track1Type = (char)66;
                                    n8 = this.track1Data.length - 1;
                                    while (n8 >= 0) {
                                        if ((this.track1Data[n8] & 0xC0) != 0) {
                                            this.track1Type = (char)67;
                                            break block44;
                                        }
                                        --n8;
                                    }
                                    break;
                                }
                                default: {
                                    this.track1Type = (char)67;
                                }
                            }
                        }
                        Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"Track1 type was identified");
                        if (POSSMSRServiceImp.this.serviceState.getDecodeData()) {
                            int n11;
                            int n12;
                            Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)("Decoding track1Data with length : " + this.track1Data.length));
                            if (this.track1Data.length > 0) {
                                Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"Starting track1 decoding");
                                this.track1Encoding = 6;
                                n9 = 0;
                                n8 = this.track1Data.length;
                                while (n9 < n8) {
                                    if ((this.track1Data[n9] & 0xC0) != 0) {
                                        this.track1Encoding = 7;
                                        break;
                                    }
                                    ++n9;
                                }
                                if (this.track1Encoding == 6) {
                                    n12 = 0;
                                    n11 = this.track1Data.length;
                                    while (n12 < n11) {
                                        int n13 = n12++;
                                        this.track1Data[n13] = (byte)(this.track1Data[n13] + 32);
                                    }
                                }
                                Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"Track1 decoded");
                            }
                            this.track2Encoding = 4;
                            Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"Starting track2 decoding");
                            n9 = 0;
                            n8 = this.track2Data.length;
                            while (n9 < n8) {
                                if ((this.track2Data[n9] & 0xF0) != 0) {
                                    this.track2Encoding = 7;
                                    break;
                                }
                                ++n9;
                            }
                            if (this.track2Encoding == 4) {
                                n12 = 0;
                                n11 = this.track2Data.length;
                                while (n12 < n11) {
                                    int n14 = n12++;
                                    this.track2Data[n14] = (byte)(this.track2Data[n14] + 48);
                                }
                            }
                            Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"track2 decoded");
                            if (this.track3Data.length > 0) {
                                Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"Starting track3 decoding");
                                this.track3Encoding = 4;
                                n12 = 0;
                                n11 = this.track3Data.length;
                                while (n12 < n11) {
                                    if ((this.track3Data[n12] & 0xF0) != 0) {
                                        this.track3Encoding = 7;
                                        break;
                                    }
                                    ++n12;
                                }
                                if (this.track3Encoding == 4) {
                                    int n15 = 0;
                                    int n16 = this.track3Data.length;
                                    while (n15 < n16) {
                                        int n17 = n15++;
                                        this.track3Data[n17] = (byte)(this.track3Data[n17] + 48);
                                    }
                                }
                                Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"track3 decoded");
                            }
                        }
                        if (POSSMSRServiceImp.this.serviceState.getParseDecodeData()) {
                            if (this.track1Data.length > 0) {
                                this.msrDataParser = new POSSMSRDataParser(new ByteArrayInputStream(this.track1Data));
                                this.msrDataParser.start(1, this);
                            }
                            if (this.track2Data.length > 0) {
                                if (this.msrDataParser == null) {
                                    this.msrDataParser = new POSSMSRDataParser(new ByteArrayInputStream(this.track2Data));
                                } else {
                                    this.msrDataParser.ReInit(new ByteArrayInputStream(this.track2Data));
                                }
                                this.msrDataParser.start(2, this);
                            }
                        }
                        Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"Track data was parsed");
                        if (this.jposEvent != null) break block110;
                        n9 = 0;
                        Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"No errors detected");
                        Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)("tracks rec'd or'd with tracks requested = " + Integer.toHexString(n6 | n5)));
                        if ((n6 & n5) == 0) break block110;
                        n9 |= this.track1Data.length & 0xFF;
                        n9 |= this.track2Data.length << 8 & 0xFF00;
                        n9 |= this.track3Data.length << 16 & 0xFF0000;
                        this.jposEvent = new DataEvent(POSSMSRServiceImp.this.eventSource, n9 |= this.trackJData.length << 24 & 0xFF000000);
                        Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)("Data Event Created, id = " + this.jposEvent.getSequenceNumber()));
                    }
                    Object var23_22 = null;
                }
                catch (Throwable throwable) {
                    Object var23_24 = null;
                    Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"Clean system");
                    MSRServiceState mSRServiceState = POSSMSRServiceImp.this.serviceState;
                    synchronized (mSRServiceState) {
                        if (this.jposEvent == null || this.jposEvent instanceof ErrorEvent || !POSSMSRServiceImp.this.serviceState.getAutoDisable()) {
                            try {
                                POSSMSRServiceImp.this.posDevice.ioctl(306);
                                Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"Device was unlocked");
                            }
                            catch (PosException posException) {
                                Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"Problem when unlocking device");
                            }
                            POSSMSRServiceImp.this.serviceState.setDeviceEnabled(true);
                            Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"Device enabled");
                        } else {
                            try {
                                POSSMSRServiceImp.this.posDevice.ioctl(303);
                                Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"No problem at all finished");
                            }
                            catch (PosException posException) {
                                Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"Problems when locking device");
                            }
                            POSSMSRServiceImp.this.serviceState.setDeviceEnabled(false);
                            Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"Device disable");
                        }
                    }
                    Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"Exit");
                    throw throwable;
                }
                Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"Clean system");
                MSRServiceState mSRServiceState = POSSMSRServiceImp.this.serviceState;
                synchronized (mSRServiceState) {
                    if (this.jposEvent == null || this.jposEvent instanceof ErrorEvent || !POSSMSRServiceImp.this.serviceState.getAutoDisable()) {
                        try {
                            POSSMSRServiceImp.this.posDevice.ioctl(306);
                            Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"Device was unlocked");
                        }
                        catch (PosException posException) {
                            Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"Problem when unlocking device");
                        }
                        POSSMSRServiceImp.this.serviceState.setDeviceEnabled(true);
                        Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"Device enabled");
                    } else {
                        try {
                            POSSMSRServiceImp.this.posDevice.ioctl(303);
                            Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"No problem at all finished");
                        }
                        catch (PosException posException) {
                            Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"Problems when locking device");
                        }
                        POSSMSRServiceImp.this.serviceState.setDeviceEnabled(false);
                        Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"Device disable");
                    }
                }
                Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"Exit");
                {
                    break block114;
                    catch (Exception exception) {
                        Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"There was an error");
                        this.jposEvent = new ErrorEvent(POSSMSRServiceImp.this.eventSource, 111, 0, 2, 12);
                        Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)("Error Event Created in catch, id = " + this.jposEvent.getSequenceNumber()));
                        if (this.errorReportingType == 0) {
                            this.track1Data = new byte[0];
                            this.track2Data = new byte[0];
                            this.track3Data = new byte[0];
                            this.trackJData = new byte[0];
                            this.accountNumber = "";
                            this.expirationDate = "";
                            this.firstName = "";
                            this.middleInitial = "";
                            this.serviceCode = "";
                            this.suffix = "";
                            this.surname = "";
                            this.title = "";
                            this.track1Data = new byte[0];
                            this.track1DiscretionaryData = new byte[0];
                            this.track2Data = new byte[0];
                            this.track2DiscretionaryData = new byte[0];
                            this.track3Data = new byte[0];
                            this.trackJData = new byte[0];
                            Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"Fields were reset");
                        }
                        Object var23_23 = null;
                        Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"Clean system");
                        MSRServiceState mSRServiceState2 = POSSMSRServiceImp.this.serviceState;
                        synchronized (mSRServiceState2) {
                            if (this.jposEvent == null || this.jposEvent instanceof ErrorEvent || !POSSMSRServiceImp.this.serviceState.getAutoDisable()) {
                                try {
                                    POSSMSRServiceImp.this.posDevice.ioctl(306);
                                    Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"Device was unlocked");
                                }
                                catch (PosException posException) {
                                    Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"Problem when unlocking device");
                                }
                                POSSMSRServiceImp.this.serviceState.setDeviceEnabled(true);
                                Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"Device enabled");
                            } else {
                                try {
                                    POSSMSRServiceImp.this.posDevice.ioctl(303);
                                    Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"No problem at all finished");
                                }
                                catch (PosException posException) {
                                    Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"Problems when locking device");
                                }
                                POSSMSRServiceImp.this.serviceState.setDeviceEnabled(false);
                                Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"Device disable");
                            }
                        }
                        Tracer.trace((int)4, (String)"POSSMSREventContainer", (String)"POSSMSREventContainer()", (String)"Exit");
                    }
                }
            }
        }

        public String getAccountNumber() {
            return this.accountNumber;
        }

        public String getExpirationDate() {
            return this.expirationDate;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public String getMiddleInitial() {
            return this.middleInitial;
        }

        public String getServiceCode() {
            return this.serviceCode;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public String getSurname() {
            return this.surname;
        }

        public String getTitle() {
            return this.title;
        }

        public byte[] getTrack1DiscretionaryData() {
            return this.track1DiscretionaryData;
        }

        public byte[] getTrack2DiscretionaryData() {
            return this.track2DiscretionaryData;
        }

        public void setAccountNumber(String string) {
            this.accountNumber = string;
        }

        public void setExpirationDate(String string) {
            this.expirationDate = string;
        }

        public void setFirstName(String string) {
            this.firstName = string;
        }

        public void setMiddleInitial(String string) {
            this.middleInitial = string;
        }

        public void setServiceCode(String string) {
            this.serviceCode = string;
        }

        public void setSuffix(String string) {
            this.suffix = string;
        }

        public void setSurname(String string) {
            this.surname = string;
        }

        public void setTitle(String string) {
            this.title = string;
        }

        public void setTrack1DiscretionaryData(byte[] byArray) {
            this.track1DiscretionaryData = byArray;
        }

        public void setTrack2DiscretionaryData(byte[] byArray) {
            this.track2DiscretionaryData = byArray;
        }
    }

    private class PosDeviceListener
    implements PosmMsrDataAvailListener {
        private PosDeviceListener() {
        }

        public void posmMsrDataAvail(short s) {
            Tracer.trace((int)4, (String)"PosDeviceListener", (String)"posmMSRDataAvail()", (String)"Entry");
            if (POSSMSRServiceImp.this.serviceState.getDeviceEnabled()) {
                try {
                    POSSMSRServiceImp.this.getEventQueueManager().postEvent((JposEventContainer)new POSSMSREventContainer(s));
                }
                catch (Exception exception) {
                    Tracer.trace((int)4, (String)"PosDeviceListener", (String)"posmMSRDataAvail()", (String)"Caught Exception on EventQueueManager");
                    try {
                        Tracer.trace((int)4, (String)"PosDeviceListener", (String)"PosDeviceListener()", (String)"Unlock device");
                        POSSMSRServiceImp.this.posDevice.ioctl(306);
                    }
                    catch (PosException posException) {
                        Tracer.trace((int)4, (String)"PosDeviceListener", (String)"PosDeviceListener()", (String)"Error when unlocking device");
                    }
                }
            } else {
                byte[] byArray = new byte[s];
                try {
                    POSSMSRServiceImp.this.posDevice.read(byArray);
                }
                catch (PosException posException) {
                    Tracer.trace((int)4, (String)"PosDeviceListener", (String)"PosDeviceListener()", (String)"Error when reading buffer");
                }
            }
            Tracer.trace((int)4, (String)"PosDeviceListener", (String)"PosDeviceListener()", (String)"Exit");
        }
    }
}

