/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services.poss;

import com.ibm.jpos.services.POSPrinterServiceState;
import com.ibm.jpos.services.ibmprinter.PrintBitmapUtil;
import com.ibm.jpos.services.ibmprinter.PrintDataCompiler;
import com.ibm.jpos.services.ibmprinter.PrintDataParseException;
import com.ibm.jpos.services.ibmprinter.PrinterFont;
import com.ibm.jpos.services.ibmprinter.SetBitmapData;
import java.util.Enumeration;
import java.util.Vector;
import jpos.JposException;
import jpos.POSPrinterConst;

abstract class POSSPrintDataCompiler
extends PrintDataCompiler
implements POSPrinterConst {
    private PrintBitmapUtil bitmapUtil = null;
    private PrinterFont[] printerFonts = null;
    private PrinterFont printerFont = null;
    private boolean inverted = false;
    private Vector setBitmapDataVector = new Vector();
    protected int currentHorizontalScale = 1;
    protected int currentVerticalScale = 1;

    POSSPrintDataCompiler(POSPrinterServiceState pOSPrinterServiceState) throws JposException {
        super(pOSPrinterServiceState);
    }

    public void validate(int n, String string, int n2, PrintBitmapUtil printBitmapUtil, PrinterFont[] printerFontArray) throws JposException {
        this.bitmapUtil = printBitmapUtil;
        this.printerFonts = printerFontArray;
        super.validate(n, string, n2);
    }

    public byte[] compile(int n, String string, int n2, PrintBitmapUtil printBitmapUtil, PrinterFont[] printerFontArray) throws JposException {
        this.bitmapUtil = printBitmapUtil;
        this.printerFonts = printerFontArray;
        return super.compile(n, string, n2);
    }

    protected boolean isInverted() {
        return this.inverted;
    }

    protected void setInverted(boolean bl) {
        this.inverted = bl;
    }

    protected PrintBitmapUtil getPrintBitmapUtil() {
        return this.bitmapUtil;
    }

    protected PrinterFont[] getPrinterFonts() {
        return this.printerFonts;
    }

    public abstract PrinterFont getSelectedPrinterFont();

    protected byte[] getNewlineBytes() {
        return new byte[]{13, 10};
    }

    public void updateSetBitmapData(SetBitmapData setBitmapData) {
        int n = setBitmapData.getStation();
        int n2 = setBitmapData.getBitmapNumber();
        Vector vector = this.setBitmapDataVector;
        synchronized (vector) {
            SetBitmapData setBitmapData2 = this.getSetBitmapData(n, n2);
            if (setBitmapData2 != null) {
                this.setBitmapDataVector.removeElement(setBitmapData2);
            }
            if (setBitmapData.getFileName().length() > 0) {
                this.setBitmapDataVector.addElement(setBitmapData);
            }
        }
    }

    public SetBitmapData getSetBitmapData(int n, int n2) {
        Vector vector = this.setBitmapDataVector;
        synchronized (vector) {
            Enumeration enumeration = this.setBitmapDataVector.elements();
            while (enumeration.hasMoreElements()) {
                SetBitmapData setBitmapData = (SetBitmapData)enumeration.nextElement();
                if (setBitmapData.getStation() != n || setBitmapData.getBitmapNumber() != n2) continue;
                SetBitmapData setBitmapData2 = setBitmapData;
                return setBitmapData2;
            }
        }
        return null;
    }

    protected byte[] getDeviceEscapeSequenceBytes(String string, int n) throws PrintDataParseException, JposException {
        int n2;
        int n3;
        block33: {
            String string2 = new String("Illegal device escape sequence at index " + n);
            n3 = n;
            try {
                block1 : switch (string.charAt(n3++)) {
                    case '\u001b': {
                        switch (string.charAt(n3++)) {
                            case '\u000e': 
                            case '\u0017': 
                            case '5': 
                            case ':': 
                            case ';': 
                            case '<': 
                            case '>': 
                            case 'E': 
                            case 'F': 
                            case 'G': 
                            case 'L': 
                            case 'M': 
                            case 'O': 
                            case 'P': 
                            case 'Q': 
                            case 'R': 
                            case 't': {
                                break block1;
                            }
                            case '!': {
                                n2 = string.charAt(n3++);
                                if (!(n2 >= 1 && n2 <= 10 || n2 >= 129 && n2 <= 138)) {
                                    if (this.isValidating()) {
                                        throw new JposException(111, string2);
                                    }
                                    throw new PrintDataParseException();
                                }
                                break block33;
                            }
                            case '\"': {
                                n2 = string.charAt(n3++);
                                if (n2 < 1 || n2 > 2) {
                                    if (this.isValidating()) {
                                        throw new JposException(111, string2);
                                    }
                                    throw new PrintDataParseException();
                                }
                                break block33;
                            }
                            case '#': {
                                n2 = string.charAt(n3++);
                                break block1;
                            }
                            case '$': {
                                n2 = string.charAt(n3++);
                                if (n2 != 0 && (n2 <= 7 || n2 >= 33)) {
                                    if (this.isValidating()) {
                                        throw new JposException(111, string2);
                                    }
                                    throw new PrintDataParseException();
                                }
                                break block33;
                            }
                            case '?': {
                                n2 = string.charAt(n3++);
                                if (n2 < 1 || n2 > 2) {
                                    if (this.isValidating()) {
                                        throw new JposException(111, string2);
                                    }
                                    throw new PrintDataParseException();
                                }
                                break block33;
                            }
                            case 'k': {
                                n2 = string.charAt(n3++);
                                if (n2 < 1 || n2 > 8 || (n2 = (int)string.charAt(n3++)) < 2 || n2 > 4 || (n2 = (int)string.charAt(n3++)) < 1 || n2 > 255 || (n2 = (int)string.charAt(n3++)) < 0 || n2 > 3 || (n2 = (int)string.charAt(n3++)) < 0 || n2 > 1) {
                                    if (this.isValidating()) {
                                        throw new JposException(111, string2);
                                    }
                                    throw new PrintDataParseException();
                                }
                                break block33;
                            }
                            case 'p': {
                                n2 = string.charAt(n3++);
                                if (n2 < 1 || n2 > 72 || (n2 = (int)string.charAt(n3++)) < 0 || n2 > 40) {
                                    if (this.isValidating()) {
                                        throw new JposException(111, string2);
                                    }
                                    throw new PrintDataParseException();
                                }
                                break block33;
                            }
                            case 'q': {
                                n2 = string.charAt(n3++);
                                if (n2 >= 0 && n2 <= 25) break block33;
                            }
                            default: {
                                if (this.isValidating()) {
                                    throw new JposException(111, string2);
                                }
                                throw new PrintDataParseException();
                            }
                        }
                    }
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                if (this.isValidating()) {
                    throw new JposException(111, string2);
                }
                throw new PrintDataParseException();
            }
        }
        byte[] byArray = new byte[n3 - n];
        n2 = n;
        while (n2 < n3) {
            byArray[n2 - n] = (byte)string.charAt(n2);
            ++n2;
        }
        return byArray;
    }

    protected byte[] getPaperCutBytes(int n) throws PrintDataParseException, JposException {
        switch (n) {
            case 100: {
                return new byte[]{27, 80};
            }
            case 0: {
                return new byte[0];
            }
        }
        if (this.isValidating()) {
            throw new JposException(106);
        }
        return new byte[]{27, 80};
    }

    protected byte[] getFeedAndPaperCutBytes(int n) throws PrintDataParseException, JposException {
        int n2 = this.getServiceState().getRecLinesToPaperCut();
        byte[] byArray = this.getNewlineBytes();
        int n3 = byArray.length;
        byte[] byArray2 = new byte[n2 * n3 + (n == 0 ? 0 : 2)];
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n3) {
                byArray2[n4 * n3 + n5] = byArray[n5];
                ++n5;
            }
            ++n4;
        }
        switch (n) {
            case 100: {
                byArray2[n2 * n3] = 27;
                byArray2[n2 * n3 + 1] = 80;
                break;
            }
            case 0: {
                break;
            }
            default: {
                if (this.isValidating()) {
                    throw new JposException(106);
                }
                byArray2[n2 * n3] = 27;
                byArray2[n2 * n3 + 1] = 80;
            }
        }
        return byArray2;
    }

    protected byte[] getFeedPaperCutAndStampBytes(int n) throws PrintDataParseException, JposException {
        return new byte[]{27, 79, 27, 81};
    }

    protected byte[] getBoldBytes() throws PrintDataParseException, JposException {
        return new byte[]{27, 69};
    }

    protected byte[] getUnderlineBytes() throws PrintDataParseException, JposException {
        if (this.isInverted()) {
            return new byte[]{27, 33, 4};
        }
        return new byte[]{27, 33, 3};
    }

    protected byte[] getUnderlineBytes(int n) throws PrintDataParseException, JposException {
        switch (n) {
            case 0: {
                return new byte[]{27, 33, -125, 27, 33, -124};
            }
            case 1: {
                return this.getUnderlineBytes();
            }
        }
        if (this.isValidating()) {
            throw new JposException(106, "Illegal underline thickness");
        }
        if (n < 0) {
            return new byte[]{27, 33, -125, 27, 33, -124};
        }
        return this.getUnderlineBytes();
    }

    protected byte[] getReverseVideoBytes() throws PrintDataParseException, JposException {
        return new byte[]{27, 33, 5};
    }

    protected byte[] getShadingBytes() throws PrintDataParseException, JposException {
        return new byte[]{27, 33, 10};
    }

    protected byte[] getShadingBytes(int n) throws PrintDataParseException, JposException {
        byte[] byArray = new byte[]{};
        if (this.isValidating()) {
            if (n != 0 && n != 50 && n != 100) {
                throw new JposException(106);
            }
        } else {
            byArray = n == 0 ? new byte[]{27, 33, -120, 27, 33, -118} : (n < 50 ? new byte[]{27, 33, 10} : new byte[]{27, 33, 8});
        }
        return byArray;
    }

    protected byte[] getSingleWideSingleHighBytes() throws PrintDataParseException, JposException {
        this.currentHorizontalScale = 1;
        this.currentVerticalScale = 1;
        return new byte[]{27, 33, -126, 27, 33, -127};
    }

    protected byte[] getDoubleWideBytes() throws PrintDataParseException, JposException {
        this.currentHorizontalScale = 1;
        this.currentVerticalScale = 1;
        return new byte[]{27, 33, 2};
    }

    protected byte[] getDoubleHighBytes() throws PrintDataParseException, JposException {
        this.currentHorizontalScale = 1;
        this.currentVerticalScale = 1;
        return new byte[]{27, 33, 1};
    }

    protected byte[] getDoubleWideDoubleHighBytes() throws PrintDataParseException, JposException {
        this.currentHorizontalScale = 1;
        this.currentVerticalScale = 1;
        return new byte[]{27, 33, 2, 27, 33, 1};
    }
}

