/*
 * Decompiled with CFR 0.152.
 */
package jpos.config;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import jpos.JposTestCase;
import jpos.config.AbstractRegPopulatorTestCase;
import jpos.config.CompositeRegPopulator;
import jpos.config.DefaultCompositeRegPopulator;
import jpos.config.JposEntry;
import jpos.config.JposRegPopulator;
import jpos.config.simple.SimpleRegPopulator;
import jpos.loader.JposServiceLoader;
import jpos.test.JUnitUtility;
import junit.framework.Assert;

public class CompositeRegPopulatorTestCase
extends AbstractRegPopulatorTestCase {
    private CompositeRegPopulator compositePopulator = null;
    private JposRegPopulator[] populators = null;
    private List cfgPop0EntryList = null;
    private List cfgPop1EntryList = null;
    private List xmlPop0EntryList = null;
    private List xmlPop1EntryList = null;
    private List[] popEntryLists = null;
    public static final int MAX_POPULATORS = 4;
    public static final String CFG_REG_POPULATOR_FILE_0 = JposTestCase.TEST_DATA_PATH + "populator0.cfg";
    public static final String CFG_REG_POPULATOR_FILE_1 = JposTestCase.TEST_DATA_PATH + "populator1.cfg";
    public static final String XML_REG_POPULATOR_FILE_0 = JposTestCase.TEST_DATA_PATH + "populator0.xml";
    public static final String XML_REG_POPULATOR_FILE_1 = JposTestCase.TEST_DATA_PATH + "populator1.xml";
    public static final int CFG_REG_POPULATOR_0_ENTRIES_SIZE = 10;
    public static final int CFG_REG_POPULATOR_1_ENTRIES_SIZE = 20;
    public static final int XML_REG_POPULATOR_0_ENTRIES_SIZE = 5;
    public static final int XML_REG_POPULATOR_1_ENTRIES_SIZE = 15;
    public static final String[] POPULATOR_IDS = new String[]{"jpos.config.populator.class.0", "jpos.config.populator.class.1", "jpos.config.populator.class.2", "jpos.config.populator.class.3"};
    public static final String[] POPULATOR_FILES = new String[]{CFG_REG_POPULATOR_FILE_0, XML_REG_POPULATOR_FILE_0, CFG_REG_POPULATOR_FILE_1, XML_REG_POPULATOR_FILE_1};

    public CompositeRegPopulatorTestCase(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        this.createCompositePropFile();
        this.createEntriesFiles();
        this.compositePopulator = new DefaultCompositeRegPopulator();
    }

    protected void tearDown() throws Exception {
        this.deleteCompositePropFile();
        this.deleteEntriesFiles();
        this.compositePopulator = null;
    }

    private void deleteEntriesFiles() throws Exception {
        new File(CFG_REG_POPULATOR_FILE_0).delete();
        new File(CFG_REG_POPULATOR_FILE_1).delete();
        new File(XML_REG_POPULATOR_FILE_0).delete();
        new File(XML_REG_POPULATOR_FILE_1).delete();
    }

    private void createEntriesFiles() throws Exception {
        this.cfgPop0EntryList = new ArrayList();
        this.cfgPop0EntryList.clear();
        int n = 0;
        while (n < 10) {
            JposEntry jposEntry = this.createDefaultJposEntry(CFG_REG_POPULATOR_FILE_0 + "_" + n);
            this.cfgPop0EntryList.add(jposEntry);
            ++n;
        }
        this.createSerializedEntriesFile(this.cfgPop0EntryList.iterator(), CFG_REG_POPULATOR_FILE_0);
        Assert.assertTrue((String)("File " + CFG_REG_POPULATOR_FILE_0 + " was not created"), (boolean)new File(CFG_REG_POPULATOR_FILE_0).exists());
        this.cfgPop1EntryList = new ArrayList();
        this.cfgPop1EntryList.clear();
        int n2 = 0;
        while (n2 < 20) {
            JposEntry jposEntry = this.createDefaultJposEntry(CFG_REG_POPULATOR_FILE_1 + "_" + n2);
            this.cfgPop1EntryList.add(jposEntry);
            ++n2;
        }
        this.createSerializedEntriesFile(this.cfgPop1EntryList.iterator(), CFG_REG_POPULATOR_FILE_1);
        Assert.assertTrue((String)("File " + CFG_REG_POPULATOR_FILE_1 + " was not created"), (boolean)new File(CFG_REG_POPULATOR_FILE_1).exists());
        this.xmlPop0EntryList = new ArrayList();
        this.xmlPop0EntryList.clear();
        int n3 = 0;
        while (n3 < 5) {
            JposEntry jposEntry = this.createDefaultJposEntry(XML_REG_POPULATOR_FILE_0 + "_" + n3);
            this.xmlPop0EntryList.add(jposEntry);
            ++n3;
        }
        this.createXmlEntriesFile(this.xmlPop0EntryList.iterator(), XML_REG_POPULATOR_FILE_0);
        Assert.assertTrue((String)("File " + XML_REG_POPULATOR_FILE_0 + " was not created"), (boolean)new File(XML_REG_POPULATOR_FILE_0).exists());
        this.xmlPop1EntryList = new ArrayList();
        this.xmlPop1EntryList.clear();
        int n4 = 0;
        while (n4 < 15) {
            JposEntry jposEntry = this.createDefaultJposEntry(XML_REG_POPULATOR_FILE_1 + "_" + n4);
            this.xmlPop1EntryList.add(jposEntry);
            ++n4;
        }
        this.createXmlEntriesFile(this.xmlPop1EntryList.iterator(), XML_REG_POPULATOR_FILE_1);
        Assert.assertTrue((String)("File " + XML_REG_POPULATOR_FILE_1 + " was not created"), (boolean)new File(XML_REG_POPULATOR_FILE_1).exists());
        this.popEntryLists = new List[4];
        this.popEntryLists[0] = this.cfgPop0EntryList;
        this.popEntryLists[1] = this.xmlPop0EntryList;
        this.popEntryLists[2] = this.cfgPop1EntryList;
        this.popEntryLists[3] = this.xmlPop1EntryList;
    }

    private void createCompositePropFile() throws IOException {
        Properties properties = new Properties();
        properties.put("jpos.util.tracing", "OFF");
        properties.put("jpos.config.populator.class.0", "jpos.config.simple.SimpleRegPopulator");
        properties.put("jpos.config.populator.class.1", "jpos.config.simple.xml.SimpleXmlRegPopulator");
        properties.put("jpos.config.populator.class.2", "jpos.config.simple.SimpleRegPopulator");
        properties.put("jpos.config.populator.class.3", "jpos.config.simple.xml.SimpleXmlRegPopulator");
        properties.put("jpos.config.populator.file.0", CFG_REG_POPULATOR_FILE_0);
        properties.put("jpos.config.populator.file.1", XML_REG_POPULATOR_FILE_0);
        properties.put("jpos.config.populator.file.2", CFG_REG_POPULATOR_FILE_1);
        properties.put("jpos.config.populator.file.3", XML_REG_POPULATOR_FILE_1);
        this.createPropFile(properties);
        JposServiceLoader.getManager().getProperties().loadJposProperties();
    }

    private void deleteCompositePropFile() throws IOException {
        this.restorePropFile();
    }

    public void testRegPopulatorGetUniqueId() {
        this.compositePopulator.load();
        Assert.assertTrue((String)"compositePopulator.getUniqueId() cannot be null", (this.compositePopulator.getUniqueId() != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"compositePopulator.getUniqueId() cannot be empty string", (!"".equals(this.compositePopulator.getUniqueId()) ? 1 : 0) != 0);
        Iterator iterator = this.compositePopulator.getPopulators();
        while (iterator.hasNext()) {
            JposRegPopulator jposRegPopulator = (JposRegPopulator)iterator.next();
            Assert.assertTrue((String)"populator.getUniqueId() cannot be null", (jposRegPopulator.getUniqueId() != null ? 1 : 0) != 0);
            Assert.assertTrue((String)"populator.getUniqueId() cannot be empty string", (!"".equals(jposRegPopulator.getUniqueId()) ? 1 : 0) != 0);
        }
    }

    public void testRegPopulatorGetClassName() {
        this.compositePopulator.load();
        Assert.assertTrue((String)"compositePopulator.getClassName() cannot be null", (this.compositePopulator.getClassName() != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"compositePopulator.getClassName() cannot be empty string", (!"".equals(this.compositePopulator.getClassName()) ? 1 : 0) != 0);
        Iterator iterator = this.compositePopulator.getPopulators();
        while (iterator.hasNext()) {
            JposRegPopulator jposRegPopulator = (JposRegPopulator)iterator.next();
            Assert.assertTrue((String)"populator.getClassName() cannot be null", (jposRegPopulator.getClassName() != null ? 1 : 0) != 0);
            Assert.assertTrue((String)"populator.getClassName() cannot be empty string", (!"".equals(jposRegPopulator.getClassName()) ? 1 : 0) != 0);
        }
    }

    public void testGetDefaultPopulator() {
        this.compositePopulator.load();
        Assert.assertTrue((String)"CompositeRegPopulator.getDefaultRegPopulator() != null", (this.compositePopulator.getDefaultPopulator() != null ? 1 : 0) != 0);
    }

    public void testAddRemove() {
        this.compositePopulator.load();
        SimpleRegPopulator simpleRegPopulator = new SimpleRegPopulator("testAddPopulator");
        int n = this.compositePopulator.size();
        this.compositePopulator.add(simpleRegPopulator);
        Assert.assertTrue((String)"Size of CompositeRegPopulator should be 1 more after add!", (this.compositePopulator.size() == n + 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Added populator to composiste but not found in compositePop.getPopulators()", (boolean)JUnitUtility.isInList((Object)simpleRegPopulator, (List)JUnitUtility.createList((Iterator)this.compositePopulator.getPopulators())));
        int n2 = this.compositePopulator.size();
        this.compositePopulator.remove(simpleRegPopulator);
        Assert.assertTrue((String)"Size of CompositeRegPopulator should be 1 less after remove!", (this.compositePopulator.size() == n2 - 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Added populator to composiste but not found in compositePop.getPopulators()", (!JUnitUtility.isInList((Object)simpleRegPopulator, (List)JUnitUtility.createList((Iterator)this.compositePopulator.getPopulators())) ? 1 : 0) != 0);
    }

    public void testSize() {
        this.compositePopulator.load();
        Assert.assertTrue((String)"If compositePopulator loaded then size should be: 4", (this.compositePopulator.size() == 4 ? 1 : 0) != 0);
    }

    public void testGetPopulator() {
        this.compositePopulator.load();
        int n = 0;
        while (n < 4) {
            Assert.assertTrue((String)("Populator by name :jpos.config.populator.class." + n + " does not exist"), (this.compositePopulator.getPopulator("jpos.config.populator.class." + n) != null ? 1 : 0) != 0);
            Assert.assertTrue((String)("Populator by name :jpos.config.populator.class." + n + " does not exist"), (boolean)this.compositePopulator.getPopulator("jpos.config.populator.class." + n).getUniqueId().equals("jpos.config.populator.class." + n));
            ++n;
        }
    }

    public void testGetPopulators() {
        this.compositePopulator.load();
        Assert.assertTrue((String)"If compositePopulator loaded then size should be: 4", (this.compositePopulator.size() == 4 ? 1 : 0) != 0);
        int n = 0;
        Iterator iterator = this.compositePopulator.getPopulators();
        while (iterator.hasNext()) {
            try {
                JposRegPopulator jposRegPopulator = (JposRegPopulator)iterator.next();
                ++n;
            }
            catch (ClassCastException classCastException) {
                Assert.fail((String)"CompositeRegPopulator.getPopulators() should only return JposRegPopulator objects");
            }
        }
        Assert.assertTrue((String)"CompositeRegPopulator.getPopulators() should contain 4 populators", (n == 4 ? 1 : 0) != 0);
    }

    public void testLoad1() {
        this.compositePopulator.load();
        JposRegPopulator jposRegPopulator = this.compositePopulator.getDefaultPopulator();
        Assert.assertTrue((String)"Default populator cannot be null", (jposRegPopulator != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Default populator unique ID should be: jpos.config.populator.class.0", (boolean)"jpos.config.populator.class.0".equals(jposRegPopulator.getUniqueId()));
        Enumeration enumeration = jposRegPopulator.getEntries();
        Assert.assertTrue((String)("Should load entries from file: " + CFG_REG_POPULATOR_FILE_0), (boolean)JUnitUtility.isEquals((Enumeration)enumeration, JUnitUtility.createVector(this.cfgPop0EntryList.iterator()).elements()));
        this.compositePopulator.load(CFG_REG_POPULATOR_FILE_1);
        enumeration = jposRegPopulator.getEntries();
        Assert.assertTrue((String)("Should load entries from file: " + CFG_REG_POPULATOR_FILE_1), (boolean)JUnitUtility.isEquals((Enumeration)enumeration, JUnitUtility.createVector(this.cfgPop1EntryList.iterator()).elements()));
    }

    public void testLoad2() {
        this.compositePopulator.load();
        int n = 0;
        while (n < POPULATOR_IDS.length) {
            JposRegPopulator jposRegPopulator = this.compositePopulator.getPopulator(POPULATOR_IDS[n]);
            Assert.assertTrue((String)"Populator cannot be null", (jposRegPopulator != null ? 1 : 0) != 0);
            Assert.assertTrue((String)("Populator unique ID should be: " + POPULATOR_IDS[n]), (boolean)POPULATOR_IDS[n].equals(jposRegPopulator.getUniqueId()));
            Enumeration enumeration = jposRegPopulator.getEntries();
            Assert.assertTrue((String)("Should load entries from file: " + POPULATOR_FILES[n]), (boolean)JUnitUtility.isEquals((Enumeration)enumeration, JUnitUtility.createVector(this.popEntryLists[n].iterator()).elements()));
            ++n;
        }
    }

    public void testSave1() {
        this.emptyTest();
    }

    public void testSave2() {
        this.emptyTest();
    }

    public void testGetEntries() {
        this.compositePopulator.load();
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < this.popEntryLists.length) {
            int n2 = 0;
            while (n2 < this.popEntryLists[n].size()) {
                arrayList.add(this.popEntryLists[n].get(n2));
                ++n2;
            }
            ++n;
        }
        Enumeration enumeration = this.compositePopulator.getEntries();
        Assert.assertTrue((String)("Should have load entries from file: " + CFG_REG_POPULATOR_FILE_0), (boolean)JUnitUtility.isEquals((Enumeration)enumeration, JUnitUtility.createVector(arrayList.iterator()).elements()));
    }

    public void testGetEntriesURL() throws Exception {
        this.compositePopulator.load();
        URL uRL = this.compositePopulator.getEntriesURL();
    }

    public void testGetLastLoadException() {
        this.emptyTest();
    }
}

