/*
 * Decompiled with CFR 0.152.
 */
package jpos.config.simple;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jpos.JposTestCase;
import jpos.config.JposConfigException;
import jpos.config.JposEntry;
import jpos.config.simple.SimpleEntry;
import junit.framework.Assert;

public class SimpleEntryPropTestCase
extends JposTestCase {
    private JposEntry entry = null;
    private List propNameList = new LinkedList();
    private List propValueList = new LinkedList();
    private List propList = new LinkedList();
    private JposEntry.Prop stringProp = null;
    private JposEntry.Prop booleanProp = null;
    private JposEntry.Prop byteProp = null;
    private JposEntry.Prop characterProp = null;
    private JposEntry.Prop doubleProp = null;
    private JposEntry.Prop floatProp = null;
    private JposEntry.Prop longProp = null;
    private JposEntry.Prop integerProp = null;
    public static final String VENDOR_PROP_NAME = "vendor.prop.name";
    public static final String STRING_VENDOR_PROP_NAME = (class$java$lang$String == null ? (class$java$lang$String = SimpleEntryPropTestCase.class$("java.lang.String")) : class$java$lang$String).getName() + "_" + "vendor.prop.name";
    public static final String BOOLEAN_VENDOR_PROP_NAME = (class$java$lang$Boolean == null ? (class$java$lang$Boolean = SimpleEntryPropTestCase.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName() + "_" + "vendor.prop.name";
    public static final String BYTE_VENDOR_PROP_NAME = (class$java$lang$Byte == null ? (class$java$lang$Byte = SimpleEntryPropTestCase.class$("java.lang.Byte")) : class$java$lang$Byte).getName() + "_" + "vendor.prop.name";
    public static final String CHARACTER_VENDOR_PROP_NAME = (class$java$lang$Character == null ? (class$java$lang$Character = SimpleEntryPropTestCase.class$("java.lang.Character")) : class$java$lang$Character).getName() + "_" + "vendor.prop.name";
    public static final String DOUBLE_VENDOR_PROP_NAME = (class$java$lang$Double == null ? (class$java$lang$Double = SimpleEntryPropTestCase.class$("java.lang.Double")) : class$java$lang$Double).getName() + "_" + "vendor.prop.name";
    public static final String FLOAT_VENDOR_PROP_NAME = (class$java$lang$Float == null ? (class$java$lang$Float = SimpleEntryPropTestCase.class$("java.lang.Float")) : class$java$lang$Float).getName() + "_" + "vendor.prop.name";
    public static final String LONG_VENDOR_PROP_NAME = (class$java$lang$Long == null ? (class$java$lang$Long = SimpleEntryPropTestCase.class$("java.lang.Long")) : class$java$lang$Long).getName() + "_" + "vendor.prop.name";
    public static final String INTEGER_VENDOR_PROP_NAME = (class$java$lang$Integer == null ? (class$java$lang$Integer = SimpleEntryPropTestCase.class$("java.lang.Integer")) : class$java$lang$Integer).getName() + "_" + "vendor.prop.name";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;

    public SimpleEntryPropTestCase(String string) {
        super(string);
    }

    protected void setUp() {
        this.entry = this.createJposEntry();
    }

    protected void tearDown() {
        this.entry = null;
        this.propNameList.clear();
        this.propValueList.clear();
    }

    private JposEntry createJposEntry() {
        JposEntry jposEntry = this.createJposEntry("logicalName", "serviceInstanceFactoryClass", "serviceClass", "vendorName", "vendorURL", "deviceCategory", "jposVersion", "productName", "productDescription", "productURL", null);
        this.propNameList.add("logicalName");
        this.propNameList.add("serviceInstanceFactoryClass");
        this.propNameList.add("serviceClass");
        this.propNameList.add("vendorName");
        this.propNameList.add("vendorURL");
        this.propNameList.add("deviceCategory");
        this.propNameList.add("jposVersion");
        this.propNameList.add("productName");
        this.propNameList.add("productDescription");
        this.propNameList.add("productURL");
        this.propValueList.add("logicalName");
        this.propValueList.add("serviceInstanceFactoryClass");
        this.propValueList.add("serviceClass");
        this.propValueList.add("vendorName");
        this.propValueList.add("vendorURL");
        this.propValueList.add("deviceCategory");
        this.propValueList.add("jposVersion");
        this.propValueList.add("productName");
        this.propValueList.add("productDescription");
        this.propValueList.add("productURL");
        this.stringProp = new SimpleEntry.Prop(STRING_VENDOR_PROP_NAME, STRING_VENDOR_PROP_NAME);
        this.booleanProp = new SimpleEntry.Prop(BOOLEAN_VENDOR_PROP_NAME, Boolean.FALSE);
        this.byteProp = new SimpleEntry.Prop(BYTE_VENDOR_PROP_NAME, new Byte(10));
        this.characterProp = new SimpleEntry.Prop(CHARACTER_VENDOR_PROP_NAME, new Character('A'));
        this.doubleProp = new SimpleEntry.Prop(DOUBLE_VENDOR_PROP_NAME, new Double(3.14159));
        this.floatProp = new SimpleEntry.Prop(FLOAT_VENDOR_PROP_NAME, new Float(3.14159));
        this.longProp = new SimpleEntry.Prop(LONG_VENDOR_PROP_NAME, new Long(1234L));
        this.integerProp = new SimpleEntry.Prop(INTEGER_VENDOR_PROP_NAME, new Integer(1234));
        this.propList.add(this.stringProp);
        this.propList.add(this.booleanProp);
        this.propList.add(this.byteProp);
        this.propList.add(this.characterProp);
        this.propList.add(this.doubleProp);
        this.propList.add(this.floatProp);
        this.propList.add(this.longProp);
        this.propList.add(this.integerProp);
        Iterator iterator = this.propList.iterator();
        while (iterator.hasNext()) {
            JposEntry.Prop prop = (JposEntry.Prop)iterator.next();
            jposEntry.add(prop);
            this.propNameList.add(prop.getName());
            this.propValueList.add(prop.getValue());
        }
        return jposEntry;
    }

    public void testGetName() {
        Iterator iterator = this.propList.iterator();
        while (iterator.hasNext()) {
            JposEntry.Prop prop = (JposEntry.Prop)iterator.next();
            Assert.assertTrue((String)"Got a JposEntry.Prop with null name", (prop.getName() != null ? 1 : 0) != 0);
            Assert.assertTrue((String)"prop.getName() is not in entry", (boolean)this.entry.hasPropertyWithName(prop.getName()));
        }
    }

    public void testGetValue() {
        Iterator iterator = this.propList.iterator();
        while (iterator.hasNext()) {
            JposEntry.Prop prop = (JposEntry.Prop)iterator.next();
            Assert.assertTrue((String)"Got a JposEntry.Prop with null value", (prop.getValue() != null ? 1 : 0) != 0);
            Assert.assertTrue((String)"prop.getName() is not in entry", (boolean)this.entry.hasPropertyWithName(prop.getName()));
            Assert.assertTrue((String)"prop.getValue() is not in entry", (boolean)this.entry.hasPropertyWithValue(prop.getValue()));
        }
    }

    public void testGetValueAsString() {
        Iterator iterator = this.entry.getProps();
        while (iterator.hasNext()) {
            JposEntry.Prop prop = (JposEntry.Prop)iterator.next();
            String string = prop.getValueAsString();
            Assert.assertTrue((String)"stringValue cannot be null", (string != null ? 1 : 0) != 0);
            Assert.assertTrue((String)"stringValue different then prop.getValue().toString()", (boolean)string.equals(prop.getValue().toString()));
        }
    }

    public void testGetType() {
        Assert.assertTrue((String)"stringProp.getType() is invalid", (boolean)this.stringProp.getType().equals(class$java$lang$String == null ? (class$java$lang$String = SimpleEntryPropTestCase.class$("java.lang.String")) : class$java$lang$String));
        Assert.assertTrue((String)"booleanProp.getType() is invalid", (boolean)this.booleanProp.getType().equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = SimpleEntryPropTestCase.class$("java.lang.Boolean")) : class$java$lang$Boolean));
        Assert.assertTrue((String)"byteProp.getType() is invalid", (boolean)this.byteProp.getType().equals(class$java$lang$Byte == null ? (class$java$lang$Byte = SimpleEntryPropTestCase.class$("java.lang.Byte")) : class$java$lang$Byte));
        Assert.assertTrue((String)"characterProp.getType() is invalid", (boolean)this.characterProp.getType().equals(class$java$lang$Character == null ? (class$java$lang$Character = SimpleEntryPropTestCase.class$("java.lang.Character")) : class$java$lang$Character));
        Assert.assertTrue((String)"doubleProp.getType() is invalid", (boolean)this.doubleProp.getType().equals(class$java$lang$Double == null ? (class$java$lang$Double = SimpleEntryPropTestCase.class$("java.lang.Double")) : class$java$lang$Double));
        Assert.assertTrue((String)"floatProp.getType() is invalid", (boolean)this.floatProp.getType().equals(class$java$lang$Float == null ? (class$java$lang$Float = SimpleEntryPropTestCase.class$("java.lang.Float")) : class$java$lang$Float));
        Assert.assertTrue((String)"longProp.getType() is invalid", (boolean)this.longProp.getType().equals(class$java$lang$Long == null ? (class$java$lang$Long = SimpleEntryPropTestCase.class$("java.lang.Long")) : class$java$lang$Long));
        Assert.assertTrue((String)"integerProp.getType() is invalid", (boolean)this.integerProp.getType().equals(class$java$lang$Integer == null ? (class$java$lang$Integer = SimpleEntryPropTestCase.class$("java.lang.Integer")) : class$java$lang$Integer));
    }

    public void testSetNameString() throws IllegalArgumentException {
        String string = this.stringProp.getName();
        Object object = this.stringProp.getValue();
        Class clazz = this.stringProp.getType();
        String string2 = null;
        try {
            this.stringProp.setName(string2);
            Assert.fail((String)"Allowed setName( null )");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        string2 = "newStringPropName";
        this.stringProp.setName(string2);
        Assert.assertTrue((String)"Changed name of property but did not get new name from getName()", (boolean)this.stringProp.getName().equals(string2));
    }

    public void testSetValueString() throws IllegalArgumentException {
        String string = this.stringProp.getName();
        Object object = this.stringProp.getValue();
        Class clazz = this.stringProp.getType();
        String string2 = null;
        try {
            this.stringProp.setValue(string2);
            Assert.fail((String)"Allowed setValue( null )");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        string2 = "newPropValue";
        this.stringProp.setValue(string2);
        Assert.assertTrue((String)"stringProp.getName().equals( propName ) == false", (boolean)this.stringProp.getName().equals(string));
        Assert.assertTrue((String)"stringProp.getValue().equals( newPropValue ) == false", (boolean)this.stringProp.getValue().equals(string2));
        Assert.assertTrue((String)"stringProp.getType().equals( propType ) == false", (boolean)this.stringProp.getType().equals(clazz));
    }

    public void testSetValueBoolean() throws IllegalArgumentException {
        String string = this.booleanProp.getName();
        Object object = this.booleanProp.getValue();
        Class clazz = this.booleanProp.getType();
        Boolean bl = null;
        try {
            this.booleanProp.setValue(bl);
            Assert.fail((String)"Allowed setValue( null )");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        bl = new Boolean(true);
        this.booleanProp.setValue(bl);
        Assert.assertTrue((String)"booleanProp.getName().equals( propName ) == false", (boolean)this.booleanProp.getName().equals(string));
        Assert.assertTrue((String)"booleanProp.getValue().equals( newPropValue ) == false", (boolean)this.booleanProp.getValue().equals(bl));
        Assert.assertTrue((String)"booleanProp.getType().equals( propType ) == false", (boolean)this.booleanProp.getType().equals(clazz));
    }

    public void testSetValueByte() throws IllegalArgumentException {
        String string = this.byteProp.getName();
        Object object = this.byteProp.getValue();
        Class clazz = this.byteProp.getType();
        Byte by = null;
        try {
            this.byteProp.setValue(by);
            Assert.fail((String)"Allowed setValue( null )");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        by = new Byte(11);
        this.byteProp.setValue(by);
        Assert.assertTrue((String)"byteProp.getName().equals( propName ) == false", (boolean)this.byteProp.getName().equals(string));
        Assert.assertTrue((String)"byteProp.getValue().equals( newPropValue ) == false", (boolean)this.byteProp.getValue().equals(by));
        Assert.assertTrue((String)"byteProp.getType().equals( propType ) == false", (boolean)this.byteProp.getType().equals(clazz));
    }

    public void testSetValueCharacter() throws IllegalArgumentException {
        String string = this.characterProp.getName();
        Object object = this.characterProp.getValue();
        Class clazz = this.characterProp.getType();
        Character c = null;
        try {
            this.characterProp.setValue(c);
            Assert.fail((String)"Allowed setValue( null )");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        c = new Character('Z');
        this.characterProp.setValue(c);
        Assert.assertTrue((String)"characterProp.getName().equals( propName ) == false", (boolean)this.characterProp.getName().equals(string));
        Assert.assertTrue((String)"characterProp.getValue().equals( newPropValue ) == false", (boolean)this.characterProp.getValue().equals(c));
        Assert.assertTrue((String)"characterProp.getType().equals( propType ) == false", (boolean)this.characterProp.getType().equals(clazz));
    }

    public void testSetValueDouble() throws IllegalArgumentException {
        String string = this.doubleProp.getName();
        Object object = this.doubleProp.getValue();
        Class clazz = this.doubleProp.getType();
        Double d = null;
        try {
            this.doubleProp.setValue(d);
            Assert.fail((String)"Allowed setValue( null )");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        d = new Double(2.7818);
        this.doubleProp.setValue(d);
        Assert.assertTrue((String)"doubleProp.getName().equals( propName ) == false", (boolean)this.doubleProp.getName().equals(string));
        Assert.assertTrue((String)"doubleProp.getValue().equals( newPropValue ) == false", (boolean)this.doubleProp.getValue().equals(d));
        Assert.assertTrue((String)"doubleProp.getType().equals( propType ) == false", (boolean)this.doubleProp.getType().equals(clazz));
    }

    public void testSetValueFloat() throws IllegalArgumentException {
        String string = this.floatProp.getName();
        Object object = this.floatProp.getValue();
        Class clazz = this.floatProp.getType();
        Float f = null;
        try {
            this.floatProp.setValue(f);
            Assert.fail((String)"Allowed setValue( null )");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        f = new Float(2.7818);
        this.floatProp.setValue(f);
        Assert.assertTrue((String)"floatProp.getName().equals( propName ) == false", (boolean)this.floatProp.getName().equals(string));
        Assert.assertTrue((String)"floatProp.getValue().equals( newPropValue ) == false", (boolean)this.floatProp.getValue().equals(f));
        Assert.assertTrue((String)"floatProp.getType().equals( propType ) == false", (boolean)this.floatProp.getType().equals(clazz));
    }

    public void testSetValueLong() throws IllegalArgumentException {
        String string = this.longProp.getName();
        Object object = this.longProp.getValue();
        Class clazz = this.longProp.getType();
        Long l = null;
        try {
            this.longProp.setValue(l);
            Assert.fail((String)"Allowed setValue( null )");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        l = new Long(54321L);
        this.longProp.setValue(l);
        Assert.assertTrue((String)"longProp.getName().equals( propName ) == false", (boolean)this.longProp.getName().equals(string));
        Assert.assertTrue((String)"longProp.getValue().equals( newPropValue ) == false", (boolean)this.longProp.getValue().equals(l));
        Assert.assertTrue((String)"longProp.getType().equals( propType ) == false", (boolean)this.longProp.getType().equals(clazz));
    }

    public void testSetValueInteger() throws IllegalArgumentException {
        String string = this.integerProp.getName();
        Object object = this.integerProp.getValue();
        Class clazz = this.integerProp.getType();
        Integer n = null;
        try {
            this.integerProp.setValue(n);
            Assert.fail((String)"Allowed setValue( null )");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        n = new Integer(54321);
        this.integerProp.setValue(n);
        Assert.assertTrue((String)"integerProp.getName().equals( propName ) == false", (boolean)this.integerProp.getName().equals(string));
        Assert.assertTrue((String)"integerProp.getValue().equals( newPropValue ) == false", (boolean)this.integerProp.getValue().equals(n));
        Assert.assertTrue((String)"integerProp.getType().equals( propType ) == false", (boolean)this.integerProp.getType().equals(clazz));
    }

    public void testIsOfType() {
        Assert.assertTrue((String)"stringProp.isOfType() returned invalid answer", (boolean)this.stringProp.isOfType(class$java$lang$String == null ? (class$java$lang$String = SimpleEntryPropTestCase.class$("java.lang.String")) : class$java$lang$String));
        Assert.assertTrue((String)"booleanProp.isOfType() returned invalid answer", (boolean)this.booleanProp.isOfType(class$java$lang$Boolean == null ? (class$java$lang$Boolean = SimpleEntryPropTestCase.class$("java.lang.Boolean")) : class$java$lang$Boolean));
        Assert.assertTrue((String)"byteProp.isOfType() returned invalid answer", (boolean)this.byteProp.isOfType(class$java$lang$Byte == null ? (class$java$lang$Byte = SimpleEntryPropTestCase.class$("java.lang.Byte")) : class$java$lang$Byte));
        Assert.assertTrue((String)"characterProp.isOfType() returned invalid answer", (boolean)this.characterProp.isOfType(class$java$lang$Character == null ? (class$java$lang$Character = SimpleEntryPropTestCase.class$("java.lang.Character")) : class$java$lang$Character));
        Assert.assertTrue((String)"doubleProp.isOfType() returned invalid answer", (boolean)this.doubleProp.isOfType(class$java$lang$Double == null ? (class$java$lang$Double = SimpleEntryPropTestCase.class$("java.lang.Double")) : class$java$lang$Double));
        Assert.assertTrue((String)"floatProp.isOfType() returned invalid answer", (boolean)this.floatProp.isOfType(class$java$lang$Float == null ? (class$java$lang$Float = SimpleEntryPropTestCase.class$("java.lang.Float")) : class$java$lang$Float));
        Assert.assertTrue((String)"longProp.isOfType() returned invalid answer", (boolean)this.longProp.isOfType(class$java$lang$Long == null ? (class$java$lang$Long = SimpleEntryPropTestCase.class$("java.lang.Long")) : class$java$lang$Long));
        Assert.assertTrue((String)"integerProp.isOfType() returned invalid answer", (boolean)this.integerProp.isOfType(class$java$lang$Integer == null ? (class$java$lang$Integer = SimpleEntryPropTestCase.class$("java.lang.Integer")) : class$java$lang$Integer));
        Assert.assertTrue((String)"integerProp.isOfType() returned invalid answer", (!this.integerProp.isOfType(class$java$lang$String == null ? (class$java$lang$String = SimpleEntryPropTestCase.class$("java.lang.String")) : class$java$lang$String) ? 1 : 0) != 0);
    }

    public void testEquals() {
        Assert.assertTrue((String)"integerProp.equals( null ) should be false", (!this.integerProp.equals(null) ? 1 : 0) != 0);
        Assert.assertTrue((String)"integerProp.equals( integerProp ) should be true", (this.integerProp.equals(this.integerProp) ? 1 : 0) != 0);
        Assert.assertTrue((String)"integerProp.equals( integerProp.copy() ) should be true", (this.integerProp.equals(this.integerProp.copy()) ? 1 : 0) != 0);
        Assert.assertTrue((String)"integerProp.equals( stringProp ) should be false", (!this.integerProp.equals(this.stringProp) ? 1 : 0) != 0);
    }

    public void testCopy() {
        Iterator iterator = this.propList.iterator();
        while (iterator.hasNext()) {
            JposEntry.Prop prop = (JposEntry.Prop)iterator.next();
            JposEntry.Prop prop2 = prop.copy();
            Assert.assertTrue((String)"propCopy == null", (prop2 != null ? 1 : 0) != 0);
            Assert.assertTrue((String)"propCopy.equals( prop ) == false", (boolean)prop2.equals(prop));
            Assert.assertTrue((String)"propCopy.getName().equals( prop.getName() ) == false", (boolean)prop2.getName().equals(prop.getName()));
            Assert.assertTrue((String)"propCopy.getValue().equals( prop.getValue() ) == false", (boolean)prop2.getValue().equals(prop.getValue()));
            Assert.assertTrue((String)"propCopy.getType().equals( prop.getType() ) == false", (boolean)prop2.getType().equals(prop.getType()));
        }
    }

    public void testCompareTo() throws JposConfigException {
        SimpleEntry simpleEntry = new SimpleEntry("SimpleEntry");
        JposEntry.Prop prop = simpleEntry.createProp("aaa", new Boolean("true"), class$java$lang$Boolean == null ? (class$java$lang$Boolean = SimpleEntryPropTestCase.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        JposEntry.Prop prop2 = simpleEntry.createProp("zzz", new Integer("1234"), class$java$lang$Integer == null ? (class$java$lang$Integer = SimpleEntryPropTestCase.class$("java.lang.Integer")) : class$java$lang$Integer);
        Assert.assertTrue((String)"aaaEntryProp.compareTo( aaaEntryProp ) should == 0", (prop.compareTo(prop) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"zzzEntryProp.compareTo( zzzEntryProp ) should == 0", (prop2.compareTo(prop2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"zzzEntryProp.compareTo( aaaEntryProp ) should < 0", (prop2.compareTo(prop) > 0 ? 1 : 0) != 0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

