/*
 * Decompiled with CFR 0.152.
 */
package jpos.loader;

import java.util.Enumeration;
import jpos.JposException;
import jpos.config.JposEntry;
import jpos.config.JposEntryRegistry;
import jpos.loader.AbstractTestCase;
import jpos.loader.JposServiceConnection;
import jpos.loader.JposServiceLoader;
import jpos.loader.JposServiceManager;
import junit.framework.Assert;

public class JposServiceLoaderTestCase
extends AbstractTestCase {
    public JposServiceLoaderTestCase(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    protected boolean useSimpleProfile() {
        return true;
    }

    public void testFindService() throws JposException {
        JposServiceLoader.getManager().getProperties().loadJposProperties();
        JposEntryRegistry jposEntryRegistry = JposServiceLoader.getManager().getEntryRegistry();
        Enumeration enumeration = jposEntryRegistry.getEntries();
        while (enumeration.hasMoreElements()) {
            JposEntry jposEntry = (JposEntry)enumeration.nextElement();
            JposServiceConnection jposServiceConnection = JposServiceLoader.findService(jposEntry.getLogicalName());
            Assert.assertTrue((String)("Could not get connection for existing entry with logical name = " + jposEntry.getLogicalName()), (jposServiceConnection != null ? 1 : 0) != 0);
            Assert.assertTrue((String)("JposServiceConnection.getLogicalName() == " + jposServiceConnection.getLogicalName() + " is different than the JposEntry.getLogicalName() == " + jposEntry.getLogicalName()), (boolean)jposServiceConnection.getLogicalName().equals(jposEntry.getLogicalName()));
        }
    }

    public void testGetManager() {
        Assert.assertTrue((String)"JposServiceLoader.getManager() returned null", (JposServiceLoader.getManager() != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"JposServiceLoader.getManager() must be an instance of JposServiceManager", (boolean)(JposServiceLoader.getManager() instanceof JposServiceManager));
    }
}

