/*
 * Decompiled with CFR 0.152.
 */
package jpos.profile;

import java.util.Vector;
import jpos.JposTestCase;
import jpos.profile.DefaultDevCatInfo;
import jpos.profile.DefaultDevCatInfoList;
import jpos.profile.DefaultProfile;
import jpos.profile.DevCatInfo;
import jpos.profile.DevCatInfoList;
import jpos.profile.JposDevCats;
import jpos.profile.Profile;
import jpos.test.JUnitUtility;
import junit.framework.Assert;

public class DevCatInfoListTestCase
extends JposTestCase {
    private Profile profile = null;
    private DevCatInfoList list = null;
    private DevCatInfo devCatInfo0 = null;
    private DevCatInfo devCatInfo1 = null;
    private DevCatInfo devCatInfo2 = null;

    public DevCatInfoListTestCase(String string) {
        super(string);
    }

    protected void setUp() {
        this.profile = new DefaultProfile("JUnit");
        this.list = new DefaultDevCatInfoList();
        this.devCatInfo0 = new DefaultDevCatInfo(this.profile, JposDevCats.CASHDRAWER_DEVCAT);
        this.devCatInfo1 = new DefaultDevCatInfo(this.profile, JposDevCats.POSPRINTER_DEVCAT);
        this.devCatInfo2 = new DefaultDevCatInfo(this.profile, JposDevCats.LINEDISPLAY_DEVCAT);
    }

    protected void tearDown() {
        this.list = null;
    }

    public void testDevCatInfoList1() {
        Assert.assertTrue((String)"Expects DevCatInfoList to be of size 0", (this.list.getSize() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expects DevCatInfoList to be of size 0 and empty", (boolean)this.list.isEmpty());
        this.list.add(this.devCatInfo0);
        this.list.add(this.devCatInfo1);
        this.list.add(this.devCatInfo2);
        Assert.assertTrue((String)"Expects DevCatInfoList to be of size 3", (this.list.getSize() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expects DevCatInfoList to be of size 3 thus NOT empty", (!this.list.isEmpty() ? 1 : 0) != 0);
        this.list.remove(this.devCatInfo1);
        Assert.assertTrue((String)"Expects DevCatInfoList to be of size 2", (this.list.getSize() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expects list to have devCatInfo0", (boolean)this.list.contains(this.devCatInfo0));
        Assert.assertTrue((String)"Expects list to NOT have devCatInfo1", (!this.list.contains(this.devCatInfo1) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expects list to have devCatInfo2", (boolean)this.list.contains(this.devCatInfo2));
        this.list.removeAll();
        Assert.assertTrue((String)"Expects DevCatInfoList to be of size 0", (this.list.getSize() == 0 ? 1 : 0) != 0);
    }

    public void testDevCatInfoList2() {
        Assert.assertTrue((String)"Expects DevCatInfoList to be of size 0", (this.list.getSize() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expects DevCatInfoList to be of size 0 and empty", (boolean)this.list.isEmpty());
        this.list.add(this.devCatInfo0);
        this.list.add(this.devCatInfo1);
        this.list.add(this.devCatInfo2);
        Vector<DevCatInfo> vector = new Vector<DevCatInfo>();
        vector.add(this.devCatInfo0);
        vector.add(this.devCatInfo1);
        vector.add(this.devCatInfo2);
        Assert.assertTrue((String)"Expects DevCatInfoList to be of size 3", (this.list.getSize() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Expects DevCatInfoList to be of size 3 thus NOT empty", (!this.list.isEmpty() ? 1 : 0) != 0);
        DevCatInfoList.Iterator iterator = this.list.iterator();
        Vector<DevCatInfo> vector2 = new Vector<DevCatInfo>();
        while (iterator.hasNext()) {
            vector2.add(iterator.next());
        }
        Assert.assertTrue((String)"Expects the DevCatInfoList.Iterator contents is <devCatInfo0, devCatInfo1, devCatInfo2>", (boolean)JUnitUtility.isEquals(vector, vector2));
        Assert.assertTrue((String)"Expects the DevCatInfoList.Iterator contents to be identical as <devCatInfo0, devCatInfo1, devCatInfo2>", (boolean)JUnitUtility.isIdentical(vector, vector2));
        this.list.remove(this.devCatInfo0);
        vector.remove(this.devCatInfo0);
        iterator = this.list.iterator();
        vector2.clear();
        while (iterator.hasNext()) {
            vector2.add(iterator.next());
        }
        Assert.assertTrue((String)"Expects the DevCatInfoList.Iterator contents is <devCatInfo0, devCatInfo1, devCatInfo2>", (boolean)JUnitUtility.isEquals(vector, vector2));
        Assert.assertTrue((String)"Expects the DevCatInfoList.Iterator contents to be identical as <devCatInfo0, devCatInfo1, devCatInfo2>", (boolean)JUnitUtility.isIdentical(vector, vector2));
        this.list.remove(this.devCatInfo2);
        vector.remove(this.devCatInfo2);
        iterator = this.list.iterator();
        vector2.clear();
        while (iterator.hasNext()) {
            vector2.add(iterator.next());
        }
        Assert.assertTrue((String)"Expects the DevCatInfoList.Iterator contents is <devCatInfo0, devCatInfo1, devCatInfo2>", (boolean)JUnitUtility.isEquals(vector, vector2));
        Assert.assertTrue((String)"Expects the DevCatInfoList.Iterator contents to be identical as <devCatInfo0, devCatInfo1, devCatInfo2>", (boolean)JUnitUtility.isIdentical(vector, vector2));
        this.list.removeAll();
        vector.clear();
        iterator = this.list.iterator();
        vector2.clear();
        while (iterator.hasNext()) {
            vector2.add(iterator.next());
        }
        Assert.assertTrue((String)"Expects the DevCatInfoList.Iterator contents is <devCatInfo0, devCatInfo1, devCatInfo2>", (boolean)JUnitUtility.isEquals(vector, vector2));
        Assert.assertTrue((String)"Expects the DevCatInfoList.Iterator contents to be identical as <devCatInfo0, devCatInfo1, devCatInfo2>", (boolean)JUnitUtility.isIdentical(vector, vector2));
    }
}

