/*
 * Decompiled with CFR 0.152.
 */
package jpos.util;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import jpos.util.JposProperties;
import jpos.util.JposPropertiesConst;

public class DefaultProperties
implements JposProperties {
    private Properties jposProperties = null;
    private HashMap multiPropMap = new HashMap();
    private String loadedPropFileName = "";
    private boolean loaded = false;
    private Exception lastException = null;
    private static Comparator propComparator = null;
    public static final String STRING_LIST_SEPARATOR = ",";

    public void loadJposProperties() {
        this.loadJposPropertiesByName("jpos/res/jpos.properties");
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public Exception getLastException() {
        return this.lastException;
    }

    public String getPropertyString(String string) {
        String string2 = "";
        if (System.getProperties().containsKey(string)) {
            string2 = System.getProperties().getProperty(string);
        } else if (this.jposProperties != null) {
            string2 = this.jposProperties.getProperty(string);
        }
        return string2;
    }

    public boolean isPropertyDefined(String string) {
        if (System.getProperties().containsKey(string)) {
            return true;
        }
        if (this.jposProperties != null) {
            Enumeration<Object> enumeration = this.jposProperties.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (!string2.equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public Enumeration getPropertyNames() {
        return this.getJposProperties().keys();
    }

    public JposProperties.MultiProperty getMultiProperty(String string) {
        return (JposProperties.MultiProperty)this.multiPropMap.get(string);
    }

    public boolean hasMultiProperty(String string) {
        return this.multiPropMap.containsKey(string);
    }

    public int size() {
        return this.jposProperties.size();
    }

    public List getStringListProperty(String string) {
        String string2 = this.getPropertyString(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string2 == null) {
            return arrayList;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, STRING_LIST_SEPARATOR);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<JposProperties>\n");
        Enumeration enumeration = this.getPropertyNames();
        ArrayList arrayList = new ArrayList();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        Collections.sort(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = this.getPropertyString(string);
            stringBuffer.append("<name = \"" + string + "\"" + " value = \"" + string2 + "\" />\n");
        }
        stringBuffer.append("</JposProperties>\n");
        return stringBuffer.toString();
    }

    public static Comparator propComparator() {
        if (propComparator == null) {
            propComparator = new Comparator(){

                public int compare(Object object, Object object2) {
                    if (!(object instanceof JposProperties.Prop)) {
                        return -1;
                    }
                    if (!(object2 instanceof JposProperties.Prop)) {
                        return -1;
                    }
                    String string = ((JposProperties.Prop)object).getName();
                    String string2 = ((JposProperties.Prop)object2).getName();
                    return string.compareTo(string2);
                }
            };
        }
        return propComparator;
    }

    public static Iterator getDefinedPropertyNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < JposPropertiesConst.PROP_NAME_ARRAY.length) {
            arrayList.add(JposPropertiesConst.PROP_NAME_ARRAY[n]);
            ++n;
        }
        return arrayList.iterator();
    }

    protected void createMultiProperties() {
        Enumeration<Object> enumeration = this.jposProperties.keys();
        while (enumeration.hasMoreElements()) {
            MultiProp multiProp;
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.jposProperties.get(string);
            if (!this.isMultiProp(string)) continue;
            String string3 = this.getMultiPropBaseName(string);
            if (this.multiPropMap.containsKey(string3)) {
                multiProp = (MultiProp)this.multiPropMap.get(string3);
                multiProp.add(string, string2);
                continue;
            }
            DefaultProperties defaultProperties = this;
            defaultProperties.getClass();
            multiProp = defaultProperties.new MultiProp(string3);
            multiProp.add(string, string2);
            this.multiPropMap.put(string3, multiProp);
        }
    }

    protected boolean isMultiProp(String string) {
        if (string.indexOf(".") == -1) {
            return false;
        }
        int n = string.lastIndexOf(".");
        String string2 = string.substring(n + 1);
        int n2 = -1;
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = -1;
        }
        return n2 >= 0;
    }

    protected String getMultiPropBaseName(String string) throws IllegalArgumentException {
        if (!this.isMultiProp(string)) {
            throw new IllegalArgumentException("getMultiPropBaseName( propName ) expects a propName that is a MuliProp");
        }
        return string.substring(0, string.lastIndexOf("."));
    }

    public Iterator getProps() {
        ArrayList<Prop> arrayList = new ArrayList<Prop>();
        Enumeration enumeration = this.getPropertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.getPropertyString(string);
            Prop prop = new Prop(string, string2);
            arrayList.add(prop);
        }
        return arrayList.iterator();
    }

    void loadJposPropertiesByName(String string) {
        this.loaded = false;
        this.lastException = null;
        this.jposProperties = this.findProperties(string);
        this.createMultiProperties();
    }

    String getLoadedPropFileName() {
        return this.loadedPropFileName;
    }

    Properties getJposProperties() {
        if (this.jposProperties == null) {
            this.loadJposProperties();
        }
        return this.jposProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    Properties findProperties(String string) {
        Properties properties;
        block8: {
            block9: {
                properties = new Properties();
                this.loadedPropFileName = string;
                InputStream inputStream = ClassLoader.getSystemResourceAsStream(this.loadedPropFileName);
                if (inputStream == null) break block9;
                inputStream = new BufferedInputStream(inputStream);
                properties.load(inputStream);
                this.loaded = true;
                Object var6_4 = null;
                try {
                    inputStream.close();
                }
                catch (Exception exception) {
                    System.err.println("Unexpected exception while closing stream Exception.message = " + exception.getMessage());
                }
                break block8;
                {
                    catch (Exception exception) {
                        this.loaded = false;
                        this.loadedPropFileName = "";
                        this.lastException = exception;
                        Object var6_5 = null;
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception2) {
                            System.err.println("Unexpected exception while closing stream Exception.message = " + exception2.getMessage());
                        }
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {
                        System.err.println("Unexpected exception while closing stream Exception.message = " + exception.getMessage());
                    }
                    throw throwable;
                }
            }
            this.loaded = false;
            System.err.println(string + " file not found");
        }
        return properties;
    }

    public static class Prop
    implements JposProperties.Prop {
        private String name = "";
        private String value = "";

        public Prop(String string, String string2) {
            this.name = string;
            this.value = string2;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setValue(String string) {
            this.value = string;
        }

        public int compareTo(JposProperties.Prop prop) {
            if (prop == null) {
                return -1;
            }
            return this.getName().compareTo(prop.getName());
        }

        public int compareTo(Object object) {
            return this.compareTo((JposProperties.Prop)object);
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof JposProperties.Prop)) {
                return false;
            }
            JposProperties.Prop prop = (JposProperties.Prop)object;
            return this.getName().equals(prop.getName()) && this.getValue().equals(prop.getValue());
        }

        public String toString() {
            return "<name = " + this.getName() + ", value = " + this.getValue() + ">";
        }
    }

    class MultiProp
    implements JposProperties.MultiProperty {
        private String basePropName = "";
        private HashMap propMap = new HashMap();

        MultiProp(String string) {
            this.basePropName = string;
        }

        public String getBasePropertyName() {
            return this.basePropName;
        }

        public Iterator getPropertyNames() {
            return this.propMap.keySet().iterator();
        }

        public Iterator getSortedPropertyNames() {
            ArrayList arrayList = new ArrayList(this.propMap.keySet());
            Collections.sort(arrayList);
            return arrayList.iterator();
        }

        public Iterator getPropertyValues() {
            return this.propMap.values().iterator();
        }

        public String getPropertyString(String string) {
            return (String)this.propMap.get(string);
        }

        public String getPropertyString(int n) throws IllegalArgumentException {
            if (n < 0) {
                throw new IllegalArgumentException("Cannot find property in multiprop with number i = " + n);
            }
            return this.getPropertyString(this.getBasePropertyName() + "." + n);
        }

        public int getNumberOfProperties() {
            return this.propMap.size();
        }

        public int propertyNumber(String string) throws IllegalArgumentException {
            return this.validatePropName(string);
        }

        int validatePropName(String string) throws IllegalArgumentException {
            if (!string.startsWith(this.getBasePropertyName() + ".")) {
                throw new IllegalArgumentException("propName = " + string + " passed does not match base prop name of " + this.getBasePropertyName());
            }
            if (string.endsWith(".")) {
                throw new IllegalArgumentException("propName = " + string + " passed must end with a pattern .<number>");
            }
            String string2 = string.substring(string.lastIndexOf(".") + 1);
            int n = 0;
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("propName = " + string + " passed must end with a pattern .<number>");
            }
            return n;
        }

        void add(String string, String string2) throws IllegalArgumentException {
            this.validatePropName(string);
            this.propMap.put(string, string2);
        }

        String remove(String string) {
            return (String)this.propMap.remove(string);
        }
    }
}

