/** 
 (C) Copyright IBM Corporation 2006
 DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
 sample code created by IBM Corporation. This sample code is not
 part of any standard or IBM product and is provided to you solely
 for  the purpose of assisting you in the development of your
 applications.  The code is provided "AS IS", without
 warranty of any kind.  IBM shall not be liable for any damages
 arising out of your use of the sample code, even if they have been
 advised of the possibility of such damages.
 */

package com.ibm.jpos.tools.sdicc.demo;

import java.awt.Dimension;
import java.awt.Toolkit;

import javax.swing.JFrame;

import jpos.JposConst;
import jpos.JposException;
import jpos.LineDisplay;
import jpos.LineDisplayConst;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;

/** 
 * LineDisplayDemo class implements a demo 
 * for the basic functionality of the LineDisplay
 * @author 
 * */

public class LineDisplayDemo implements DeviceDemo, StatusUpdateListener
{

    //-------------------------------------------------------------------------
    // public methods
    //

    /**
     * main method creates a GUI to try LineDisplayDemo  
     **/

    public static void main(String args[])
    {
        // main needs one logical name as argument 
        if (args.length != 1)
        {
            System.out.println("Usage : \n" +
            "java com.ibm.jpos.tools.sdicc.demo.LineDisplayDemo <logicalName>");
            return;
        }
        //create this class that encapsulate the  jpos.LineDisplay functionality
        DeviceDemo devDemo = new LineDisplayDemo();
        //create the UI for this demo
        DemoUI demoUI = new DemoUI(args, devDemo);
        //Add the ui to a JFrame
        JFrame mainWindow = new JFrame("LineDisplayDemo");
        mainWindow.setContentPane(demoUI);
        mainWindow.setSize(700,400);
        //Center the Frame
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenSize.width - mainWindow.getSize().width) / 2;
        int y = (screenSize.height - mainWindow.getSize().height) / 2;
        mainWindow.setLocation(x, y);
        mainWindow.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        mainWindow.setVisible(true);
    }

    /**
     * @return a bidimensional arrays of strings
     *         the first array has the button labels
     *         the seccond array has the tooltips for those buttons 
     * */
    public String[][] getButtonLabels()
    {
        return new String[][]
        {
        { TEXT_LD_TEST },
        { TOOLTIP_TEXT_LD_TEST } };

    }

    /** 
     * @return the devCat for this device
     */
    public String getDevCat()
    {
        return "LineDisplay";
    }

    /**
     * @param demoUI the ui to be used for this demo 
     * */
    public void setUI(DemoUI demoUI)
    {
        ui = demoUI;
    }

    /**
     * @param button the button that was pressed
     */
    public void buttonPressed(String button) throws JposException
    {
        if (button.equals(TEXT_LD_TEST))
        {
            // start the device test
            doStartDeviceTest();
        }

    }

    /**
     * implementation of statusUpdateListener interface it is called when the
     * status of the device is updated
     * 
     * @param e
     *            the event generated by the device
     */
    public void statusUpdateOccurred(StatusUpdateEvent e)
    {
        int status = e.getStatus();

        String statusMsg = "StatusUpdateOccurred - ";
        switch (status)
        {
            case JposConst.JPOS_SUE_POWER_ONLINE:
                statusMsg += "JPOS_SUE_POWER_ONLINE";
                break;

            case JposConst.JPOS_SUE_POWER_OFF_OFFLINE:
            case JposConst.JPOS_SUE_POWER_OFFLINE:
                statusMsg += "JPOS_SUE_POWER_OFF_OFFLINE";
                break;

        }
        //display the status update received
        ui.displayText(statusMsg);

    }

    //-------------------------------------------------------------------------
    // UPOS Functionality
    //

    //-------------------------------------------------------------------------
    // Protected Methods
    //

    /**
     * open claim and enable the device, display some properties
     * and open the LineDisplay
     * */
    protected void doStartDeviceTest() throws JposException
    {
        ld.open(ui.getLogicalName());
        ui.displayText("Open(\"" + ui.getLogicalName() + "\")");
        try{
            // Common Properties
            ui.displayText("DeviceControlVersion = "
                    + ld.getDeviceControlVersion());
            ui.displayText("DeviceControlDescription = "
                    + ld.getDeviceControlDescription());
            ui.displayText("DeviceServiceVersion = "
                    + ld.getDeviceServiceVersion());
            ui.displayText("DeviceServiceDescription = "
                    + ld.getDeviceServiceDescription());
            ui.displayText("CapCompareFirmwareVersion = " + 
                    ld.getCapCompareFirmwareVersion());
            String capPowerReportingName = "";
            switch(ld.getCapPowerReporting())
            {
                case JposConst.JPOS_PR_NONE:
                    capPowerReportingName += "JPOS_PR_NONE = ";
                    break;
                case JposConst.JPOS_PR_STANDARD:
                    capPowerReportingName += "JPOS_PR_STANDARD = ";
                    break;
                case JposConst.JPOS_PR_ADVANCED:
                    capPowerReportingName += "JPOS_PR_ADVANCED = ";
                    break;
            }
            ui.displayText("CapPowerReporting = "+ capPowerReportingName + 
                    ld.getCapPowerReporting());
            ui.displayText("CapStatisticsReporting = " + 
                    ld.getCapStatisticsReporting());
            ui.displayText("CapUpdateFirmware = " + ld.getCapUpdateFirmware());
            ui.displayText("CapUpdateStatistics = " + 
                    ld.getCapUpdateStatistics());
            ld.addStatusUpdateListener(this);
            ui.displayText("addStatusUpdateListener(this)");
            
            if( ld.getCapPowerReporting() != JposConst.JPOS_PR_NONE)
            {
                ld.setPowerNotify(JposConst.JPOS_PN_ENABLED);
                ui.displayText("PowerNotify = JPOS_PN_ENABLED");
            }
            
            // Specific Properties
            ui.displayText("CapDescriptors = " + ld.getCapDescriptors());
            String capBlink = "";
            switch(ld.getCapBlink())
            {
                case LineDisplayConst.DISP_CB_BLINKALL:
                    capBlink = "DISP_CB_BLINKALL = ";
                    break;
                case LineDisplayConst.DISP_CB_BLINKEACH:
                    capBlink = "DISP_CB_BLINKEACH = ";
                    break;
                case LineDisplayConst.DISP_CB_NOBLINK:
                    capBlink = "DISP_CB_NOBLINK = ";
                    break;
            }
            ui.displayText("CapBlink = " + capBlink +  
                    ld.getCapBlink());
            ld.claim(1000);
            ui.displayText("Claim(1000)");
            ld.setDeviceEnabled(true);
            ui.displayText("setDeviceEnabled(true)");
            ld.clearText();
            ui.displayText("clearText()");
            ld.displayText("data in line 1      ", 
                    jpos.LineDisplayConst.DISP_DT_NORMAL);
            ui.displayText("displayText(\"data in line 1      \",DISP_DT_NORMAL)");
            ld.displayText("data in line 2      ", 
                    jpos.LineDisplayConst.DISP_DT_NORMAL);
            ui.displayText("displayText(\"data in line 2      \",DISP_DT_NORMAL)");

            // clear device, display text & do descriptors
            if( ld.getCapDescriptors() == true )
            {
                if( ld.getCapBlink() != LineDisplayConst.DISP_CB_NOBLINK)
                {
                    ld.setDescriptor(0,LineDisplayConst.DISP_SD_BLINK);
                    ui.displayText("setDescriptors(0,DISP_SD_ON)");
                }
                else
                {
                    ld.setDescriptor(0,LineDisplayConst.DISP_SD_ON);
                    ui.displayText("setDescriptors(0,DISP_SD_ON)");
                }
            }
        }
        finally
        {
            ld.close();
            ui.displayText("close()");
        }
    }

    //-------------------------------------------------------------------------
    // instance variables
    //
    private LineDisplay ld = new LineDisplay();
    private static DemoUI ui;

    //-------------------------------------------------------------------------
    // constants
    //
    /** Label for Start Button */
    private static final String TEXT_LD_TEST = "Start LineDisplay Test";

    /** tool tip text for Start button */
    private static final String TOOLTIP_TEXT_LD_TEST = 
        "Open, claim and enable the LineDisplay "
            + "Use Descriptors if device support it "
            + "Display \"blink\" text if device support it "
            + "Display text in both rows";
}
