/*      (C) Copyright IBM Corporation 2006                                   */
/*                                                                           */
/*      DISCLAIMER OF WARRANTIES.  The following [enclosed] code is          */
/*      sample code created by IBM Corporation. This sample code is not      */
/*      part of any standard or IBM product and is provided to you solely    */
/*      for  the purpose of assisting you in the development of your         */
/*      applications.  The code is provided "AS IS", without                 */
/*      warranty of any kind.  IBM shall not be liable for any damages       */
/*      arising out of your use of the sample code, even if they have been   */
/*      advised of the possibility of such damages.                          */

package com.ibm.jpos.tools.sdicc.demo;

import java.awt.Dimension;
import java.awt.Toolkit;

import javax.swing.JFrame;

import jpos.events.OutputCompleteEvent;
import jpos.JposConst;
import jpos.JposException;
import jpos.ToneIndicator;
import jpos.events.OutputCompleteListener;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;


/** 
 * ToneIndicatorDemo class implements a demo 
 * for the basic functionality of the ToneIndicator
 * @author 
 * */

public class ToneIndicatorDemo 
    implements DeviceDemo, StatusUpdateListener, OutputCompleteListener
{

    //-------------------------------------------------------------------------
    // public methods
    //

    /**
     * main method creates a GUI to try ToneIndicatorDemo  
     **/

    public static void main(String args[])
    {
        // main needs one logical name as argument 
        if (args.length != 1)
        {
            System.out.println("Usage : \n" +
            "java com.ibm.jpos.tools.sdicc.demo.ToneIndicatorDemo <logicalName>");
            return;
        }
        // Create this class that encapsulate the jpos.ToneIndicator 
        // functionality
        DeviceDemo devDemo = new ToneIndicatorDemo();
        //create the UI for this demo
        DemoUI demoUI = new DemoUI(args, devDemo);
        //Add the ui to a JFrame
        JFrame mainWindow = new JFrame("ToneIndicatorDemo");
        mainWindow.setContentPane(demoUI);
        mainWindow.setSize(700,500);
        //Center the Frame
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        
        int x = (screenSize.width - mainWindow.getSize().width) / 2;
        int y = (screenSize.height - mainWindow.getSize().height) / 2;
        mainWindow.setLocation(x, y);
        mainWindow.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        mainWindow.setVisible(true);

    }

    /**
     * @return a bidimensional arrays of strings
     *         the first array has the button labels
     *         the seccond array has the tooltips for those buttons 
     * */
    public String[][] getButtonLabels()
    {
        return new String[][]
        {
        { TEXT_TONE_TEST },
        { TOOLTIP_TEXT_TONE_TEST } };

    }

    /** 
     * @return the devCat for this device
     */
    public String getDevCat()
    {
        return "ToneIndicator";
    }

    /**
     * @param demoUI the ui to be used for this demo 
     * */
    public void setUI(DemoUI demoUI)
    {
        ui = demoUI;
    }

    /**
     * @param button the button that was pressed
     */
    public void buttonPressed(String button) throws JposException
    {
        if (button.equals(TEXT_TONE_TEST))
        {
            // start the device test
            doStartDeviceTest();
        }

    }

    /**
     * implementation of statusUpdateListener interface it is called when the
     * status of the device is updated
     * 
     * @param e
     *            the event generated by the device
     */
    public void statusUpdateOccurred(StatusUpdateEvent e)
    {
        int status = e.getStatus();

        String statusMsg = "StatusUpdateOccurred - ";
        switch (status)
        {
            case JposConst.JPOS_SUE_POWER_ONLINE:
                statusMsg += "JPOS_SUE_POWER_ONLINE";
                break;

            case JposConst.JPOS_SUE_POWER_OFF_OFFLINE:
            case JposConst.JPOS_SUE_POWER_OFFLINE:
                statusMsg += "JPOS_SUE_POWER_OFF_OFFLINE";
                break;

        }
        //display the status update received
        ui.displayText(statusMsg);

    }

    public void outputCompleteOccurred(OutputCompleteEvent out)     
    {
        synchronized( lockObj ) { lockObj.notifyAll(); }
    }

    //-------------------------------------------------------------------------
    // UPOS Functionality
    //

    //-------------------------------------------------------------------------
    // Protected Methods
    //

    /**
     * open claim and enable the device, display some properties
     * and open the ToneIndicator
     * */
    protected void doStartDeviceTest() throws JposException
    {

        tone.open(ui.getLogicalName());
        ui.displayText("Open(\"" + ui.getLogicalName() + "\")");
        try{
            
            // Common Cap/Properties
            ui.displayText("DeviceControlVersion = "
                    + tone.getDeviceControlVersion());
            ui.displayText("DeviceControlDescription = "
                    + tone.getDeviceControlDescription());
            ui.displayText("DeviceServiceVersion = "
                    + tone.getDeviceServiceVersion());
            ui.displayText("DeviceServiceDescription = "
                    + tone.getDeviceServiceDescription());
            ui.displayText("CapCompareFirmwareVersion = " + 
                    tone.getCapCompareFirmwareVersion());
            String capPowerReportingName = "";
            switch(tone.getCapPowerReporting())
            {
                case JposConst.JPOS_PR_NONE:
                    capPowerReportingName += "JPOS_PR_NONE = ";
                    break;
                case JposConst.JPOS_PR_STANDARD:
                    capPowerReportingName += "JPOS_PR_STANDARD = ";
                    break;
                case JposConst.JPOS_PR_ADVANCED:
                    capPowerReportingName += "JPOS_PR_ADVANCED = ";
                    break;
            }
            ui.displayText("CapPowerReporting = "+ capPowerReportingName + 
                    tone.getCapPowerReporting());
            ui.displayText("CapStatisticsReporting = " + 
                    tone.getCapStatisticsReporting());
            ui.displayText("CapUpdateFirmware = " +
                    tone.getCapUpdateFirmware());
            ui.displayText("CapUpdateStatistics = " + 
                    tone.getCapUpdateStatistics());
            tone.claim(1000);
            ui.displayText("Claim(1000)");
            tone.setDeviceEnabled(true);
            ui.displayText("setDeviceEnabled(true)");
            // Specific Cap/Properties
            tone.setTone1Duration( 500 );
            ui.displayText("setTone1Duration(500)");
            tone.setTone1Pitch( 500 );
            ui.displayText("setTone1Pitch(500)");
            tone.setTone1Volume( 10 );
            ui.displayText("setTone1Volume(10)");
            tone.setInterToneWait( 500 );
            ui.displayText("setInterToneWait(500)");
            tone.setTone2Duration( 500 );
            ui.displayText("setTone2Duration(500)");            
            tone.setTone2Pitch( 2000 );
            ui.displayText("setTone2Pitch(2000)");
            tone.setTone2Volume( 100 );
            ui.displayText("setTone2Volume(100)");
            ui.displayText("getAsyncMode()=" + tone.getAsyncMode());
            tone.sound(1,100);
            ui.displayText("tone.sound(1,100)");
            tone.addOutputCompleteListener(this);
            ui.displayText("tone.addOutputCompleteListener(this)");
            tone.setAsyncMode(true);
            ui.displayText("setAsyncMode(true)");
            ui.displayText("getAsyncMode()=" + tone.getAsyncMode());

            synchronized( lockObj )
            {
                tone.sound(1,100);
                ui.displayText("tone.sound(1,100)");
                try{lockObj.wait();}catch(InterruptedException ie){}
            }
            ui.displayText("getOutputID()=" + tone.getOutputID());
        }
        finally
        {
            tone.close();
            ui.displayText("close()");
        }
    }

    //-------------------------------------------------------------------------
    // instance variables
    //
    protected Object lockObj = new Object();
    private ToneIndicator tone = new ToneIndicator();
    private static DemoUI ui;

    //-------------------------------------------------------------------------
    // constants
    //
    /** Label for Start Button */
    private static final String TEXT_TONE_TEST = "Start ToneIndicator Test";

    /** tool tip text for Start button */
    private static final String TOOLTIP_TEXT_TONE_TEST = 
        "Open, claim and enable the ToneIndicator "
            + "Display Tone sound init values. "
            + "Sound tone in synchronous mode. " 
            + "Sound tone in asynchronous mode. ";
}
