/** 
 (C) Copyright IBM Corporation 2006
 DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
 sample code created by IBM Corporation. This sample code is not
 part of any standard or IBM product and is provided to you solely
 for  the purpose of assisting you in the development of your
 applications.  The code is provided "AS IS", without
 warranty of any kind.  IBM shall not be liable for any damages
 arising out of your use of the sample code, even if they have been
 advised of the possibility of such damages.
 */

package com.ibm.jpos.tools.sdicc.demo;

import java.awt.Dimension;
import java.awt.Toolkit;

import javax.swing.JFrame;

import jpos.JposConst;
import jpos.JposException;
import jpos.POSPrinter;
import jpos.POSPrinterConst;
import jpos.events.StatusUpdateEvent;
import jpos.events.StatusUpdateListener;

/** 
 * POSPrinterDemo class implements a demo 
 * for the basic functionality of the POSPrinter
 * @author 
 * */

public class POSPrinterDemo implements DeviceDemo, StatusUpdateListener
{

    //-------------------------------------------------------------------------
    // public methods
    //

    /**
     * main method creates a GUI to try POSPrinterDemo  
     **/

    public static void main(String args[])
    {
        // main needs one logical name as argument 
        if (args.length != 1)
        {
            System.out.println("Usage : \n" +
            "java com.ibm.jpos.tools.sdicc.demo.POSPrinterDemo <logicalName>");
            return;
        }
        //create this class that encapsulate the  jpos.POSPrinter functionality
        DeviceDemo devDemo = new POSPrinterDemo();
        //create the UI for this demo
        DemoUI demoUI = new DemoUI(args, devDemo);
        //Add the ui to a JFrame
        JFrame mainWindow = new JFrame("POSPrinterDemo");
        mainWindow.setContentPane(demoUI);
        mainWindow.setSize(700,500);
        //Center the Frame
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenSize.width - mainWindow.getSize().width) / 2;
        int y = (screenSize.height - mainWindow.getSize().height) / 2;
        mainWindow.setLocation(x, y);
        mainWindow.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        mainWindow.setVisible(true);

    }

    /**
     * @return a bidimensional arrays of strings
     *         the first array has the button labels
     *         the seccond array has the tooltips for those buttons 
     * */
    public String[][] getButtonLabels()
    {
        return new String[][]
        {
        { TEXT_PTR_REC, TEXT_PTR_SLP },
        { TOOLTIP_TEXT_PTR_REC, TOOLTIP_TEXT_PTR_SLP }
        };

    }

    /** 
     * @return the devCat for this device
     */
    public String getDevCat()
    {
        return "POSPrinter";
    }

    /**
     * @param demoUI the ui to be used for this demo 
     * */
    public void setUI(DemoUI demoUI)
    {
        ui = demoUI;
    }

    /**
     * @param button the button that was pressed
     */
    public void buttonPressed(String button) throws JposException
    {
        if (button.equals(TEXT_PTR_REC))
        {
            // start the device test
        	doStartDeviceTest(REC_TEST);
        }
        else
        	doStartDeviceTest(SLP_TEST);
    }

    /**
     * implementation of statusUpdateListener interface it is called when the
     * status of the device is updated
     * 
     * @param e
     *            the event generated by the device
     */
    public void statusUpdateOccurred(StatusUpdateEvent e)
    {
    	boolean printStatus = false;
        int status = e.getStatus();

    	//Note: not all the status are going to be printed
    	// in the text area, just the most relevant
        String statusMsg = "StatusUpdateOccurred - ";
        switch (status)
        {
            case JposConst.JPOS_SUE_POWER_ONLINE:
                statusMsg += "JPOS_SUE_POWER_ONLINE";
                printStatus = true;
                break;

            case JposConst.JPOS_SUE_POWER_OFF_OFFLINE:
            case JposConst.JPOS_SUE_POWER_OFFLINE:
                statusMsg += "JPOS_SUE_POWER_OFF_OFFLINE";
                printStatus = true;
                break;
                
            case POSPrinterConst.PTR_SUE_IDLE:
                statusMsg += "PTR_SUE_IDLE";
                printStatus = true;
                break;
            case POSPrinterConst.PTR_SUE_REC_COVER_OK:
                statusMsg += "PTR_SUE_REC_COVER_OK";
                printStatus = true;
                break;
            case POSPrinterConst.PTR_SUE_REC_COVER_OPEN:
                statusMsg += "PTR_SUE_REC_COVER_OPEN";
                printStatus = true;
                break;
            case POSPrinterConst.PTR_SUE_SLP_COVER_OK:
                statusMsg += "PTR_SUE_SLP_COVER_OK";
                printStatus = true;
                break;
            case POSPrinterConst.PTR_SUE_SLP_COVER_OPEN:
                statusMsg += "PTR_SUE_SLP_COVER_OPEN";
                printStatus = true;
                break;
            case POSPrinterConst.PTR_SUE_SLP_EMPTY:
                statusMsg += "PTR_SUE_SLP_EMPTY";
                printStatus = true;
                break;
            case POSPrinterConst.PTR_SUE_SLP_PAPEROK:
                statusMsg += "PTR_SUE_SLP_PAPEROK";
                printStatus = true;
                break;
        }
        //display the status update received
        if( printStatus )
        	ui.displayText(statusMsg);

    }

    //-------------------------------------------------------------------------
    // UPOS Functionality
    //

    //-------------------------------------------------------------------------
    // Protected Methods
    //

    /**
     * open claim and enable the device, display some properties 
     */
    protected void doStartDeviceTest(int test) throws JposException
    {

        ptr.open(ui.getLogicalName());
        ui.displayText("Open(\"" + ui.getLogicalName() + "\")");
        ptr.addStatusUpdateListener(this);
        ui.displayText("addStatusUpdateListener(this)");
        try{
            // Common Cap/Properties
            ui.displayText("DeviceControlVersion = "
                    + ptr.getDeviceControlVersion());
            ui.displayText("DeviceControlDescription = "
                    + ptr.getDeviceControlDescription());
            ui.displayText("DeviceServiceVersion = "
                    + ptr.getDeviceServiceVersion());
            ui.displayText("DeviceServiceDescription = "
                    + ptr.getDeviceServiceDescription());
            ui.displayText("CapCompareFirmwareVersion = " + 
                    ptr.getCapCompareFirmwareVersion());
            String capPowerReportingName = "";
            switch(ptr.getCapPowerReporting())
            {
                case JposConst.JPOS_PR_NONE:
                    capPowerReportingName += "JPOS_PR_NONE = ";
                    break;
                case JposConst.JPOS_PR_STANDARD:
                    capPowerReportingName += "JPOS_PR_STANDARD = ";
                    break;
                case JposConst.JPOS_PR_ADVANCED:
                    capPowerReportingName += "JPOS_PR_ADVANCED = ";
                    break;
            }
            ui.displayText("CapPowerReporting = "+ capPowerReportingName + 
                    ptr.getCapPowerReporting());
            ui.displayText("CapStatisticsReporting = " + 
                    ptr.getCapStatisticsReporting());
            ui.displayText("CapUpdateFirmware = " +ptr.getCapUpdateFirmware());
            ui.displayText("CapUpdateStatistics = " + 
                    ptr.getCapUpdateStatistics());
            // Specific Cap/Properties
            ui.displayText("CapCapRecPresent = " +ptr.getCapRecPresent());
            ui.displayText("CapCapRecBarcode = " +ptr.getCapRecBarCode());
            ui.displayText("CapCapRecBitmap = " +ptr.getCapRecBitmap());
            ui.displayText("CapCapSlpPresent = " +ptr.getCapSlpPresent());
            ui.displayText("CapCapSlpBarcode = " +ptr.getCapSlpBarCode());
            ui.displayText("CapCapSlpBitmap = " +ptr.getCapSlpBitmap());
            ptr.claim(1000);
            ui.displayText("Claim(1000)");
            ptr.setDeviceEnabled(true);
            ui.displayText("SetDeviceEnabled(true)");  
            if( test == REC_TEST)
            	ticketTest();
            else
            	frankTest();          	
        }
        finally
        {
        	ptr.removeStatusUpdateListener(this);
            ui.displayText("removeStatusUpdateListener(this)");
            ptr.close();
            ui.displayText("close()");
        }
    }
    
    protected void ticketTest()throws JposException
    {
        
    	ui.displayText("#\n# Printing a ticket sample in Receipt station...\n#");
        ptr.setAsyncMode(false);
        ptr.setRecLineChars(32);
        ptr.setBitmap(1,receipt,
                "com/ibm/jpos/res/images/ibm-logo.gif",
                300,
                POSPrinterConst.PTR_BM_CENTER);
        ptr.transactionPrint(receipt,POSPrinterConst.PTR_TP_TRANSACTION);
        ptr.printNormal(receipt,"\u001b|1B");
        ptr.printNormal(receipt,"\u001b|N\u001b|bC\u001b|3C\u001b|cATICKET STORE\n");
        ptr.printNormal(receipt,"\u001b|N\u001b|cAMMM/DD/YY  HH:MM\n\n");
        ptr.printNormal(receipt,"\u001b|bCStore Number:\u001b|N 8888\n");
        ptr.printNormal(receipt,"\u001b|bCSeller:\u001b|N Your Name\n\n");
        ptr.printNormal(receipt,"\u001b|N\u001b|uCDescription\u001b|cANo.Items\u001b|rASub-Total\n");
        ptr.printNormal(receipt,"\u001b|NComputer IBM\u001b|cA1\u001b|bC\u001b|rA433.90\n");
        ptr.printNormal(receipt,"\u001b|NLaptop IBM\u001b|cA1\u001b|bC\u001b|rA689.70\n");
        ptr.printNormal(receipt,"\u001b|N\u001b|bC\u001b|2vCTOTAL AMOUNT\u001b|rA1123.60\n\n");
        ptr.printNormal(receipt,"\u001b|NCreditCard (####-####-####-####)\n");
        ptr.printNormal(receipt,"\u001b|N\u001b|bC\u001b|2vCAmount in Charge\u001b|rA1123.60\n\n");
        ptr.printNormal(receipt,"\u001b|cA(  # sold items:   2 )\n");        
        ptr.printNormal(receipt,"\u001b|cAINCLUDED TAXES\n");
        ptr.printBarCode(receipt,
                "75010173943",
                POSPrinterConst.PTR_BCS_UPCA,
                100,
                432,
                POSPrinterConst.PTR_BC_CENTER,
                POSPrinterConst.PTR_BC_TEXT_BELOW);
        ptr.printNormal(receipt,"\u001b|bC\u001b|cAThis ticket is needed in order");
        ptr.printNormal(receipt,"\u001b|bC\u001b|cAto do any kind of change,");
        ptr.printNormal(receipt,"\u001b|bC\u001b|cAaclaration or devolution\n\n");
        ptr.printNormal(receipt,"\u001b|cA THANKS FOR YOUR PREFERENCE\n\n");
        ptr.printBitmap(receipt,
                "com/ibm/jpos/res/images/ibm-logo.gif",
                POSPrinterConst.PTR_BM_ASIS,
                POSPrinterConst.PTR_BM_CENTER);
        ptr.printNormal(receipt,"\u001b|95fP");
        ptr.transactionPrint(receipt,POSPrinterConst.PTR_TP_NORMAL);
    	
    }
    
    protected void frankTest() throws JposException   
    {
    	if( !ptr.getCapSlpPresent() )
    	{
    		ui.displayText("#\n# There is no SLIP station on this printer...\n#");
    		return;
    	}    		
    	if( ptr.getSlpEmpty() )
    	{
    		ui.displayText("#\n# There is no paper on SLIP station...\n#");
    		return;    		
    	}
        ptr.setAsyncMode(false);
        ptr.setCharacterSet(CHAR_SET_ASCII);
        ptr.beginInsertion(3000);
        ptr.endInsertion();
        ptr.printNormal(slip,"\u001b|bC          For Deposit Only\n");
        ptr.printNormal(slip,"          Acct: 123456780 1234567890\n");
        ptr.printNormal(slip,"          ID#:  1234567890\n");
        ptr.printNormal(slip,"\u001b|bC          Amount: 1.00  Sale Amt:  4.85\n");
        ptr.printNormal(slip,"          Ref#  0001\n");
        ptr.printNormal(slip,"          000431 MMDDYY HH:MM 021/37/0177\n");
        try{
        ptr.beginRemoval(4000);
        ptr.endRemoval();
        }catch(JposException jp)
        {
        	if( jp.getErrorCode() == JposConst.JPOS_E_TIMEOUT)
        	{
        		ui.displayText("#\n# Remove the paper from SLIP station...\n#");
        	}
        	else
        		throw jp;
        }
    }
    
    //-------------------------------------------------------------------------
    // Private Methods
    //

    //-------------------------------------------------------------------------
    // instance variables
    //
    private POSPrinter ptr = new POSPrinter();
    private static DemoUI ui;
    private static final int receipt = POSPrinterConst.PTR_S_RECEIPT;
    private static final int slip = POSPrinterConst.PTR_S_SLIP;
    private int REC_TEST = 1;
    private int SLP_TEST = 2;
    private int CHAR_SET_ASCII = 998;

    //-------------------------------------------------------------------------
    // constants
    //
    /** Label for Start Button */
    private static final String TEXT_PTR_REC = "Print Receipt Test";
    private static final String TEXT_PTR_SLP = "Frank Check Test";

    /** tool tip text for Start button */
    private static final String TOOLTIP_TEXT_PTR_REC =
        "Open, claim and enable the POSPrinter "
            + "and print a receipt example";
    private static final String TOOLTIP_TEXT_PTR_SLP = 
        "Open, claim and enable the POSPrinter "
            + "and frank a check";



}
