/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jdt.internal.junit.JUnitCorePlugin;
import org.eclipse.jdt.internal.junit.model.ITestRunListener2;

public class RemoteTestRunnerClient {
    private final StringBuffer fFailedTrace = new StringBuffer();
    private final StringBuffer fExpectedResult = new StringBuffer();
    private final StringBuffer fActualResult = new StringBuffer();
    private final StringBuffer fFailedRerunTrace = new StringBuffer();
    ProcessingState fDefaultState = new DefaultProcessingState();
    ProcessingState fTraceState = new TraceProcessingState();
    ProcessingState fExpectedState = new AppendingProcessingState(this.fExpectedResult, "%EXPECTE");
    ProcessingState fActualState = new AppendingProcessingState(this.fActualResult, "%ACTUALE");
    ProcessingState fRerunState = new AppendingProcessingState(this.fFailedRerunTrace, "%RTRACEE");
    ProcessingState fCurrentState = this.fDefaultState;
    private ITestRunListener2[] fListeners;
    private ServerSocket fServerSocket;
    private Socket fSocket;
    private int fPort = -1;
    private PrintWriter fWriter;
    private BufferedReader fBufferedReader;
    private String fVersion;
    private String fFailedTest;
    private String fFailedTestId;
    private int fFailureKind;
    private boolean fDebug = false;

    public synchronized void startListening(ITestRunListener2[] listeners, int port) {
        this.fListeners = listeners;
        this.fPort = port;
        ServerConnection connection = new ServerConnection(port);
        connection.start();
    }

    public synchronized void stopTest() {
        if (this.isRunning()) {
            this.fWriter.println(">STOP   ");
            this.fWriter.flush();
        }
    }

    public synchronized void stopWaiting() {
        if (this.fServerSocket != null && !this.fServerSocket.isClosed() && this.fSocket == null) {
            this.shutDown();
        }
    }

    private synchronized void shutDown() {
        if (this.fDebug) {
            System.out.println("shutdown " + this.fPort);
        }
        if (this.fWriter != null) {
            this.fWriter.close();
            this.fWriter = null;
        }
        try {
            if (this.fBufferedReader != null) {
                this.fBufferedReader.close();
                this.fBufferedReader = null;
            }
        }
        catch (IOException iOException) {}
        try {
            if (this.fSocket != null) {
                this.fSocket.close();
                this.fSocket = null;
            }
        }
        catch (IOException iOException) {}
        try {
            if (this.fServerSocket != null) {
                this.fServerSocket.close();
                this.fServerSocket = null;
            }
        }
        catch (IOException iOException) {}
    }

    public boolean isRunning() {
        return this.fSocket != null;
    }

    private String readMessage(BufferedReader in) throws IOException {
        return in.readLine();
    }

    private void receiveMessage(String message) {
        this.fCurrentState = this.fCurrentState.readMessage(message);
    }

    private void scanOldReranMessage(String arg) {
        int c = arg.indexOf(" ");
        int t = arg.indexOf(" ", c + 1);
        String className = arg.substring(0, c);
        String testName = arg.substring(c + 1, t);
        String status = arg.substring(t + 1);
        String testId = String.valueOf(className) + testName;
        this.notifyTestReran(testId, className, testName, status);
    }

    private void scanReranMessage(String arg) {
        int i = arg.indexOf(32);
        int c = arg.indexOf(32, i + 1);
        int t = arg.indexOf(32, c + 1);
        String testId = arg.substring(0, i);
        String className = arg.substring(i + 1, c);
        String testName = arg.substring(c + 1, t);
        String status = arg.substring(t + 1);
        this.notifyTestReran(testId, className, testName, status);
    }

    private void notifyTestReran(String testId, String className, String testName, String status) {
        int statusCode = 0;
        if (status.equals("FAILURE")) {
            statusCode = 2;
        } else if (status.equals("ERROR")) {
            statusCode = 1;
        }
        String trace = "";
        if (statusCode != 0) {
            trace = this.fFailedRerunTrace.toString();
        }
        this.notifyTestReran(testId, className, testName, statusCode, trace);
    }

    private void extractFailure(String arg, int status) {
        String[] s = this.extractTestId(arg);
        this.fFailedTestId = s[0];
        this.fFailedTest = s[1];
        this.fFailureKind = status;
    }

    String[] extractTestId(String arg) {
        String[] result = new String[2];
        if (!this.hasTestId()) {
            result[0] = arg;
            result[1] = arg;
            return result;
        }
        int i = arg.indexOf(44);
        result[0] = arg.substring(0, i);
        result[1] = arg.substring(i + 1, arg.length());
        return result;
    }

    private boolean hasTestId() {
        if (this.fVersion == null) {
            return true;
        }
        return this.fVersion.equals("v2");
    }

    private void notifyTestReran(final String testId, final String className, final String testName, final int statusCode, final String trace) {
        int i = 0;
        while (i < this.fListeners.length) {
            final ITestRunListener2 listener = this.fListeners[i];
            SafeRunner.run((ISafeRunnable)new ListenerSafeRunnable(){

                public void run() {
                    listener.testReran(testId, className, testName, statusCode, trace, RemoteTestRunnerClient.this.fExpectedResult.toString(), RemoteTestRunnerClient.this.fActualResult.toString());
                }
            });
            ++i;
        }
    }

    private void notifyTestTreeEntry(String treeEntry) {
        int i = 0;
        while (i < this.fListeners.length) {
            ITestRunListener2 listener = this.fListeners[i];
            if (!this.hasTestId()) {
                listener.testTreeEntry(this.fakeTestId(treeEntry));
            } else {
                listener.testTreeEntry(treeEntry);
            }
            ++i;
        }
    }

    private String fakeTestId(String treeEntry) {
        int index0 = treeEntry.indexOf(44);
        String testName = treeEntry.substring(0, index0).trim();
        return String.valueOf(testName) + "," + treeEntry;
    }

    private void notifyTestRunStopped(final long elapsedTime) {
        if (JUnitCorePlugin.isStopped()) {
            return;
        }
        int i = 0;
        while (i < this.fListeners.length) {
            final ITestRunListener2 listener = this.fListeners[i];
            SafeRunner.run((ISafeRunnable)new ListenerSafeRunnable(){

                public void run() {
                    listener.testRunStopped(elapsedTime);
                }
            });
            ++i;
        }
    }

    private void testRunEnded(final long elapsedTime) {
        if (JUnitCorePlugin.isStopped()) {
            return;
        }
        int i = 0;
        while (i < this.fListeners.length) {
            final ITestRunListener2 listener = this.fListeners[i];
            SafeRunner.run((ISafeRunnable)new ListenerSafeRunnable(){

                public void run() {
                    listener.testRunEnded(elapsedTime);
                }
            });
            ++i;
        }
    }

    private void notifyTestEnded(final String test) {
        if (JUnitCorePlugin.isStopped()) {
            return;
        }
        int i = 0;
        while (i < this.fListeners.length) {
            final ITestRunListener2 listener = this.fListeners[i];
            SafeRunner.run((ISafeRunnable)new ListenerSafeRunnable(){

                public void run() {
                    String[] s = RemoteTestRunnerClient.this.extractTestId(test);
                    listener.testEnded(s[0], s[1]);
                }
            });
            ++i;
        }
    }

    private void notifyTestStarted(final String test) {
        if (JUnitCorePlugin.isStopped()) {
            return;
        }
        int i = 0;
        while (i < this.fListeners.length) {
            final ITestRunListener2 listener = this.fListeners[i];
            SafeRunner.run((ISafeRunnable)new ListenerSafeRunnable(){

                public void run() {
                    String[] s = RemoteTestRunnerClient.this.extractTestId(test);
                    listener.testStarted(s[0], s[1]);
                }
            });
            ++i;
        }
    }

    private void notifyTestRunStarted(final int count) {
        if (JUnitCorePlugin.isStopped()) {
            return;
        }
        int i = 0;
        while (i < this.fListeners.length) {
            final ITestRunListener2 listener = this.fListeners[i];
            SafeRunner.run((ISafeRunnable)new ListenerSafeRunnable(){

                public void run() {
                    listener.testRunStarted(count);
                }
            });
            ++i;
        }
    }

    private void notifyTestFailed() {
        if (JUnitCorePlugin.isStopped()) {
            return;
        }
        int i = 0;
        while (i < this.fListeners.length) {
            final ITestRunListener2 listener = this.fListeners[i];
            SafeRunner.run((ISafeRunnable)new ListenerSafeRunnable(){

                public void run() {
                    listener.testFailed(RemoteTestRunnerClient.this.fFailureKind, RemoteTestRunnerClient.this.fFailedTestId, RemoteTestRunnerClient.this.fFailedTest, RemoteTestRunnerClient.this.fFailedTrace.toString(), RemoteTestRunnerClient.this.fExpectedResult.toString(), RemoteTestRunnerClient.this.fActualResult.toString());
                }
            });
            ++i;
        }
    }

    private void notifyTestRunTerminated() {
        if (JUnitCorePlugin.isStopped()) {
            return;
        }
        int i = 0;
        while (i < this.fListeners.length) {
            final ITestRunListener2 listener = this.fListeners[i];
            SafeRunner.run((ISafeRunnable)new ListenerSafeRunnable(){

                public void run() {
                    listener.testRunTerminated();
                }
            });
            ++i;
        }
    }

    public void rerunTest(String testId, String className, String testName) {
        if (this.isRunning()) {
            this.fActualResult.setLength(0);
            this.fExpectedResult.setLength(0);
            this.fWriter.println(">RERUN  " + testId + " " + className + " " + testName);
            this.fWriter.flush();
        }
    }

    class AppendingProcessingState
    extends ProcessingState {
        private final StringBuffer fBuffer;
        private String fEndString;

        AppendingProcessingState(StringBuffer buffer, String endString) {
            this.fBuffer = buffer;
            this.fEndString = endString;
        }

        ProcessingState readMessage(String message) {
            if (message.startsWith(this.fEndString)) {
                this.entireStringRead();
                return RemoteTestRunnerClient.this.fDefaultState;
            }
            this.fBuffer.append(message);
            this.fBuffer.append('\n');
            return this;
        }

        void entireStringRead() {
        }
    }

    class DefaultProcessingState
    extends ProcessingState {
        DefaultProcessingState() {
        }

        ProcessingState readMessage(String message) {
            if (message.startsWith("%TRACES ")) {
                RemoteTestRunnerClient.this.fFailedTrace.setLength(0);
                return RemoteTestRunnerClient.this.fTraceState;
            }
            if (message.startsWith("%EXPECTS")) {
                RemoteTestRunnerClient.this.fExpectedResult.setLength(0);
                return RemoteTestRunnerClient.this.fExpectedState;
            }
            if (message.startsWith("%ACTUALS")) {
                RemoteTestRunnerClient.this.fActualResult.setLength(0);
                return RemoteTestRunnerClient.this.fActualState;
            }
            if (message.startsWith("%RTRACES")) {
                RemoteTestRunnerClient.this.fFailedRerunTrace.setLength(0);
                return RemoteTestRunnerClient.this.fRerunState;
            }
            String arg = message.substring(8);
            if (message.startsWith("%TESTC  ")) {
                int count = 0;
                int v = arg.indexOf(32);
                if (v == -1) {
                    RemoteTestRunnerClient.this.fVersion = "v1";
                    count = Integer.parseInt(arg);
                } else {
                    RemoteTestRunnerClient.this.fVersion = arg.substring(v + 1);
                    String sc = arg.substring(0, v);
                    count = Integer.parseInt(sc);
                }
                RemoteTestRunnerClient.this.notifyTestRunStarted(count);
                return this;
            }
            if (message.startsWith("%TESTS  ")) {
                RemoteTestRunnerClient.this.notifyTestStarted(arg);
                return this;
            }
            if (message.startsWith("%TESTE  ")) {
                RemoteTestRunnerClient.this.notifyTestEnded(arg);
                return this;
            }
            if (message.startsWith("%ERROR  ")) {
                RemoteTestRunnerClient.this.extractFailure(arg, 1);
                return this;
            }
            if (message.startsWith("%FAILED ")) {
                RemoteTestRunnerClient.this.extractFailure(arg, 2);
                return this;
            }
            if (message.startsWith("%RUNTIME")) {
                long elapsedTime = Long.parseLong(arg);
                RemoteTestRunnerClient.this.testRunEnded(elapsedTime);
                return this;
            }
            if (message.startsWith("%TSTSTP ")) {
                long elapsedTime = Long.parseLong(arg);
                RemoteTestRunnerClient.this.notifyTestRunStopped(elapsedTime);
                RemoteTestRunnerClient.this.shutDown();
                return this;
            }
            if (message.startsWith("%TSTTREE")) {
                RemoteTestRunnerClient.this.notifyTestTreeEntry(arg);
                return this;
            }
            if (message.startsWith("%TSTRERN")) {
                if (RemoteTestRunnerClient.this.hasTestId()) {
                    RemoteTestRunnerClient.this.scanReranMessage(arg);
                } else {
                    RemoteTestRunnerClient.this.scanOldReranMessage(arg);
                }
                return this;
            }
            return this;
        }
    }

    public abstract class ListenerSafeRunnable
    implements ISafeRunnable {
        public void handleException(Throwable exception) {
            JUnitCorePlugin.log(exception);
        }
    }

    abstract class ProcessingState {
        ProcessingState() {
        }

        abstract ProcessingState readMessage(String var1);
    }

    private class ServerConnection
    extends Thread {
        int fServerPort;

        public ServerConnection(int port) {
            super("ServerConnection");
            this.fServerPort = port;
        }

        public void run() {
            try {
                String message;
                if (RemoteTestRunnerClient.this.fDebug) {
                    System.out.println("Creating server socket " + this.fServerPort);
                }
                RemoteTestRunnerClient.this.fServerSocket = new ServerSocket(this.fServerPort);
                RemoteTestRunnerClient.this.fSocket = RemoteTestRunnerClient.this.fServerSocket.accept();
                try {
                    RemoteTestRunnerClient.this.fBufferedReader = new BufferedReader(new InputStreamReader(RemoteTestRunnerClient.this.fSocket.getInputStream(), "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    RemoteTestRunnerClient.this.fBufferedReader = new BufferedReader(new InputStreamReader(RemoteTestRunnerClient.this.fSocket.getInputStream()));
                }
                try {
                    RemoteTestRunnerClient.this.fWriter = new PrintWriter((Writer)new OutputStreamWriter(RemoteTestRunnerClient.this.fSocket.getOutputStream(), "UTF-8"), true);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    RemoteTestRunnerClient.this.fWriter = new PrintWriter((Writer)new OutputStreamWriter(RemoteTestRunnerClient.this.fSocket.getOutputStream()), true);
                }
                while (RemoteTestRunnerClient.this.fBufferedReader != null && (message = RemoteTestRunnerClient.this.readMessage(RemoteTestRunnerClient.this.fBufferedReader)) != null) {
                    RemoteTestRunnerClient.this.receiveMessage(message);
                }
            }
            catch (SocketException socketException) {
                RemoteTestRunnerClient.this.notifyTestRunTerminated();
            }
            catch (IOException e) {
                JUnitCorePlugin.log(e);
            }
            RemoteTestRunnerClient.this.shutDown();
        }
    }

    class TraceProcessingState
    extends AppendingProcessingState {
        TraceProcessingState() {
            super(RemoteTestRunnerClient.this.fFailedTrace, "%TRACEE ");
        }

        void entireStringRead() {
            RemoteTestRunnerClient.this.notifyTestFailed();
            RemoteTestRunnerClient.this.fExpectedResult.setLength(0);
            RemoteTestRunnerClient.this.fActualResult.setLength(0);
        }

        ProcessingState readMessage(String message) {
            if (message.startsWith("%TRACEE ")) {
                RemoteTestRunnerClient.this.notifyTestFailed();
                RemoteTestRunnerClient.this.fFailedTrace.setLength(0);
                RemoteTestRunnerClient.this.fActualResult.setLength(0);
                RemoteTestRunnerClient.this.fExpectedResult.setLength(0);
                return RemoteTestRunnerClient.this.fDefaultState;
            }
            RemoteTestRunnerClient.this.fFailedTrace.append(message).append('\n');
            return this;
        }
    }
}

