/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal;

import java.util.concurrent.ThreadFactory;
import org.eclipse.jpt.utility.Command;
import org.eclipse.jpt.utility.internal.ConsumerThreadCoordinator;
import org.eclipse.jpt.utility.internal.SimpleThreadFactory;
import org.eclipse.jpt.utility.internal.StatefulCommandExecutor;
import org.eclipse.jpt.utility.internal.SynchronizedQueue;

public class AsynchronousCommandExecutor
implements StatefulCommandExecutor {
    final SynchronizedQueue<Command> commands = new SynchronizedQueue();
    private final ConsumerThreadCoordinator consumerThreadCoordinator;

    public AsynchronousCommandExecutor() {
        this(SimpleThreadFactory.instance(), null);
    }

    public AsynchronousCommandExecutor(ThreadFactory threadFactory) {
        this(threadFactory, null);
    }

    public AsynchronousCommandExecutor(String threadName) {
        this(SimpleThreadFactory.instance(), threadName);
    }

    public AsynchronousCommandExecutor(ThreadFactory threadFactory, String threadName) {
        this.consumerThreadCoordinator = this.buildConsumerThreadCoordinator(threadFactory, threadName);
    }

    private ConsumerThreadCoordinator buildConsumerThreadCoordinator(ThreadFactory threadFactory, String threadName) {
        return new ConsumerThreadCoordinator(this.buildConsumer(), threadFactory, threadName);
    }

    private ConsumerThreadCoordinator.Consumer buildConsumer() {
        return new Consumer();
    }

    public void start() {
        this.consumerThreadCoordinator.start();
    }

    public void execute(Command command) {
        this.commands.enqueue(command);
    }

    public void stop() {
        this.consumerThreadCoordinator.stop();
    }

    class Consumer
    implements ConsumerThreadCoordinator.Consumer {
        Consumer() {
        }

        public void waitForProducer() throws InterruptedException {
            AsynchronousCommandExecutor.this.commands.waitUntilNotEmpty();
        }

        public void execute() {
            AsynchronousCommandExecutor.this.commands.dequeue().execute();
        }
    }
}

