/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal;

import java.util.Vector;
import java.util.concurrent.ThreadFactory;
import org.eclipse.jpt.utility.internal.CompositeException;
import org.eclipse.jpt.utility.internal.SimpleThreadFactory;
import org.eclipse.jpt.utility.internal.StringTools;

public class ConsumerThreadCoordinator {
    private final Runnable runnable;
    private final ThreadFactory threadFactory;
    private final String threadName;
    private volatile Thread thread;
    final Vector<Throwable> exceptions = new Vector();

    public ConsumerThreadCoordinator(Consumer consumer) {
        this(consumer, SimpleThreadFactory.instance());
    }

    public ConsumerThreadCoordinator(Consumer consumer, ThreadFactory threadFactory) {
        this(consumer, threadFactory, null);
    }

    public ConsumerThreadCoordinator(Consumer consumer, String threadName) {
        this(consumer, SimpleThreadFactory.instance(), threadName);
    }

    public ConsumerThreadCoordinator(Consumer consumer, ThreadFactory threadFactory, String threadName) {
        this.runnable = this.buildRunnable(consumer);
        this.threadFactory = threadFactory;
        this.threadName = threadName;
    }

    private Runnable buildRunnable(Consumer consumer) {
        return new RunnableConsumer(consumer);
    }

    public synchronized void start() {
        if (this.thread != null) {
            throw new IllegalStateException("Not stopped.");
        }
        this.thread = this.buildThread();
        this.thread.start();
    }

    private Thread buildThread() {
        Thread t = this.threadFactory.newThread(this.runnable);
        if (this.threadName != null) {
            t.setName(this.threadName);
        }
        return t;
    }

    public synchronized void stop() {
        if (this.thread == null) {
            throw new IllegalStateException("Not started.");
        }
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {}
        this.thread = null;
        if (this.exceptions.size() > 0) {
            Throwable[] temp = this.exceptions.toArray(new Throwable[this.exceptions.size()]);
            this.exceptions.clear();
            throw new CompositeException(temp);
        }
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.thread);
    }

    public static interface Consumer {
        public void waitForProducer() throws InterruptedException;

        public void execute();
    }

    private class RunnableConsumer
    implements Runnable {
        private final Consumer consumer;

        RunnableConsumer(Consumer consumer) {
            this.consumer = consumer;
        }

        public void run() {
            while (!Thread.interrupted()) {
                try {
                    this.consumer.waitForProducer();
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                this.execute();
            }
        }

        private void execute() {
            try {
                this.execute_();
            }
            catch (Throwable ex) {
                ConsumerThreadCoordinator.this.exceptions.add(ex);
            }
        }

        private void execute_() {
            this.consumer.execute();
        }
    }
}

