/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.Arrays;
import org.eclipse.jpt.utility.internal.model.value.CollectionListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.ItemAspectListValueModelAdapter;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.event.ListAddEvent;
import org.eclipse.jpt.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.model.event.ListClearEvent;
import org.eclipse.jpt.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemListListValueModelAdapter<E>
extends ItemAspectListValueModelAdapter<E> {
    protected final String[] listNames;
    protected final ListChangeListener itemListListener;

    public ItemListListValueModelAdapter(ListValueModel<E> listHolder, String ... listNames) {
        super(listHolder);
        this.listNames = listNames;
        this.itemListListener = this.buildItemListListener();
    }

    public ItemListListValueModelAdapter(CollectionValueModel<E> collectionHolder, String ... listNames) {
        this(new CollectionListValueModelAdapter<E>(collectionHolder), listNames);
    }

    protected ListChangeListener buildItemListListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListAddEvent event) {
                ItemListListValueModelAdapter.this.itemAspectChanged(event);
            }

            public void itemsRemoved(ListRemoveEvent event) {
                ItemListListValueModelAdapter.this.itemAspectChanged(event);
            }

            public void itemsReplaced(ListReplaceEvent event) {
                ItemListListValueModelAdapter.this.itemAspectChanged(event);
            }

            public void itemsMoved(ListMoveEvent event) {
                ItemListListValueModelAdapter.this.itemAspectChanged(event);
            }

            public void listCleared(ListClearEvent event) {
                ItemListListValueModelAdapter.this.itemAspectChanged(event);
            }

            public void listChanged(ListChangeEvent event) {
                ItemListListValueModelAdapter.this.itemAspectChanged(event);
            }

            public String toString() {
                return "item list listener: " + Arrays.asList(ItemListListValueModelAdapter.this.listNames);
            }
        };
    }

    @Override
    protected void engageItem_(Model item) {
        String[] stringArray = this.listNames;
        int n = this.listNames.length;
        int n2 = 0;
        while (n2 < n) {
            String listName = stringArray[n2];
            item.addListChangeListener(listName, this.itemListListener);
            ++n2;
        }
    }

    @Override
    protected void disengageItem_(Model item) {
        String[] stringArray = this.listNames;
        int n = this.listNames.length;
        int n2 = 0;
        while (n2 < n) {
            String listName = stringArray[n2];
            item.removeListChangeListener(listName, this.itemListListener);
            ++n2;
        }
    }
}

