/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.modulecore.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.common.internal.modulecore.util.ArchiveManifest;
import org.eclipse.jst.common.internal.modulecore.util.IJavaComponentDiscerner;
import org.eclipse.jst.common.internal.modulecore.util.ManifestUtilities;
import org.eclipse.jst.j2ee.model.IEARModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.EarUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.javaee.application.Application;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JEEManifestDiscerner
implements IJavaComponentDiscerner {
    public IProject[] findParentProjects(IProject child) {
        return EarUtilities.getReferencingEARProjects(child);
    }

    public IVirtualReference[] findPossibleManifestEntries(IProject parentProject, IProject childProject) {
        if (EarUtilities.isEARProject(parentProject)) {
            ArrayList<IVirtualReference> allPossible = this.findAllPossibleEntries(parentProject, childProject);
            IVirtualReference[] alreadyReferenced = this.findCurrentManifestEntries(parentProject, childProject, allPossible);
            allPossible.removeAll(Arrays.asList(alreadyReferenced));
            return allPossible.toArray(new IVirtualReference[allPossible.size()]);
        }
        return new IVirtualReference[0];
    }

    public IVirtualReference[] findPossibleManifestEntries(IProject parentProject, IProject childProject, IVirtualReference[] currentEntries) {
        if (EarUtilities.isEARProject(parentProject)) {
            ArrayList<IVirtualReference> allPossible = this.findAllPossibleEntries(parentProject, childProject);
            allPossible.removeAll(Arrays.asList(currentEntries));
            return allPossible.toArray(new IVirtualReference[allPossible.size()]);
        }
        return new IVirtualReference[0];
    }

    protected ArrayList<IVirtualReference> findAllPossibleEntries(IProject parentProject, IProject childProject) {
        IVirtualComponent ear = ComponentCore.createComponent((IProject)parentProject);
        IVirtualReference[] hardRefs = ear.getReferences();
        IVirtualReference[] actual_tmp = this.trimEarHardRefs(ear, childProject, hardRefs);
        IVirtualReference[] actual_clean = this.cleanHardRefs(actual_tmp);
        ArrayList<IVirtualReference> refs = new ArrayList<IVirtualReference>();
        refs.addAll(Arrays.asList(actual_clean));
        return refs;
    }

    private IVirtualReference[] trimEarHardRefs(IVirtualComponent ear, IProject childProject, IVirtualReference[] hardRefs) {
        IEARModelProvider earModel;
        Application app;
        String earLibDir = null;
        if (JavaEEProjectUtilities.isJEEComponent(ear) && (earLibDir = (app = (Application)(earModel = (IEARModelProvider)ModelProviderManager.getModelProvider(ear.getProject())).getModelObject()).getLibraryDirectory()) == null) {
            earLibDir = "/lib";
        }
        ArrayList<IVirtualReference> refs = new ArrayList<IVirtualReference>();
        int i = 0;
        while (i < hardRefs.length) {
            if (!(!hardRefs[i].getReferencedComponent().isBinary() && hardRefs[i].getDependencyType() != 1 && hardRefs[i].getReferencedComponent().getProject().equals((Object)childProject) || !hardRefs[i].getArchiveName().endsWith("jar") || earLibDir != null && hardRefs[i].getRuntimePath().equals((Object)new Path(earLibDir)))) {
                refs.add(hardRefs[i]);
            }
            ++i;
        }
        return refs.toArray(new IVirtualReference[refs.size()]);
    }

    private IVirtualReference[] cleanHardRefs(IVirtualReference[] original) {
        IVirtualReference[] newRefs = new IVirtualReference[original.length];
        int i = 0;
        while (i < newRefs.length) {
            newRefs[i] = ComponentCore.createReference((IVirtualComponent)original[i].getEnclosingComponent(), (IVirtualComponent)original[i].getReferencedComponent(), (IPath)original[i].getRuntimePath().makeRelative());
            newRefs[i].setDependencyType(original[i].getDependencyType());
            newRefs[i].setArchiveName(original[i].getArchiveName());
            ++i;
        }
        return newRefs;
    }

    public IVirtualReference[] findCurrentManifestEntries(IProject parentProject, IProject childProject) {
        return this.findCurrentManifestEntries(parentProject, childProject, this.findAllPossibleEntries(parentProject, childProject));
    }

    protected IVirtualReference[] findCurrentManifestEntries(IProject parentProject, IProject childProject, ArrayList<IVirtualReference> allPossible2) {
        ArrayList<IVirtualReference> allPossible = new ArrayList<IVirtualReference>();
        allPossible.addAll(allPossible2);
        ArchiveManifest manifest = ManifestUtilities.getManifest((IFile)this.getManifestFile(childProject));
        List<String> entries = Arrays.asList(manifest.getClassPathTokenized());
        Iterator i = allPossible.iterator();
        while (i.hasNext()) {
            IVirtualReference currentI = (IVirtualReference)i.next();
            String currentEntry = currentI.getRuntimePath().append(currentI.getArchiveName()).toString();
            if (entries.contains(currentEntry)) continue;
            i.remove();
        }
        return allPossible.toArray(new IVirtualReference[allPossible.size()]);
    }

    protected IFile getManifestFile(IProject child) {
        IVirtualComponent root = ComponentCore.createComponent((IProject)child);
        IVirtualFolder rootFolder = root.getRootFolder();
        IVirtualFile vf = rootFolder.getFile((IPath)new Path("META-INF/MANIFEST.MF"));
        if (vf.exists()) {
            return vf.getUnderlyingFile();
        }
        return null;
    }
}

