/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.ui.internal.contentproperties.ui;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.wst.css.core.internal.contentproperties.CSSContentProperties;
import org.eclipse.wst.css.core.internal.metamodel.CSSProfile;
import org.eclipse.wst.css.core.internal.metamodel.CSSProfileRegistry;
import org.eclipse.wst.html.core.internal.contentproperties.HTMLContentProperties;
import org.eclipse.wst.html.core.internal.document.HTMLDocumentTypeEntry;
import org.eclipse.wst.html.core.internal.document.HTMLDocumentTypeRegistry;
import org.eclipse.wst.html.ui.internal.HTMLUIMessages;
import org.eclipse.wst.html.ui.internal.Logger;

public class WebContentSettingsPropertyPage
extends PropertyPage {
    private static final String SELECT_NONE = HTMLUIMessages.UI_none;
    private String maxLengthStringInHTMLDocumentTypeRegistry = "";
    Combo fDocumentTypeCombo;
    List fDocumentTypeIds;
    private Text fPublicIdText;
    private Text fSystemIdText;
    private Combo fProfileCombo;
    private List fProfileIds;
    private SelectionListener fListener;
    static /* synthetic */ Class class$0;

    public WebContentSettingsPropertyPage() {
        this.setDescription(HTMLUIMessages.WebContentSettingsPropertyPage_0);
    }

    private Composite createComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, false);
        data.horizontalIndent = 0;
        composite.setLayoutData((Object)data);
        return composite;
    }

    protected Control createContents(Composite parent) {
        Composite propertyPage = this.createComposite(parent, 2);
        this.createDoctypeContents(propertyPage);
        this.createCSSProfileContents(propertyPage);
        this.populateValues();
        this.initializeValues();
        this.computeMaxWidthHint();
        this.fListener = new ComboSelectionListener();
        this.fDocumentTypeCombo.addSelectionListener(this.fListener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)propertyPage, "org.eclipse.wst.html.ui.misc0170");
        Dialog.applyDialogFont((Control)parent);
        return propertyPage;
    }

    private void createCSSProfileContents(Composite parent) {
        Label languageLabel = new Label(parent, 0);
        languageLabel.setText(HTMLUIMessages.UI_CSS_profile___2);
        this.fProfileCombo = new Combo(parent, 8);
        GridData data = new GridData(4, 4, true, false);
        data.horizontalIndent = 0;
        this.fProfileCombo.setLayoutData((Object)data);
    }

    private void createDoctypeContents(Composite parent) {
        Text doctypeLabel = new Text(parent, 8);
        doctypeLabel.setText(HTMLUIMessages.UI_Description_of_role_of_following_DOCTYPE);
        GridData data = new GridData(4, 4, true, false);
        data.horizontalIndent = 0;
        data.horizontalSpan = 2;
        doctypeLabel.setLayoutData((Object)data);
        Label languageLabel = new Label(parent, 0);
        languageLabel.setText(HTMLUIMessages.UI_Default_HTML_DOCTYPE_ID___1);
        this.fDocumentTypeCombo = new Combo(parent, 8);
        data = new GridData(4, 4, true, false);
        data.horizontalIndent = 0;
        this.fDocumentTypeCombo.setLayoutData((Object)data);
        Label publicIdLabel = new Label(parent, 0);
        publicIdLabel.setText(HTMLUIMessages.UI_Public_ID);
        this.fPublicIdText = new Text(parent, 2056);
        data = new GridData(4, 4, true, false);
        data.horizontalIndent = 0;
        this.fPublicIdText.setLayoutData((Object)data);
        Label systemIdLabel = new Label(parent, 0);
        systemIdLabel.setText(HTMLUIMessages.UI_System_ID);
        this.fSystemIdText = new Text(parent, 2056);
        data = new GridData(4, 4, true, false);
        data.horizontalIndent = 0;
        this.fSystemIdText.setLayoutData((Object)data);
        Label label = new Label(parent, 258);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        data.verticalSpan = 8;
        label.setLayoutData((Object)data);
    }

    private IResource getResource() {
        IResource resource = null;
        IAdaptable adaptable = this.getElement();
        if (adaptable instanceof IResource) {
            resource = (IResource)adaptable;
        } else if (adaptable != null) {
            Object o;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((o = adaptable.getAdapter((Class)clazz)) instanceof IResource) {
                resource = (IResource)o;
            }
        }
        return resource;
    }

    private String getSystemIdFrom(String publicId) {
        if (publicId == null || publicId.length() == 0) {
            return null;
        }
        HTMLDocumentTypeRegistry reg = HTMLDocumentTypeRegistry.getInstance();
        Enumeration e = reg.getEntries();
        while (e.hasMoreElements()) {
            HTMLDocumentTypeEntry entry = (HTMLDocumentTypeEntry)e.nextElement();
            if (!entry.getPublicId().equals(publicId)) continue;
            return entry.getSystemId();
        }
        return null;
    }

    private void initializeValues() {
        this.initializeDoctypeValues();
        this.initializeCSSProfileValues();
    }

    private void initializeCSSProfileValues() {
        int index = 0;
        String profile = CSSContentProperties.getProperty((String)"css-profile", (IResource)this.getResource(), (boolean)false);
        if (profile != null && profile.length() > 0) {
            index = this.fProfileIds.indexOf(profile);
        }
        index = index >= 0 ? index : 0;
        this.fProfileCombo.select(index);
    }

    private void initializeDoctypeValues() {
        int index = 0;
        String doctype = HTMLContentProperties.getProperty((String)"document-type", (IResource)this.getResource(), (boolean)false);
        if (doctype != null && doctype.length() > 0) {
            index = this.fDocumentTypeIds.indexOf(doctype);
        }
        index = index >= 0 ? index : 0;
        this.fDocumentTypeCombo.select(index);
        this.updateDoctypeText(index, doctype);
    }

    void updateDoctypeText(int index, String doctype) {
        if (index > 0) {
            this.fPublicIdText.setText(doctype);
            String systemId = this.getSystemIdFrom(doctype);
            if (systemId != null) {
                this.fSystemIdText.setText(systemId);
            } else {
                this.fSystemIdText.setText("");
            }
        } else {
            this.fPublicIdText.setText("");
            this.fSystemIdText.setText("");
        }
    }

    private void populateValues() {
        this.populateDoctypeValues();
        this.populateCSSProfileValues();
    }

    private void populateCSSProfileValues() {
        this.fProfileIds = new ArrayList();
        this.fProfileCombo.add(SELECT_NONE);
        this.fProfileIds.add(null);
        CSSProfileRegistry reg = CSSProfileRegistry.getInstance();
        Iterator i = reg.getProfiles();
        while (i.hasNext()) {
            CSSProfile profile = (CSSProfile)i.next();
            String id = profile.getProfileID();
            String name = profile.getProfileName();
            this.fProfileCombo.add(name);
            this.fProfileIds.add(id);
        }
    }

    private void populateDoctypeValues() {
        this.fDocumentTypeIds = new ArrayList();
        this.fDocumentTypeCombo.add(SELECT_NONE);
        this.fDocumentTypeIds.add(null);
        HTMLDocumentTypeRegistry reg = HTMLDocumentTypeRegistry.getInstance();
        Enumeration e = reg.getEntries();
        while (e.hasMoreElements()) {
            HTMLDocumentTypeEntry entry = (HTMLDocumentTypeEntry)e.nextElement();
            String publicId = entry.getPublicId();
            String displayName = entry.getDisplayName();
            displayName = displayName != null ? displayName : publicId;
            this.fDocumentTypeCombo.add(displayName);
            this.fDocumentTypeIds.add(publicId);
            if (displayName.length() > this.maxLengthStringInHTMLDocumentTypeRegistry.length()) {
                this.maxLengthStringInHTMLDocumentTypeRegistry = displayName;
            }
            if (entry.getSystemId() == null || entry.getSystemId().length() <= this.maxLengthStringInHTMLDocumentTypeRegistry.length()) continue;
            this.maxLengthStringInHTMLDocumentTypeRegistry = entry.getSystemId();
        }
    }

    private void computeMaxWidthHint() {
        String maxLengthString = this.maxLengthStringInHTMLDocumentTypeRegistry;
        String backup = this.fSystemIdText.getText();
        this.fSystemIdText.setText(maxLengthString);
        int maxWidthHint = this.fSystemIdText.computeSize((int)-1, (int)-1).x;
        this.fSystemIdText.setText(backup);
        if (this.fDocumentTypeCombo.getLayoutData() != null) {
            ((GridData)this.fDocumentTypeCombo.getLayoutData()).widthHint = maxWidthHint;
        }
        if (this.fPublicIdText.getLayoutData() != null) {
            ((GridData)this.fPublicIdText.getLayoutData()).widthHint = maxWidthHint;
        }
        if (this.fSystemIdText.getLayoutData() != null) {
            ((GridData)this.fSystemIdText.getLayoutData()).widthHint = maxWidthHint;
        }
        if (this.fProfileCombo.getLayoutData() != null) {
            ((GridData)this.fProfileCombo.getLayoutData()).widthHint = maxWidthHint;
        }
    }

    private void performCSSProfileDefaults() {
        int index = this.fProfileCombo.indexOf(SELECT_NONE);
        if (index > -1) {
            this.fProfileCombo.select(index);
        }
        super.performDefaults();
    }

    private boolean performCSSProfileOk() {
        int index = this.fProfileCombo.getSelectionIndex();
        if (index > -1) {
            String id = (String)this.fProfileIds.get(index);
            if (id == null || id.length() == 0 || id.equalsIgnoreCase(SELECT_NONE)) {
                id = null;
            }
            try {
                CSSContentProperties.setProperty((String)"css-profile", (IResource)this.getResource(), (String)id);
            }
            catch (CoreException e) {
                Logger.log(202, e.getMessage(), e);
            }
        }
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.performDoctypeDefaults();
        this.performCSSProfileDefaults();
    }

    private void performDoctypeDefaults() {
        this.fPublicIdText.setText("");
        this.fSystemIdText.setText("");
    }

    private boolean performDoctypeOk() {
        int index = this.fDocumentTypeCombo.getSelectionIndex();
        if (index > -1) {
            String id = (String)this.fDocumentTypeIds.get(index);
            if (id == null || id.length() == 0 || id.equalsIgnoreCase(SELECT_NONE)) {
                id = null;
            }
            try {
                HTMLContentProperties.setProperty((String)"document-type", (IResource)this.getResource(), (String)id);
            }
            catch (CoreException e) {
                Logger.log(202, e.getMessage(), e);
            }
        }
        return true;
    }

    public boolean performOk() {
        this.performDoctypeOk();
        this.performCSSProfileOk();
        return super.performOk();
    }

    private class ComboSelectionListener
    implements SelectionListener {
        private ComboSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            int index = WebContentSettingsPropertyPage.this.fDocumentTypeCombo.getSelectionIndex();
            String doctype = (String)WebContentSettingsPropertyPage.this.fDocumentTypeIds.get(index);
            WebContentSettingsPropertyPage.this.updateDoctypeText(index, doctype);
        }
    }
}

