/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.wizards.orm;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jpt.core.internal.operations.OrmFileCreationDataModelProperties;
import org.eclipse.jpt.core.internal.utility.jdt.JDTTools;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;

public class MappingFileWizardPage
extends DataModelWizardPage
implements OrmFileCreationDataModelProperties {
    private Label projectNameLabel;
    private Combo projectNameCombo;
    private Label sourceFolderLabel;
    private Text sourceFolderText;
    private Label filePathLabel;
    private Text filePathText;
    private Label accessLabel;
    private Combo accessCombo;
    private Button addToPersistenceUnitButton;
    private Label persistenceUnitLabel;
    private Combo persistenceUnitCombo;

    public MappingFileWizardPage(IDataModel dataModel, String pageName) {
        super(dataModel, pageName);
        this.setTitle(JptUiMessages.MappingFileWizardPage_title);
        this.setDescription(JptUiMessages.MappingFileWizardPage_desc);
        this.setPageComplete(false);
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"JpaFileCreationDataModelProperties.PROJECT_NAME", "JpaFileCreationDataModelProperties.SOURCE_FOLDER", "JpaFileCreationDataModelProperties.FILE_PATH", "OrmFileCreationDataModelProperties.DEFAULT_ACCESS", "OrmFileCreationDataModelProperties.ADD_TO_PERSISTENCE_UNIT", "OrmFileCreationDataModelProperties.PERSISTENCE_UNIT"};
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        this.projectNameLabel = new Label(composite, 0);
        this.projectNameLabel.setText(JptUiMessages.MappingFileWizardPage_projectLabel);
        data = new GridData();
        this.projectNameLabel.setLayoutData((Object)data);
        this.projectNameCombo = new Combo(composite, 2056);
        data = new GridData(768);
        data.horizontalSpan = 1;
        data.grabExcessHorizontalSpace = true;
        this.projectNameCombo.setLayoutData((Object)data);
        this.synchHelper.synchCombo(this.projectNameCombo, "JpaFileCreationDataModelProperties.PROJECT_NAME", null);
        new Label(composite, 0);
        this.sourceFolderLabel = new Label(composite, 0);
        this.sourceFolderLabel.setText(JptUiMessages.MappingFileWizardPage_sourceFolderLabel);
        data = new GridData();
        this.sourceFolderLabel.setLayoutData((Object)data);
        this.sourceFolderText = new Text(composite, 2048);
        data = new GridData(768);
        data.horizontalSpan = 1;
        data.grabExcessHorizontalSpace = true;
        this.sourceFolderText.setLayoutData((Object)data);
        this.synchHelper.synchText(this.sourceFolderText, "JpaFileCreationDataModelProperties.SOURCE_FOLDER", null);
        Button sourceFolderButton = new Button(composite, 8);
        sourceFolderButton.setText(JptUiMessages.General_browse);
        data = new GridData();
        data.horizontalSpan = 1;
        sourceFolderButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                MappingFileWizardPage.this.handleSourceFolderButtonPressed();
            }
        });
        Label separator = new Label(composite, 258);
        data = new GridData(4, 1, true, false, 3, 1);
        data.verticalIndent = 5;
        separator.setLayoutData((Object)data);
        this.filePathLabel = new Label(composite, 0);
        this.filePathLabel.setText(JptUiMessages.MappingFileWizardPage_filePathLabel);
        data = new GridData();
        data.verticalIndent = 5;
        this.filePathLabel.setLayoutData((Object)data);
        this.filePathText = new Text(composite, 2048);
        data = new GridData(768);
        data.horizontalSpan = 1;
        data.verticalIndent = 5;
        data.grabExcessHorizontalSpace = true;
        this.filePathText.setLayoutData((Object)data);
        this.synchHelper.synchText(this.filePathText, "JpaFileCreationDataModelProperties.FILE_PATH", null);
        new Label(composite, 0);
        this.accessLabel = new Label(composite, 0);
        this.accessLabel.setText(JptUiMessages.MappingFileWizardPage_accessLabel);
        data = new GridData();
        this.accessLabel.setLayoutData((Object)data);
        this.accessCombo = new Combo(composite, 2056);
        data = new GridData(768);
        data.horizontalSpan = 1;
        data.grabExcessHorizontalSpace = true;
        this.accessCombo.setLayoutData((Object)data);
        this.synchHelper.synchCombo(this.accessCombo, "OrmFileCreationDataModelProperties.DEFAULT_ACCESS", null);
        new Label(composite, 0);
        this.addToPersistenceUnitButton = new Button(composite, 33);
        this.addToPersistenceUnitButton.setText(JptUiMessages.MappingFileWizardPage_addToPersistenceUnitButton);
        data = new GridData(768);
        data.horizontalSpan = 3;
        data.verticalIndent = 10;
        this.addToPersistenceUnitButton.setLayoutData((Object)data);
        this.synchHelper.synchCheckbox(this.addToPersistenceUnitButton, "OrmFileCreationDataModelProperties.ADD_TO_PERSISTENCE_UNIT", null);
        this.persistenceUnitLabel = new Label(composite, 0);
        this.persistenceUnitLabel.setText(JptUiMessages.MappingFileWizardPage_persistenceUnitLabel);
        data = new GridData();
        data.horizontalIndent = 10;
        this.persistenceUnitLabel.setLayoutData((Object)data);
        this.persistenceUnitLabel.setEnabled(false);
        this.addToPersistenceUnitButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MappingFileWizardPage.this.persistenceUnitLabel.setEnabled(MappingFileWizardPage.this.addToPersistenceUnitButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.persistenceUnitCombo = new Combo(composite, 2056);
        data = new GridData(768);
        data.horizontalSpan = 1;
        data.grabExcessHorizontalSpace = true;
        this.persistenceUnitCombo.setLayoutData((Object)data);
        this.synchHelper.synchCombo(this.persistenceUnitCombo, "OrmFileCreationDataModelProperties.PERSISTENCE_UNIT", null);
        new Label(composite, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, this.getInfopopID());
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    private void handleSourceFolderButtonPressed() {
        Object element;
        ISelectionStatusValidator validator = this.getSourceFolderDialogSelectionValidator();
        ViewerFilter filter = this.getSourceFolderDialogViewerFilter();
        WorkbenchContentProvider contentProvider = new WorkbenchContentProvider();
        WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
        dialog.setValidator(validator);
        dialog.setTitle(JptUiMessages.MappingFileWizardPage_accessLabel_sourceFolderDialogTitle);
        dialog.setMessage(JptUiMessages.MappingFileWizardPage_accessLabel_sourceFolderDialogDesc);
        dialog.addFilter(filter);
        String projectName = this.model.getStringProperty("JpaFileCreationDataModelProperties.PROJECT_NAME");
        if (projectName == null || projectName.length() == 0) {
            return;
        }
        IProject project = ProjectUtilities.getProject((String)projectName);
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        if (project != null) {
            dialog.setInitialSelection((Object)project);
        }
        if (dialog.open() == 0 && (element = dialog.getFirstResult()) instanceof IContainer) {
            IContainer container = (IContainer)element;
            this.model.setProperty("JpaFileCreationDataModelProperties.SOURCE_FOLDER", (Object)container.getFullPath().toPortableString());
        }
    }

    private ISelectionStatusValidator getSourceFolderDialogSelectionValidator() {
        return new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection != null && selection[0] != null && !(selection[0] instanceof IProject)) {
                    return Status.OK_STATUS;
                }
                return new Status(4, "org.eclipse.jpt.ui", JptUiMessages.MappingFileWizardPage_incorrectSourceFolderError);
            }
        };
    }

    private ViewerFilter getSourceFolderDialogViewerFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                if (element instanceof IProject) {
                    IProject project = (IProject)element;
                    return project.getName().equals(MappingFileWizardPage.this.model.getProperty("JpaFileCreationDataModelProperties.PROJECT_NAME"));
                }
                if (element instanceof IFolder) {
                    IFolder folder = (IFolder)element;
                    IProject project = ProjectUtilities.getProject((String)MappingFileWizardPage.this.model.getStringProperty("JpaFileCreationDataModelProperties.PROJECT_NAME"));
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    if (JDTTools.packageFragmentRootIsSourceFolder((IPackageFragmentRoot)javaProject.getPackageFragmentRoot((IResource)folder))) {
                        return true;
                    }
                }
                return false;
            }
        };
    }

    void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

