/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.BaseOverride;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.context.java.JavaOverride;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.OverrideAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaOverride
extends AbstractJavaJpaContextNode
implements JavaOverride {
    protected String name;
    protected final JavaOverride.Owner owner;
    protected OverrideAnnotation overrideAnnotation;

    public AbstractJavaOverride(JavaJpaContextNode parent, JavaOverride.Owner owner) {
        super(parent);
        this.owner = owner;
    }

    protected void initialize(OverrideAnnotation overrideAnnotation) {
        this.overrideAnnotation = overrideAnnotation;
        this.initializeName();
    }

    protected void update(OverrideAnnotation overrideResource) {
        this.overrideAnnotation = overrideResource;
        this.updateName();
    }

    @Override
    public OverrideAnnotation getOverrideAnnotation() {
        return this.overrideAnnotation;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String prefix = this.getOwner().getPossiblePrefix();
        String unprefixedName = newName;
        if (newName != null && prefix != null && newName.startsWith(prefix)) {
            unprefixedName = newName.substring(newName.indexOf(46) + 1);
        }
        String oldName = this.name;
        this.name = unprefixedName;
        this.overrideAnnotation.setName(newName);
        this.firePropertyChanged("name", oldName, unprefixedName);
    }

    protected void setName_(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.firePropertyChanged("name", oldName, newName);
    }

    protected void initializeName() {
        String name = this.getResourceName();
        String prefix = this.getOwner().getPossiblePrefix();
        if (name != null && prefix != null && name.startsWith(prefix)) {
            name = name.substring(name.indexOf(46) + 1);
        }
        this.name = name;
    }

    protected void updateName() {
        String name = this.getResourceName();
        String prefix = this.getOwner().getPossiblePrefix();
        if (name != null && prefix != null && name.startsWith(prefix)) {
            name = name.substring(name.indexOf(46) + 1);
        }
        this.setName_(name);
    }

    protected String getResourceName() {
        return this.overrideAnnotation.getName();
    }

    @Override
    public boolean isVirtual() {
        return this.getOwner().isVirtual(this);
    }

    @Override
    public BaseOverride setVirtual(boolean virtual) {
        return this.getOwner().setVirtual(virtual, this);
    }

    public JavaOverride.Owner getOwner() {
        return this.owner;
    }

    @Override
    public JavaJpaContextNode getParent() {
        return (JavaJpaContextNode)super.getParent();
    }

    protected abstract Iterator<String> candidateNames();

    private Iterator<String> candidateNames(Filter<String> filter) {
        return new FilteringIterator(this.candidateNames(), filter);
    }

    private Iterator<String> javaCandidateNames(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals(this.candidateNames(filter));
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.nameTouches(pos, astRoot)) {
            return this.javaCandidateNames(filter);
        }
        return null;
    }

    public boolean nameTouches(int pos, CompilationUnit astRoot) {
        return this.overrideAnnotation.nameTouches(pos, astRoot);
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.overrideAnnotation.getTextRange(astRoot);
        return textRange != null ? textRange : this.getParent().getValidationTextRange(astRoot);
    }

    public void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(this.getName());
    }
}

