/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.facet;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jpt.core.internal.facet.JpaFacetActionDelegate;
import org.eclipse.jpt.core.internal.facet.JpaFacetInstallDataModelProperties;
import org.eclipse.jpt.db.JptDbPlugin;
import org.eclipse.jpt.utility.internal.ArrayTools;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class JpaFacetInstallDelegate
extends JpaFacetActionDelegate
implements JpaFacetInstallDataModelProperties {
    protected void execute_(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        super.execute_(project, fv, config, monitor);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IDataModel dataModel = (IDataModel)config;
        monitor.beginTask("", 1);
        this.addDbDriverLibraryToClasspath(javaProject, dataModel, monitor);
        monitor.worked(1);
    }

    protected void addDbDriverLibraryToClasspath(IJavaProject javaProject, IDataModel dataModel, IProgressMonitor monitor) throws CoreException {
        if (!dataModel.getBooleanProperty("JpaFacetInstallDataModelProperties.USER_WANTS_TO_ADD_DB_DRIVER_JARS_TO_CLASSPATH")) {
            return;
        }
        String driverName = dataModel.getStringProperty("JpaFacetInstallDataModelProperties.DB_DRIVER_NAME");
        IClasspathContainer container = JptDbPlugin.instance().buildDriverClasspathContainerFor(driverName);
        IClasspathEntry entry = JavaCore.newContainerEntry((IPath)container.getPath());
        this.addClasspathEntryToProject(entry, javaProject, monitor);
    }

    private void addClasspathEntryToProject(IClasspathEntry classpathEntry, IJavaProject javaProject, IProgressMonitor monitor) throws CoreException {
        Object[] classpath = javaProject.getRawClasspath();
        if (ArrayTools.contains((Object[])classpath, (Object)classpathEntry)) {
            return;
        }
        int len = classpath.length;
        IClasspathEntry[] newClasspath = new IClasspathEntry[len + 1];
        System.arraycopy(classpath, 0, newClasspath, 0, len);
        newClasspath[len] = classpathEntry;
        javaProject.setRawClasspath(newClasspath, monitor);
    }
}

